/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.util.Vector;
import net.sourceforge.jtds.jdbc.Column;
import net.sourceforge.jtds.jdbc.Tds;
import net.sourceforge.jtds.jdbc.TdsException;

public class Columns {
    public static final String cvsVersion = "$Id: Columns.java,v 1.1 2002/10/14 10:48:59 alin_sinpalean Exp $";
    private Vector columns = null;
    private int columnCount = 0;
    private int fakeColCount = 0;

    public Columns() {
        this(10);
    }

    public Columns(int n) {
        this.columns = new Vector(n);
    }

    public void setCatalog(int n, String string) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setCatalog(string);
    }

    public void setSchema(int n, String string) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setSchema(string);
    }

    public void setName(int n, String string) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setName(string);
    }

    public void setDisplaySize(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setDisplaySize(n2);
    }

    public void setBufferSize(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setBufferSize(n2);
    }

    public void setLabel(int n, String string) {
        ((Column)this.columns.elementAt(n - 1)).setLabel(string);
    }

    public void setNativeType(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setType(n2);
    }

    public void setPrecision(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setPrecision(n2);
    }

    public void setScale(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setScale(n2);
    }

    public void setAutoIncrement(int n, boolean bl) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setAutoIncrement(bl);
    }

    public void setNullable(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setNullable(n2);
    }

    public void setReadOnly(int n, boolean bl) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setReadOnly(bl);
    }

    public void setCaseSensitive(int n, boolean bl) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setCaseSensitive(bl);
    }

    public void setJdbcType(int n, int n2) throws SQLException {
        try {
            this.setNativeType(n, Tds.cvtJdbcTypeToNativeType(n2));
        }
        catch (TdsException tdsException) {
            throw new SQLException("TDS error- " + tdsException.getMessage());
        }
    }

    public void setTableName(int n, String string) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setTableName(string);
    }

    public Column getColumn(int n) {
        this.resize(n);
        return (Column)this.columns.elementAt(n - 1);
    }

    public int realColumnCount() {
        return this.columnCount;
    }

    public int fakeColumnCount() {
        return this.fakeColCount;
    }

    public void setFakeColumnCount(int n) {
        this.fakeColCount = n;
    }

    public String getCatalog(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getCatalog();
    }

    public String getSchema(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getSchema();
    }

    public String getName(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getName();
    }

    public int getDisplaySize(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getDisplaySize();
    }

    public int getBufferSize(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getBufferSize();
    }

    public String getLabel(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getLabel();
    }

    public int getNativeType(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getType();
    }

    public int getJdbcType(int n) throws SQLException {
        try {
            return Tds.cvtNativeTypeToJdbcType(this.getNativeType(n), this.getBufferSize(n));
        }
        catch (TdsException tdsException) {
            throw new SQLException("TDS error- " + tdsException.getMessage());
        }
    }

    public int getPrecision(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getPrecision();
    }

    public int getScale(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getScale();
    }

    public Boolean isAutoIncrement(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isAutoIncrement();
    }

    public int isNullable(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isNullable();
    }

    public Boolean isReadOnly(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isReadOnly();
    }

    public Boolean isCaseSensitive(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isCaseSensitive();
    }

    public String getTableName(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getTableName();
    }

    public Columns merge(Columns columns) throws TdsException {
        if (this.columnCount != columns.columnCount) {
            throw new TdsException("Confused. Mismatch in number of columns");
        }
        int n = 1;
        while (n <= this.columnCount) {
            if (this.getName(n) == null) {
                this.setName(n, columns.getName(n));
            } else if (columns.getName(n) != null) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getLabel(n) == null) {
                this.setLabel(n, columns.getLabel(n));
            } else if (columns.getLabel(n) != null) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getTableName(n) == null) {
                this.setTableName(n, columns.getTableName(n));
            } else if (columns.getTableName(n) != null) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getDisplaySize(n) == -1) {
                this.setDisplaySize(n, columns.getDisplaySize(n));
            } else if (columns.getDisplaySize(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getBufferSize(n) == -1) {
                this.setBufferSize(n, columns.getBufferSize(n));
            } else if (columns.getBufferSize(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getNativeType(n) == -1) {
                this.setNativeType(n, columns.getNativeType(n));
            } else if (columns.getNativeType(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getPrecision(n) == -1) {
                this.setPrecision(n, columns.getPrecision(n));
            } else if (columns.getPrecision(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getScale(n) == -1) {
                this.setScale(n, columns.getScale(n));
            } else if (columns.getScale(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.readOnlyWasSet(n)) {
                this.setReadOnly(n, columns.isReadOnly(n));
            } else if (columns.readOnlyWasSet(n)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.autoIncrementWasSet(n)) {
                this.setAutoIncrement(n, columns.isAutoIncrement(n));
            } else if (columns.autoIncrementWasSet(n)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.caseSensitiveWasSet(n)) {
                this.setCaseSensitive(n, columns.isCaseSensitive(n));
            } else if (columns.caseSensitiveWasSet(n)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.nullableWasSet(n)) {
                this.setNullable(n, columns.isNullable(n));
            } else if (columns.nullableWasSet(n)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            ++n;
        }
        return this;
    }

    public boolean autoIncrementWasSet(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isAutoIncrement() != null;
    }

    public boolean nullableWasSet(int n) {
        return this.isNullable(n) != 2;
    }

    public boolean readOnlyWasSet(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isReadOnly() != null;
    }

    public boolean caseSensitiveWasSet(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isCaseSensitive() != null;
    }

    private void resize(int n) {
        if (n > this.columnCount) {
            this.columnCount = n;
            this.fakeColCount = n;
        }
        if (this.columns.size() <= n) {
            this.columns.setSize(n + 1);
        }
        if (this.columns.elementAt(n - 1) == null) {
            this.columns.setElementAt(new Column(), n - 1);
        }
    }
}

