/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.sourceforge.jtds.jdbc.PacketOutputParamResult;
import net.sourceforge.jtds.jdbc.PacketRetStatResult;
import net.sourceforge.jtds.jdbc.ParameterUtils;
import net.sourceforge.jtds.jdbc.PreparedStatement_base;
import net.sourceforge.jtds.jdbc.TdsConnection;

public class CallableStatement_base
extends PreparedStatement_base
implements CallableStatement {
    public static final String cvsVersion = "$Id: CallableStatement_base.java,v 1.3 2002/10/24 12:27:55 alin_sinpalean Exp $";
    private String procedureName = "";
    private boolean lastWasNull = false;
    private int lastOutParam = -1;

    public CallableStatement_base(TdsConnection tdsConnection, String string) throws SQLException {
        this(tdsConnection, string, 1003, 1007);
    }

    public CallableStatement_base(TdsConnection tdsConnection, String string, int n, int n2) throws SQLException {
        super(tdsConnection, string, n, n2);
        int n3 = 0;
        int n4 = string.indexOf("{call ");
        if (n4 >= 0) {
            n3 = n4 + 6;
        }
        while (n3 < string.length() && !Character.isLetterOrDigit(string.charAt(n3)) && string.charAt(n3) != '#') {
            ++n3;
        }
        n4 = n3;
        while (n3 < string.length() && (Character.isLetterOrDigit(string.charAt(n3)) || string.charAt(n3) == '#' || string.charAt(n3) == '_' || string.charAt(n3) == '.')) {
            ++n3;
        }
        this.procedureName = string.substring(n4, n3);
        if (this.procedureName.length() == 0) {
            throw new SQLException("Did not find name in sql string");
        }
    }

    private Object getParam(int n) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid parameter index " + n + ". JDBC indexes start at 1.");
        }
        if (n > this.parameterList.length) {
            throw new SQLException("Invalid parameter index " + n + ". This statement only has " + this.parameterList.length + " parameters.");
        }
        this.lastWasNull = this.parameterList[--n] == null;
        return this.parameterList[n].value;
    }

    protected void addOutputParam(Object object) throws SQLException {
        ++this.lastOutParam;
        while (this.lastOutParam < this.parameterList.length) {
            if (this.parameterList[this.lastOutParam].isOutput) {
                this.parameterList[this.lastOutParam].value = object;
                return;
            }
            ++this.lastOutParam;
        }
        throw new SQLException("More output params than expected.");
    }

    protected void handleRetStat(PacketRetStatResult packetRetStatResult) {
    }

    protected void handleParamResult(PacketOutputParamResult packetOutputParamResult) throws SQLException {
        this.addOutputParam(packetOutputParamResult.value);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getParam(n);
        if (object == null) {
            return false;
        }
        try {
            return (Boolean)object;
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getParam(n);
        if (object == null) {
            return 0;
        }
        try {
            return ((Number)object).byteValue();
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getParam(n);
        if (object == null) {
            return null;
        }
        try {
            return (byte[])object;
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public Date getDate(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.getParam(n);
        if (object == null) {
            return 0.0;
        }
        try {
            return ((Number)object).doubleValue();
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.getParam(n);
        if (object == null) {
            return 0.0f;
        }
        try {
            return ((Number)object).floatValue();
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public int getInt(int n) throws SQLException {
        Object object = this.getParam(n);
        if (object == null) {
            return 0;
        }
        try {
            return ((Number)object).intValue();
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public long getLong(int n) throws SQLException {
        Object object = this.getParam(n);
        if (object == null) {
            return 0L;
        }
        try {
            return ((Number)object).longValue();
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public Object getObject(int n) throws SQLException {
        return this.getParam(n);
    }

    public short getShort(int n) throws SQLException {
        Object object = this.getParam(n);
        if (object == null) {
            return 0;
        }
        try {
            return ((Number)object).shortValue();
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public String getString(int n) throws SQLException {
        Object object = this.getParam(n);
        try {
            return (String)object;
        }
        catch (Exception exception) {
            throw new SQLException("Unable to convert parameter");
        }
    }

    public Time getTime(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, -1);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.setParam(n, null, n2, n3);
        this.parameterList[n - 1].isOutput = true;
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    public boolean execute() throws SQLException {
        this.closeResults(false);
        this.lastOutParam = -1;
        ParameterUtils.verifyThatParametersAreSet(this.parameterList);
        return this.internalExecuteCall(this.procedureName, this.parameterList, this.parameterList, this.getTds(false), this.warningChain);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.NotImplemented();
    }

    public Blob getBlob(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Clob getClob(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Array getArray(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.NotImplemented();
    }

    public void addBatch() throws SQLException {
        this.NotImplemented();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.NotImplemented();
    }

    public void setArray(int n, Array array) throws SQLException {
        this.NotImplemented();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.NotImplemented();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.NotImplemented();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.NotImplemented();
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.NotImplemented();
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.NotImplemented();
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.NotImplemented();
    }

    public Array getArray(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public boolean getBoolean(String string) throws SQLException {
        this.NotImplemented();
        return false;
    }

    public byte getByte(String string) throws SQLException {
        this.NotImplemented();
        return 0;
    }

    public byte[] getBytes(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Date getDate(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public double getDouble(String string) throws SQLException {
        this.NotImplemented();
        return 0.0;
    }

    public float getFloat(String string) throws SQLException {
        this.NotImplemented();
        return 0.0f;
    }

    public int getInt(String string) throws SQLException {
        this.NotImplemented();
        return 0;
    }

    public long getLong(String string) throws SQLException {
        this.NotImplemented();
        return 0L;
    }

    public Object getObject(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public short getShort(String string) throws SQLException {
        this.NotImplemented();
        return 0;
    }

    public String getString(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Time getTime(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public URL getURL(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public URL getURL(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.NotImplemented();
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.NotImplemented();
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.NotImplemented();
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.NotImplemented();
    }

    public void setByte(String string, byte by) throws SQLException {
        this.NotImplemented();
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.NotImplemented();
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.NotImplemented();
    }

    public void setDate(String string, Date date) throws SQLException {
        this.NotImplemented();
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setDouble(String string, double d) throws SQLException {
        this.NotImplemented();
    }

    public void setFloat(String string, float f) throws SQLException {
        this.NotImplemented();
    }

    public void setInt(String string, int n) throws SQLException {
        this.NotImplemented();
    }

    public void setLong(String string, long l) throws SQLException {
        this.NotImplemented();
    }

    public void setNull(String string, int n) throws SQLException {
        this.NotImplemented();
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.NotImplemented();
    }

    public void setObject(String string, Object object) throws SQLException {
        this.NotImplemented();
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.NotImplemented();
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.NotImplemented();
    }

    public void setShort(String string, short s) throws SQLException {
        this.NotImplemented();
    }

    public void setString(String string, String string2) throws SQLException {
        this.NotImplemented();
    }

    public void setTime(String string, Time time) throws SQLException {
        this.NotImplemented();
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.NotImplemented();
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.NotImplemented();
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.NotImplemented();
    }
}

