/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    protected boolean fNamespaces = true;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Augmentations[] fAugmentations = new AugmentationsImpl[4];

    public XMLAttributesImpl() {
        int i = 0;
        while (i < this.fAttributes.length) {
            this.fAttributes[i] = new Attribute();
            this.fAugmentations[i] = new AugmentationsImpl();
            ++i;
        }
    }

    public void setNamespaces(boolean namespaces) {
        this.fNamespaces = namespaces;
    }

    public int addAttribute(QName name, String type, String value) {
        int index;
        int n = index = name.uri != null && !name.uri.equals("") ? this.getIndex(name.uri, name.localpart) : this.getIndex(name.rawname);
        if (index == -1) {
            index = this.fLength;
            if (this.fLength++ == this.fAttributes.length) {
                Attribute[] attributes = new Attribute[this.fAttributes.length + 4];
                AugmentationsImpl[] augs = new AugmentationsImpl[this.fAttributes.length + 4];
                System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
                System.arraycopy(this.fAugmentations, 0, augs, 0, this.fAttributes.length);
                int i = this.fAttributes.length;
                while (i < attributes.length) {
                    attributes[i] = new Attribute();
                    augs[i] = new AugmentationsImpl();
                    ++i;
                }
                this.fAttributes = attributes;
                this.fAugmentations = augs;
            }
        }
        this.fAugmentations[index].clear();
        Attribute attribute = this.fAttributes[index];
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.nonNormalizedValue = value;
        attribute.specified = false;
        return index;
    }

    public void removeAllAttributes() {
        this.fLength = 0;
    }

    public void removeAttributeAt(int attrIndex) {
        if (attrIndex < this.fLength - 1) {
            Attribute removedAttr = this.fAttributes[attrIndex];
            Augmentations removedAug = this.fAugmentations[attrIndex];
            System.arraycopy(this.fAttributes, attrIndex + 1, this.fAttributes, attrIndex, this.fLength - attrIndex - 1);
            System.arraycopy(this.fAugmentations, attrIndex + 1, this.fAugmentations, attrIndex, this.fLength - attrIndex - 1);
            this.fAttributes[this.fLength - 1] = removedAttr;
            this.fAugmentations[this.fLength - 1] = removedAug;
        }
        --this.fLength;
    }

    public void setName(int attrIndex, QName attrName) {
        this.fAttributes[attrIndex].name.setValues(attrName);
    }

    public void getName(int attrIndex, QName attrName) {
        attrName.setValues(this.fAttributes[attrIndex].name);
    }

    public void setType(int attrIndex, String attrType) {
        this.fAttributes[attrIndex].type = attrType;
    }

    public void setValue(int attrIndex, String attrValue) {
        Attribute attribute = this.fAttributes[attrIndex];
        attribute.value = attrValue;
        attribute.nonNormalizedValue = attrValue;
    }

    public void setNonNormalizedValue(int attrIndex, String attrValue) {
        if (attrValue == null) {
            attrValue = this.fAttributes[attrIndex].value;
        }
        this.fAttributes[attrIndex].nonNormalizedValue = attrValue;
    }

    public String getNonNormalizedValue(int attrIndex) {
        String value = this.fAttributes[attrIndex].nonNormalizedValue;
        return value;
    }

    public void setSpecified(int attrIndex, boolean specified) {
        this.fAttributes[attrIndex].specified = specified;
    }

    public boolean isSpecified(int attrIndex) {
        return this.fAttributes[attrIndex].specified;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getType(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        String type = this.fAttributes[index].type;
        if (type.indexOf(40) == 0 && type.lastIndexOf(41) == type.length() - 1) {
            return "NMTOKEN";
        }
        return type;
    }

    public String getType(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.fAttributes[index].type : null;
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fAttributes[index].value;
    }

    public String getValue(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.fAttributes[index].value : null;
    }

    public String getName(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fAttributes[index].name.rawname;
    }

    public int getIndex(String qName) {
        int i = 0;
        while (i < this.fLength) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.rawname != null && attribute.name.rawname.equals(qName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(String uri, String localPart) {
        int i = 0;
        while (i < this.fLength) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.localpart != null && attribute.name.localpart.equals(localPart) && (uri == attribute.name.uri || uri != null && attribute.name.uri != null && attribute.name.uri.equals(uri))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getLocalName(int index) {
        if (!this.fNamespaces) {
            return "";
        }
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fAttributes[index].name.localpart;
    }

    public String getQName(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        String rawname = this.fAttributes[index].name.rawname;
        return rawname != null ? rawname : "";
    }

    public String getType(String uri, String localName) {
        if (!this.fNamespaces) {
            return null;
        }
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getType(index) : null;
    }

    public String getPrefix(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        String prefix = this.fAttributes[index].name.prefix;
        return prefix != null ? prefix : "";
    }

    public String getURI(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        String uri = this.fAttributes[index].name.uri;
        return uri;
    }

    public String getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getValue(index) : null;
    }

    public Augmentations getAugmentations(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.fAugmentations[index] : null;
    }

    public Augmentations getAugmentations(String qName) {
        int index = this.getIndex(qName);
        return index != -1 ? this.fAugmentations[index] : null;
    }

    public Augmentations getAugmentations(int attributeIndex) {
        if (attributeIndex < 0 || attributeIndex >= this.fLength) {
            return null;
        }
        return this.fAugmentations[attributeIndex];
    }

    public void setURI(int attrIndex, String uri) {
        this.fAttributes[attrIndex].name.uri = uri;
    }

    public void setSchemaId(int attrIndex, boolean schemaId) {
        this.fAttributes[attrIndex].schemaId = schemaId;
    }

    public boolean getSchemaId(int index) {
        if (index < 0 || index >= this.fLength) {
            return false;
        }
        return this.fAttributes[index].schemaId;
    }

    public boolean getSchemaId(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.fAttributes[index].schemaId : false;
    }

    public boolean getSchemaId(String uri, String localName) {
        if (!this.fNamespaces) {
            return false;
        }
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.fAttributes[index].schemaId : false;
    }

    static class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;
        public boolean schemaId;

        Attribute() {
        }
    }
}

