/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.SymbolHash;

public class XSConstraints {
    static final int OCCURRENCE_UNKNOWN = -2;
    static final XSSimpleType STRING_TYPE = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("string");

    public static boolean checkTypeDerivationOk(XSTypeDecl derived, XSTypeDecl base, short block) {
        if (derived == SchemaGrammar.fAnyType) {
            return derived == base;
        }
        if (derived == SchemaGrammar.fAnySimpleType) {
            return base == SchemaGrammar.fAnyType || base == SchemaGrammar.fAnySimpleType;
        }
        if (derived.getTypeCategory() == 14) {
            if (base.getTypeCategory() == 13) {
                if (base == SchemaGrammar.fAnyType) {
                    base = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((XSSimpleType)derived, (XSSimpleType)base, block);
        }
        return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)derived, base, block);
    }

    public static boolean checkSimpleDerivationOk(XSSimpleType derived, XSTypeDecl base, short block) {
        if (derived == SchemaGrammar.fAnySimpleType) {
            return base == SchemaGrammar.fAnyType || base == SchemaGrammar.fAnySimpleType;
        }
        if (base.getTypeCategory() == 13) {
            if (base == SchemaGrammar.fAnyType) {
                base = SchemaGrammar.fAnySimpleType;
            } else {
                return false;
            }
        }
        return XSConstraints.checkSimpleDerivation(derived, (XSSimpleType)base, block);
    }

    public static boolean checkComplexDerivationOk(XSComplexTypeDecl derived, XSTypeDecl base, short block) {
        if (derived == SchemaGrammar.fAnyType) {
            return derived == base;
        }
        return XSConstraints.checkComplexDerivation(derived, base, block);
    }

    private static boolean checkSimpleDerivation(XSSimpleType derived, XSSimpleType base, short block) {
        if (derived == base) {
            return true;
        }
        if ((block & 2) != 0 || (derived.getBaseType().getFinal() & 2) != 0) {
            return false;
        }
        XSSimpleType directBase = (XSSimpleType)derived.getBaseType();
        if (directBase == base) {
            return true;
        }
        if (directBase != SchemaGrammar.fAnySimpleType && XSConstraints.checkSimpleDerivation(directBase, base, block)) {
            return true;
        }
        if ((derived.getVariety() == 2 || derived.getVariety() == 3) && base == SchemaGrammar.fAnySimpleType) {
            return true;
        }
        if (base.getVariety() == 3) {
            XSObjectList subUnionMemberDV = base.getMemberTypes();
            int subUnionSize = subUnionMemberDV.getLength();
            int i = 0;
            while (i < subUnionSize) {
                base = (XSSimpleType)subUnionMemberDV.getItem(i);
                if (XSConstraints.checkSimpleDerivation(derived, base, block)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean checkComplexDerivation(XSComplexTypeDecl derived, XSTypeDecl base, short block) {
        if (derived == base) {
            return true;
        }
        if ((derived.fDerivedBy & block) != 0) {
            return false;
        }
        XSTypeDecl directBase = derived.fBaseType;
        if (directBase == base) {
            return true;
        }
        if (directBase == SchemaGrammar.fAnyType || directBase == SchemaGrammar.fAnySimpleType) {
            return false;
        }
        if (directBase.getTypeCategory() == 13) {
            return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)directBase, base, block);
        }
        if (directBase.getTypeCategory() == 14) {
            if (base.getTypeCategory() == 13) {
                if (base == SchemaGrammar.fAnyType) {
                    base = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((XSSimpleType)directBase, (XSSimpleType)base, block);
        }
        return false;
    }

    public static Object ElementDefaultValidImmediate(XSTypeDecl type, Object value, ValidationContext context, ValidatedInfo vinfo) {
        XSSimpleType dv = null;
        if (type.getTypeCategory() == 14) {
            dv = (XSSimpleType)type;
        } else {
            XSComplexTypeDecl ctype = (XSComplexTypeDecl)type;
            if (ctype.fContentType == 1) {
                dv = ctype.fXSSimpleType;
            } else if (ctype.fContentType == 3) {
                if (!((XSParticleDecl)ctype.getParticle()).emptiable()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        Object actualValue = null;
        if (dv == null) {
            dv = STRING_TYPE;
        }
        try {
            if (value instanceof String) {
                actualValue = dv.validate((String)value, context, vinfo);
            } else {
                ValidatedInfo info = (ValidatedInfo)value;
                dv.validate(context, info);
                actualValue = info.actualValue;
            }
        }
        catch (InvalidDatatypeValueException ide) {
            return null;
        }
        return actualValue;
    }

    static void reportSchemaError(XMLErrorReporter errorReporter, SimpleLocator loc, String key, Object[] args) {
        if (loc != null) {
            errorReporter.reportError(loc, "http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
        } else {
            errorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
        }
    }

    public static void fullSchemaChecking(XSGrammarBucket grammarBucket, SubstitutionGroupHandler SGHandler, CMBuilder cmBuilder, XMLErrorReporter errorReporter) {
        SchemaGrammar[] grammars = grammarBucket.getGrammars();
        int i = grammars.length - 1;
        while (i >= 0) {
            SGHandler.addSubstitutionGroup(grammars[i].getSubstitutionGroups());
            --i;
        }
        XSParticleDecl fakeDerived = new XSParticleDecl();
        XSParticleDecl fakeBase = new XSParticleDecl();
        fakeDerived.fType = (short)3;
        fakeBase.fType = (short)3;
        int g = grammars.length - 1;
        while (g >= 0) {
            XSGroupDecl[] redefinedGroups = grammars[g].getRedefinedGroupDecls();
            SimpleLocator[] rgLocators = grammars[g].getRGLocators();
            int i2 = 0;
            while (i2 < redefinedGroups.length) {
                XSGroupDecl derivedGrp = redefinedGroups[i2++];
                XSModelGroupImpl derivedMG = derivedGrp.fModelGroup;
                XSGroupDecl baseGrp = redefinedGroups[i2++];
                XSModelGroupImpl baseMG = baseGrp.fModelGroup;
                if (baseMG == null) {
                    if (derivedMG == null) continue;
                    XSConstraints.reportSchemaError(errorReporter, rgLocators[i2 / 2 - 1], "src-redefine.6.2.2", new Object[]{derivedGrp.fName, "rcase-Recurse.2"});
                    continue;
                }
                fakeDerived.fValue = derivedMG;
                fakeBase.fValue = baseMG;
                try {
                    XSConstraints.particleValidRestriction(fakeDerived, SGHandler, fakeBase, SGHandler);
                }
                catch (XMLSchemaException e) {
                    String key = e.getKey();
                    XSConstraints.reportSchemaError(errorReporter, rgLocators[i2 / 2 - 1], key, e.getArgs());
                    XSConstraints.reportSchemaError(errorReporter, rgLocators[i2 / 2 - 1], "src-redefine.6.2.2", new Object[]{derivedGrp.fName, key});
                }
            }
            --g;
        }
        SymbolHash elemTable = new SymbolHash();
        int i3 = grammars.length - 1;
        while (i3 >= 0) {
            int keepType = 0;
            boolean fullChecked = grammars[i3].fFullChecked;
            XSComplexTypeDecl[] types = grammars[i3].getUncheckedComplexTypeDecls();
            SimpleLocator[] ctLocators = grammars[i3].getUncheckedCTLocators();
            int j = types.length - 1;
            while (j >= 0) {
                if (!fullChecked && types[j].fParticle != null) {
                    elemTable.clear();
                    try {
                        XSConstraints.checkElementDeclsConsistent(types[j], types[j].fParticle, elemTable, SGHandler);
                    }
                    catch (XMLSchemaException e) {
                        XSConstraints.reportSchemaError(errorReporter, ctLocators[j], e.getKey(), e.getArgs());
                    }
                }
                if (types[j].fBaseType != null && types[j].fBaseType != SchemaGrammar.fAnyType && types[j].fDerivedBy == 2 && types[j].fBaseType instanceof XSComplexTypeDecl) {
                    XSParticleDecl derivedParticle = types[j].fParticle;
                    XSParticleDecl baseParticle = ((XSComplexTypeDecl)types[j].fBaseType).fParticle;
                    if (derivedParticle == null && baseParticle != null && !baseParticle.emptiable()) {
                        XSConstraints.reportSchemaError(errorReporter, ctLocators[j], "derivation-ok-restriction.5.2", new Object[]{types[j].fName});
                    } else if (derivedParticle != null && baseParticle != null) {
                        try {
                            XSConstraints.particleValidRestriction(types[j].fParticle, SGHandler, ((XSComplexTypeDecl)types[j].fBaseType).fParticle, SGHandler);
                        }
                        catch (XMLSchemaException e) {
                            XSConstraints.reportSchemaError(errorReporter, ctLocators[j], e.getKey(), e.getArgs());
                            XSConstraints.reportSchemaError(errorReporter, ctLocators[j], "derivation-ok-restriction.5.3", new Object[]{types[j].fName});
                        }
                    }
                }
                XSCMValidator cm = types[j].getContentModel(cmBuilder);
                boolean further = false;
                if (cm != null) {
                    try {
                        further = cm.checkUniqueParticleAttribution(SGHandler);
                    }
                    catch (XMLSchemaException e) {
                        XSConstraints.reportSchemaError(errorReporter, ctLocators[j], e.getKey(), e.getArgs());
                    }
                }
                if (!fullChecked && further) {
                    types[keepType++] = types[j];
                }
                --j;
            }
            if (!fullChecked) {
                grammars[i3].setUncheckedTypeNum(keepType);
                grammars[i3].fFullChecked = true;
            }
            --i3;
        }
    }

    public static void checkElementDeclsConsistent(XSComplexTypeDecl type, XSParticleDecl particle, SymbolHash elemDeclHash, SubstitutionGroupHandler sgHandler) throws XMLSchemaException {
        short pType = particle.fType;
        if (pType == 0 || pType == 2) {
            return;
        }
        if (pType == 1) {
            XSElementDecl elem = (XSElementDecl)particle.fValue;
            XSConstraints.findElemInTable(type, elem, elemDeclHash);
            if (elem.fScope == 1) {
                XSElementDecl[] subGroup = sgHandler.getSubstitutionGroup(elem);
                int i = 0;
                while (i < subGroup.length) {
                    XSConstraints.findElemInTable(type, subGroup[i], elemDeclHash);
                    ++i;
                }
            }
            return;
        }
        XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
        int i = 0;
        while (i < group.fParticleCount) {
            XSConstraints.checkElementDeclsConsistent(type, group.fParticles[i], elemDeclHash, sgHandler);
            ++i;
        }
    }

    public static void findElemInTable(XSComplexTypeDecl type, XSElementDecl elem, SymbolHash elemDeclHash) throws XMLSchemaException {
        String name = elem.fName + "," + elem.fTargetNamespace;
        XSElementDecl existingElem = null;
        existingElem = (XSElementDecl)elemDeclHash.get(name);
        if (existingElem == null) {
            elemDeclHash.put(name, elem);
        } else {
            if (elem == existingElem) {
                return;
            }
            if (elem.fType != existingElem.fType) {
                throw new XMLSchemaException("cos-element-consistent", new Object[]{type.fName, name});
            }
        }
    }

    private static void particleValidRestriction(XSParticleDecl dParticle, SubstitutionGroupHandler dSGHandler, XSParticleDecl bParticle, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        XSConstraints.particleValidRestriction(dParticle, dSGHandler, bParticle, bSGHandler, true);
    }

    private static void particleValidRestriction(XSParticleDecl dParticle, SubstitutionGroupHandler dSGHandler, XSParticleDecl bParticle, SubstitutionGroupHandler bSGHandler, boolean checkWCOccurrence) throws XMLSchemaException {
        int bType;
        Vector<XSParticleDecl> dChildren = null;
        Vector bChildren = null;
        int dMinEffectiveTotalRange = -2;
        int dMaxEffectiveTotalRange = -2;
        if (dParticle.isEmpty() != bParticle.isEmpty()) {
            throw new XMLSchemaException("cos-particle-restrict", null);
        }
        int dType = dParticle.fType;
        if (dType == 3) {
            dType = ((XSModelGroupImpl)dParticle.fValue).fCompositor;
            XSParticleDecl dtmp = XSConstraints.getNonUnaryGroup(dParticle);
            if (dtmp != dParticle) {
                dParticle = dtmp;
                dType = dParticle.fType;
                if (dType == 3) {
                    dType = ((XSModelGroupImpl)dParticle.fValue).fCompositor;
                }
            }
            dChildren = XSConstraints.removePointlessChildren(dParticle);
        }
        int dMinOccurs = dParticle.fMinOccurs;
        int dMaxOccurs = dParticle.fMaxOccurs;
        if (dSGHandler != null && dType == 1) {
            XSElementDecl[] subGroup;
            XSElementDecl dElement = (XSElementDecl)dParticle.fValue;
            if (dElement.fScope == 1 && (subGroup = dSGHandler.getSubstitutionGroup(dElement)).length > 0) {
                dType = 101;
                dMinEffectiveTotalRange = dMinOccurs;
                dMaxEffectiveTotalRange = dMaxOccurs;
                dChildren = new Vector(subGroup.length + 1);
                int i = 0;
                while (i < subGroup.length) {
                    XSConstraints.addElementToParticleVector(dChildren, subGroup[i]);
                    ++i;
                }
                XSConstraints.addElementToParticleVector(dChildren, dElement);
                dSGHandler = null;
            }
        }
        if ((bType = bParticle.fType) == 3) {
            bType = ((XSModelGroupImpl)bParticle.fValue).fCompositor;
            XSParticleDecl btmp = XSConstraints.getNonUnaryGroup(bParticle);
            if (btmp != bParticle) {
                bParticle = btmp;
                bType = bParticle.fType;
                if (bType == 3) {
                    bType = ((XSModelGroupImpl)bParticle.fValue).fCompositor;
                }
            }
            bChildren = XSConstraints.removePointlessChildren(bParticle);
        }
        int bMinOccurs = bParticle.fMinOccurs;
        int bMaxOccurs = bParticle.fMaxOccurs;
        if (bSGHandler != null && bType == 1) {
            XSElementDecl[] bsubGroup;
            XSElementDecl bElement = (XSElementDecl)bParticle.fValue;
            if (bElement.fScope == 1 && (bsubGroup = bSGHandler.getSubstitutionGroup(bElement)).length > 0) {
                bType = 101;
                bChildren = new Vector(bsubGroup.length + 1);
                int i = 0;
                while (i < bsubGroup.length) {
                    XSConstraints.addElementToParticleVector(bChildren, bsubGroup[i]);
                    ++i;
                }
                XSConstraints.addElementToParticleVector(bChildren, bElement);
                bSGHandler = null;
            }
        }
        switch (dType) {
            case 1: {
                switch (bType) {
                    case 1: {
                        XSConstraints.checkNameAndTypeOK((XSElementDecl)dParticle.fValue, dMinOccurs, dMaxOccurs, (XSElementDecl)bParticle.fValue, bMinOccurs, bMaxOccurs);
                        return;
                    }
                    case 2: {
                        XSConstraints.checkNSCompat((XSElementDecl)dParticle.fValue, dMinOccurs, dMaxOccurs, (XSWildcardDecl)bParticle.fValue, bMinOccurs, bMaxOccurs, checkWCOccurrence);
                        return;
                    }
                    case 101: {
                        dChildren = new Vector<XSParticleDecl>();
                        dChildren.addElement(dParticle);
                        XSConstraints.checkRecurseLax(dChildren, 1, 1, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return;
                    }
                    case 102: 
                    case 103: {
                        dChildren = new Vector();
                        dChildren.addElement(dParticle);
                        XSConstraints.checkRecurse(dChildren, 1, 1, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return;
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 2: {
                switch (bType) {
                    case 2: {
                        XSConstraints.checkNSSubset((XSWildcardDecl)dParticle.fValue, dMinOccurs, dMaxOccurs, (XSWildcardDecl)bParticle.fValue, bMinOccurs, bMaxOccurs);
                        return;
                    }
                    case 1: 
                    case 101: 
                    case 102: 
                    case 103: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"any:choice,sequence,all,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 103: {
                switch (bType) {
                    case 2: {
                        if (dMinEffectiveTotalRange == -2) {
                            dMinEffectiveTotalRange = dParticle.minEffectiveTotalRange();
                        }
                        if (dMaxEffectiveTotalRange == -2) {
                            dMaxEffectiveTotalRange = dParticle.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(dChildren, dMinEffectiveTotalRange, dMaxEffectiveTotalRange, dSGHandler, bParticle, bMinOccurs, bMaxOccurs, checkWCOccurrence);
                        return;
                    }
                    case 103: {
                        XSConstraints.checkRecurse(dChildren, dMinOccurs, dMaxOccurs, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return;
                    }
                    case 1: 
                    case 101: 
                    case 102: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"all:choice,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 101: {
                switch (bType) {
                    case 2: {
                        if (dMinEffectiveTotalRange == -2) {
                            dMinEffectiveTotalRange = dParticle.minEffectiveTotalRange();
                        }
                        if (dMaxEffectiveTotalRange == -2) {
                            dMaxEffectiveTotalRange = dParticle.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(dChildren, dMinEffectiveTotalRange, dMaxEffectiveTotalRange, dSGHandler, bParticle, bMinOccurs, bMaxOccurs, checkWCOccurrence);
                        return;
                    }
                    case 101: {
                        XSConstraints.checkRecurseLax(dChildren, dMinOccurs, dMaxOccurs, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return;
                    }
                    case 1: 
                    case 102: 
                    case 103: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"choice:all,sequence,elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
            case 102: {
                switch (bType) {
                    case 2: {
                        if (dMinEffectiveTotalRange == -2) {
                            dMinEffectiveTotalRange = dParticle.minEffectiveTotalRange();
                        }
                        if (dMaxEffectiveTotalRange == -2) {
                            dMaxEffectiveTotalRange = dParticle.maxEffectiveTotalRange();
                        }
                        XSConstraints.checkNSRecurseCheckCardinality(dChildren, dMinEffectiveTotalRange, dMaxEffectiveTotalRange, dSGHandler, bParticle, bMinOccurs, bMaxOccurs, checkWCOccurrence);
                        return;
                    }
                    case 103: {
                        XSConstraints.checkRecurseUnordered(dChildren, dMinOccurs, dMaxOccurs, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return;
                    }
                    case 102: {
                        XSConstraints.checkRecurse(dChildren, dMinOccurs, dMaxOccurs, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return;
                    }
                    case 101: {
                        int min1 = dMinOccurs * dChildren.size();
                        int max1 = dMaxOccurs == -1 ? dMaxOccurs : dMaxOccurs * dChildren.size();
                        XSConstraints.checkMapAndSum(dChildren, min1, max1, dSGHandler, bChildren, bMinOccurs, bMaxOccurs, bSGHandler);
                        return;
                    }
                    case 1: {
                        throw new XMLSchemaException("cos-particle-restrict.2", new Object[]{"seq:elt"});
                    }
                }
                throw new XMLSchemaException("Internal-Error", new Object[]{"in particleValidRestriction"});
            }
        }
    }

    private static void addElementToParticleVector(Vector v, XSElementDecl d) {
        XSParticleDecl p = new XSParticleDecl();
        p.fValue = d;
        p.fType = 1;
        v.addElement(p);
    }

    private static XSParticleDecl getNonUnaryGroup(XSParticleDecl p) {
        if (p.fType == 1 || p.fType == 2) {
            return p;
        }
        if (p.fMinOccurs == 1 && p.fMaxOccurs == 1 && p.fValue != null && ((XSModelGroupImpl)p.fValue).fParticleCount == 1) {
            return XSConstraints.getNonUnaryGroup(((XSModelGroupImpl)p.fValue).fParticles[0]);
        }
        return p;
    }

    private static Vector removePointlessChildren(XSParticleDecl p) {
        if (p.fType == 1 || p.fType == 2 || p.fType == 0) {
            return null;
        }
        Vector children = new Vector();
        XSModelGroupImpl group = (XSModelGroupImpl)p.fValue;
        int i = 0;
        while (i < group.fParticleCount) {
            XSConstraints.gatherChildren(group.fCompositor, group.fParticles[i], children);
            ++i;
        }
        return children;
    }

    private static void gatherChildren(int parentType, XSParticleDecl p, Vector children) {
        int min = p.fMinOccurs;
        int max = p.fMaxOccurs;
        short type = p.fType;
        if (type == 3) {
            type = ((XSModelGroupImpl)p.fValue).fCompositor;
        }
        if (type == 0) {
            return;
        }
        if (type == 1 || type == 2) {
            children.addElement(p);
            return;
        }
        if (min != 1 || max != 1) {
            children.addElement(p);
        } else if (parentType == type) {
            XSModelGroupImpl group = (XSModelGroupImpl)p.fValue;
            int i = 0;
            while (i < group.fParticleCount) {
                XSConstraints.gatherChildren(type, group.fParticles[i], children);
                ++i;
            }
        } else if (!p.isEmpty()) {
            children.addElement(p);
        }
    }

    private static void checkNameAndTypeOK(XSElementDecl dElement, int dMin, int dMax, XSElementDecl bElement, int bMin, int bMax) throws XMLSchemaException {
        if (dElement.fName != bElement.fName || dElement.fTargetNamespace != bElement.fTargetNamespace) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.1", new Object[]{dElement.fName, dElement.fTargetNamespace, bElement.fName, bElement.fTargetNamespace});
        }
        if (!bElement.getIsNillable() && dElement.getIsNillable()) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.2", new Object[]{dElement.fName});
        }
        if (!XSConstraints.checkOccurrenceRange(dMin, dMax, bMin, bMax)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.3", new Object[]{dElement.fName});
        }
        if (bElement.getConstraintType() == 2) {
            if (dElement.getConstraintType() != 2) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4", new Object[]{dElement.fName});
            }
            boolean isSimple = false;
            if (dElement.fType.getTypeCategory() == 14 || ((XSComplexTypeDecl)dElement.fType).fContentType == 1) {
                isSimple = true;
            }
            if (!isSimple && !bElement.fDefault.normalizedValue.equals(dElement.fDefault.normalizedValue) || isSimple && !bElement.fDefault.actualValue.equals(dElement.fDefault.actualValue)) {
                throw new XMLSchemaException("rcase-NameAndTypeOK.4", new Object[]{dElement.fName});
            }
        }
        XSConstraints.checkIDConstraintRestriction(dElement, bElement);
        short blockSet1 = dElement.fBlock;
        short blockSet2 = bElement.fBlock;
        if ((blockSet1 & blockSet2) != blockSet2 || blockSet1 == 0 && blockSet2 != 0) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.6", new Object[]{dElement.fName});
        }
        if (!XSConstraints.checkTypeDerivationOk(dElement.fType, bElement.fType, (short)25)) {
            throw new XMLSchemaException("rcase-NameAndTypeOK.7", new Object[]{dElement.fName});
        }
    }

    private static void checkIDConstraintRestriction(XSElementDecl derivedElemDecl, XSElementDecl baseElemDecl) throws XMLSchemaException {
    }

    private static boolean checkOccurrenceRange(int min1, int max1, int min2, int max2) {
        return min1 >= min2 && (max2 == -1 || max1 != -1 && max1 <= max2);
    }

    private static void checkNSCompat(XSElementDecl elem, int min1, int max1, XSWildcardDecl wildcard, int min2, int max2, boolean checkWCOccurrence) throws XMLSchemaException {
        if (checkWCOccurrence && !XSConstraints.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-NSCompat.2", new Object[]{elem.fName});
        }
        if (!wildcard.allowNamespace(elem.fTargetNamespace)) {
            throw new XMLSchemaException("rcase-NSCompat.1", new Object[]{elem.fName, elem.fTargetNamespace});
        }
    }

    private static void checkNSSubset(XSWildcardDecl dWildcard, int min1, int max1, XSWildcardDecl bWildcard, int min2, int max2) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-NSSubset.2", null);
        }
        if (!dWildcard.isSubsetOf(bWildcard)) {
            throw new XMLSchemaException("rcase-NSSubset.1", null);
        }
    }

    private static void checkNSRecurseCheckCardinality(Vector children, int min1, int max1, SubstitutionGroupHandler dSGHandler, XSParticleDecl wildcard, int min2, int max2, boolean checkWCOccurrence) throws XMLSchemaException {
        if (checkWCOccurrence && !XSConstraints.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.2", null);
        }
        int count = children.size();
        try {
            int i = 0;
            while (i < count) {
                XSParticleDecl particle1 = (XSParticleDecl)children.elementAt(i);
                XSConstraints.particleValidRestriction(particle1, dSGHandler, wildcard, null, false);
                ++i;
            }
        }
        catch (XMLSchemaException e) {
            throw new XMLSchemaException("rcase-NSRecurseCheckCardinality.1", null);
        }
    }

    private static void checkRecurse(Vector dChildren, int min1, int max1, SubstitutionGroupHandler dSGHandler, Vector bChildren, int min2, int max2, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-Recurse.1", null);
        }
        int count1 = dChildren.size();
        int count2 = bChildren.size();
        int current = 0;
        int i = 0;
        while (i < count1) {
            block8: {
                XSParticleDecl particle1 = (XSParticleDecl)dChildren.elementAt(i);
                int j = current;
                while (j < count2) {
                    XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
                    ++current;
                    try {
                        XSConstraints.particleValidRestriction(particle1, dSGHandler, particle2, bSGHandler);
                        break block8;
                    }
                    catch (XMLSchemaException e) {
                        if (!particle2.emptiable()) {
                            throw new XMLSchemaException("rcase-Recurse.2", null);
                        }
                        ++j;
                    }
                }
                throw new XMLSchemaException("rcase-Recurse.2", null);
            }
            ++i;
        }
        int j = current;
        while (j < count2) {
            XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
            if (!particle2.emptiable()) {
                throw new XMLSchemaException("rcase-Recurse.2", null);
            }
            ++j;
        }
    }

    private static void checkRecurseUnordered(Vector dChildren, int min1, int max1, SubstitutionGroupHandler dSGHandler, Vector bChildren, int min2, int max2, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-RecurseUnordered.1", null);
        }
        int count1 = dChildren.size();
        int count2 = bChildren.size();
        boolean[] foundIt = new boolean[count2];
        int i = 0;
        while (i < count1) {
            block8: {
                XSParticleDecl particle1 = (XSParticleDecl)dChildren.elementAt(i);
                int j = 0;
                while (j < count2) {
                    XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
                    try {
                        XSConstraints.particleValidRestriction(particle1, dSGHandler, particle2, bSGHandler);
                        if (foundIt[j]) {
                            throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
                        }
                        foundIt[j] = true;
                        break block8;
                    }
                    catch (XMLSchemaException e) {
                        ++j;
                    }
                }
                throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
            }
            ++i;
        }
        int j = 0;
        while (j < count2) {
            XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
            if (!foundIt[j] && !particle2.emptiable()) {
                throw new XMLSchemaException("rcase-RecurseUnordered.2", null);
            }
            ++j;
        }
    }

    private static void checkRecurseLax(Vector dChildren, int min1, int max1, SubstitutionGroupHandler dSGHandler, Vector bChildren, int min2, int max2, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-RecurseLax.1", null);
        }
        int count1 = dChildren.size();
        int count2 = bChildren.size();
        int current = 0;
        int i = 0;
        while (i < count1) {
            block5: {
                XSParticleDecl particle1 = (XSParticleDecl)dChildren.elementAt(i);
                int j = current;
                while (j < count2) {
                    XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
                    ++current;
                    try {
                        XSConstraints.particleValidRestriction(particle1, dSGHandler, particle2, bSGHandler);
                        break block5;
                    }
                    catch (XMLSchemaException e) {
                        ++j;
                    }
                }
                throw new XMLSchemaException("rcase-RecurseLax.2", null);
            }
            ++i;
        }
    }

    private static void checkMapAndSum(Vector dChildren, int min1, int max1, SubstitutionGroupHandler dSGHandler, Vector bChildren, int min2, int max2, SubstitutionGroupHandler bSGHandler) throws XMLSchemaException {
        if (!XSConstraints.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new XMLSchemaException("rcase-MapAndSum.2", null);
        }
        int count1 = dChildren.size();
        int count2 = bChildren.size();
        int i = 0;
        while (i < count1) {
            block5: {
                XSParticleDecl particle1 = (XSParticleDecl)dChildren.elementAt(i);
                int j = 0;
                while (j < count2) {
                    XSParticleDecl particle2 = (XSParticleDecl)bChildren.elementAt(j);
                    try {
                        XSConstraints.particleValidRestriction(particle1, dSGHandler, particle2, bSGHandler);
                        break block5;
                    }
                    catch (XMLSchemaException e) {
                        ++j;
                    }
                }
                throw new XMLSchemaException("rcase-MapAndSum.1", null);
            }
            ++i;
        }
    }

    public static boolean overlapUPA(XSElementDecl element1, XSElementDecl element2, SubstitutionGroupHandler sgHandler) {
        if (element1.fName == element2.fName && element1.fTargetNamespace == element2.fTargetNamespace) {
            return true;
        }
        XSElementDecl[] subGroup = sgHandler.getSubstitutionGroup(element1);
        int i = subGroup.length - 1;
        while (i >= 0) {
            if (subGroup[i].fName == element2.fName && subGroup[i].fTargetNamespace == element2.fTargetNamespace) {
                return true;
            }
            --i;
        }
        subGroup = sgHandler.getSubstitutionGroup(element2);
        int i2 = subGroup.length - 1;
        while (i2 >= 0) {
            if (subGroup[i2].fName == element1.fName && subGroup[i2].fTargetNamespace == element1.fTargetNamespace) {
                return true;
            }
            --i2;
        }
        return false;
    }

    public static boolean overlapUPA(XSElementDecl element, XSWildcardDecl wildcard, SubstitutionGroupHandler sgHandler) {
        if (wildcard.allowNamespace(element.fTargetNamespace)) {
            return true;
        }
        XSElementDecl[] subGroup = sgHandler.getSubstitutionGroup(element);
        int i = subGroup.length - 1;
        while (i >= 0) {
            if (wildcard.allowNamespace(subGroup[i].fTargetNamespace)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean overlapUPA(XSWildcardDecl wildcard1, XSWildcardDecl wildcard2) {
        XSWildcardDecl intersect = wildcard1.performIntersectionWith(wildcard2, wildcard1.fProcessContents);
        return intersect == null || intersect.fType != 3 || intersect.fNamespaceList.length != 0;
    }

    public static boolean overlapUPA(Object decl1, Object decl2, SubstitutionGroupHandler sgHandler) {
        if (decl1 instanceof XSElementDecl) {
            if (decl2 instanceof XSElementDecl) {
                return XSConstraints.overlapUPA((XSElementDecl)decl1, (XSElementDecl)decl2, sgHandler);
            }
            return XSConstraints.overlapUPA((XSElementDecl)decl1, (XSWildcardDecl)decl2, sgHandler);
        }
        if (decl2 instanceof XSElementDecl) {
            return XSConstraints.overlapUPA((XSElementDecl)decl2, (XSWildcardDecl)decl1, sgHandler);
        }
        return XSConstraints.overlapUPA((XSWildcardDecl)decl1, (XSWildcardDecl)decl2);
    }
}

