/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.lib;

import com.securitycentric.metacoretex.Init;
import com.securitycentric.metacoretex.interfaces.Probe;
import com.securitycentric.metacoretex.lib.ProbeToolz;
import com.securitycentric.metacoretex.lib.UpdateException;
import com.securitycentric.metacoretex.lib.Version;
import com.securitycentric.metacoretex.lib.VersionException;
import com.securitycentric.metacoretex.xml.update.MCTXConfFile;
import com.securitycentric.metacoretex.xml.update.MCTXJar;
import com.securitycentric.metacoretex.xml.update.MCTXProbe;
import com.securitycentric.metacoretex.xml.update.MCTXUpdate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class UpdateToolz {
    public static Vector newFiles = new Vector();
    public static Vector upFiles = new Vector();

    public static void onlyProbes(MCTXUpdate upDate) {
        upDate.getConfFile().clear();
        upDate.getJar().clear();
    }

    public static void onlyConfigFiles(MCTXUpdate upDate) {
        upDate.getProbe().clear();
        upDate.getJar().clear();
    }

    public static void onlyJars(MCTXUpdate upDate) {
        upDate.getProbe().clear();
        upDate.getConfFile().clear();
    }

    public static MCTXUpdate getUpdate() throws UpdateException {
        try {
            String updateUrlStr = (String)Init.config.get("update.url");
            JAXBContext jc = JAXBContext.newInstance((String)"com.securitycentric.metacoretex.xml.update");
            Unmarshaller um = jc.createUnmarshaller();
            URL updateUrl = new URL(updateUrlStr);
            MCTXUpdate upDate = (MCTXUpdate)um.unmarshal(updateUrl);
            return upDate;
        }
        catch (JAXBException e) {
            throw new UpdateException("JAXB Exception in getUpdate(): \n" + e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new UpdateException("Malforemed URL in getUpdate(): \n" + e.getMessage());
        }
    }

    public static void removeDuplicates(MCTXUpdate upDate) {
        try {
            String availVerStr;
            String confDir = (String)Init.config.get("conf.dir");
            String jarDir = (String)Init.config.get("jar.dir");
            Iterator prIter = upDate.getProbe().iterator();
            while (prIter.hasNext()) {
                Version ourVer;
                Version availVer;
                MCTXProbe prb = (MCTXProbe)prIter.next();
                int id = prb.getId();
                String jName = prb.getJavaName();
                Probe ourPrb = ProbeToolz.getProbeById(id);
                if (ourPrb == null || (availVer = new Version(availVerStr = prb.getVersion())).isNewerThan(ourVer = new Version(ourPrb.getVersion()))) continue;
                prIter.remove();
            }
            Iterator cnfIter = upDate.getConfFile().iterator();
            while (cnfIter.hasNext()) {
                Version availVer;
                MCTXConfFile cnfFile = (MCTXConfFile)cnfIter.next();
                String fName = cnfFile.getName();
                File ourCnf = new File(confDir + fName);
                if (!ourCnf.exists()) continue;
                availVerStr = cnfFile.getVersion();
                Version ourVer = UpdateToolz.getConfVersion(ourCnf);
                if (ourVer == null) {
                    upDate.getConfFile().remove(cnfFile);
                }
                if ((availVer = new Version(availVerStr)).isNewerThan(ourVer)) continue;
                cnfIter.remove();
            }
            Iterator jarIter = upDate.getJar().iterator();
            while (jarIter.hasNext()) {
                MCTXJar MCTXjar = (MCTXJar)jarIter.next();
                String jName = MCTXjar.getName();
                File ourJar = new File(jarDir + jName);
                if (!ourJar.exists()) continue;
                JarFile jarFile = new JarFile(ourJar);
                Attributes attr = jarFile.getManifest().getMainAttributes();
                Version ourVer = new Version(attr.getValue("MCTX-Jar-Version"));
                Version availVer = new Version(MCTXjar.getVersion());
                if (availVer.isNewerThan(ourVer)) continue;
                jarIter.remove();
            }
        }
        catch (VersionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int doUpdate(MCTXUpdate update) throws UpdateException {
        newFiles.clear();
        upFiles.clear();
        String dlUrlStr = update.getDownloadUrl();
        String confDir = (String)Init.config.get("conf.dir");
        String jarDir = (String)Init.config.get("jar.dir");
        Iterator prIter = update.getProbe().iterator();
        while (prIter.hasNext()) {
            MCTXProbe prb = (MCTXProbe)prIter.next();
            if (!prb.isUpdate()) continue;
            String jName = prb.getJavaName();
            UpdateToolz.dlProbe(dlUrlStr, jName);
        }
        Iterator jarIter = update.getJar().iterator();
        while (jarIter.hasNext()) {
            MCTXJar MCTXjar = (MCTXJar)jarIter.next();
            if (!MCTXjar.isUpdate()) continue;
            String jName = MCTXjar.getName();
            UpdateToolz.dlJarFile(dlUrlStr, jName);
        }
        Iterator cnfIter = update.getConfFile().iterator();
        while (cnfIter.hasNext()) {
            MCTXConfFile cnfFile = (MCTXConfFile)cnfIter.next();
            if (!cnfFile.isUpdate()) continue;
            String fName = cnfFile.getName();
            UpdateToolz.dlConfFile(dlUrlStr, fName);
        }
        return newFiles.size() + upFiles.size();
    }

    public static void dlProbe(String dlUrlStr, String jName) throws UpdateException {
        try {
            String probeDir = (String)Init.config.get("probe.dir");
            URL url = new URL(dlUrlStr + "/probes/" + jName + ".class");
            UpdateToolz.dlFile(url, probeDir + "/" + jName + ".class");
            url = new URL(dlUrlStr + "/probes/" + jName + ".java");
            UpdateToolz.dlFile(url, probeDir + "/" + jName + ".java");
            Probe prb = ProbeToolz.loadProbeFromFile(new File(probeDir + "/" + jName + ".class"));
            ProbeToolz.removeProbe(prb.getProbeId());
            int index = ProbeToolz.getIndex(Init.allProbeVect, prb);
            if (index != -1) {
                Init.loadProbe(prb, index);
            }
        }
        catch (MalformedURLException e) {
            throw new UpdateException("Malformed Download URL");
        }
    }

    public static void dlConfFile(String dlUrlStr, String fName) throws UpdateException {
        try {
            String confDir = (String)Init.config.get("conf.dir");
            URL url = new URL(dlUrlStr + "/conf/" + fName);
            UpdateToolz.dlFile(url, confDir + "/" + fName);
        }
        catch (MalformedURLException e) {
            throw new UpdateException("Malformed Download URL");
        }
    }

    public static void dlJarFile(String dlUrlStr, String jName) throws UpdateException {
        try {
            String jarDir = (String)Init.config.get("jar.dir");
            URL url = new URL(dlUrlStr + "/dist/" + jName);
            UpdateToolz.dlFile(url, jarDir + "/" + jName);
        }
        catch (MalformedURLException e) {
            throw new UpdateException("Malformed Download URL");
        }
    }

    public static void dlFile(URL fLoc, String destFile) {
        try {
            int red;
            byte[] buf = new byte[256];
            InputStream flIn = fLoc.openStream();
            File dest = new File(destFile);
            if (dest.exists()) {
                upFiles.add(dest.getName());
            } else {
                newFiles.add(dest.getName());
                dest.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(dest);
            while ((red = flIn.read(buf)) != -1) {
                fos.write(buf, 0, red);
            }
        }
        catch (IOException e) {
            Init.doError("File Download Failed", e);
        }
    }

    public static Version getConfVersion(File file) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = br.readLine().trim();
            Version ver = new Version(line);
            return ver;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (VersionException e) {
            e.printStackTrace();
        }
        return null;
    }
}

