/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.lib;

import com.securitycentric.metacoretex.interfaces.VersionProbe;
import com.securitycentric.metacoretex.lib.AbstractProbe;
import com.securitycentric.metacoretex.lib.ProbeException;
import com.securitycentric.metacoretex.lib.Version;
import com.securitycentric.metacoretex.lib.VersionException;

public class AbstractVersionProbe
extends AbstractProbe
implements VersionProbe {
    String kbKey = "none";
    boolean match = false;
    Version testVer;

    public String getKbKey() {
        return this.kbKey;
    }

    public Version getTestVersion() {
        return this.testVer;
    }

    public boolean matchRelease() {
        return this.match;
    }

    public void setKbKey(String key) {
        this.kbKey = key;
    }

    public void setMatchRelease(boolean mat) {
        this.match = mat;
    }

    public void setTestVersion(String ver) {
        try {
            this.testVer = new Version(ver);
        }
        catch (VersionException ve) {
            this.testVer = null;
        }
    }

    public void probe() throws ProbeException {
        if (this.testVer == null) {
            throw new ProbeException("Must set test version to ver string like 3.3.5232.3");
        }
        if (this.kbKey.matches("none")) {
            throw new ProbeException("Must set KB key (like oracle/Version)");
        }
        if (!this.kbHas(this.kbKey)) {
            return;
        }
        Object obj = this.kbGet(this.kbKey);
        if (!(obj instanceof Version)) {
            throw new ProbeException("object at " + this.kbKey + " is a " + obj.getClass().getName() + " and should be Version");
        }
        Version targVer = (Version)obj;
        if (this.match && targVer.verInt(0) != this.testVer.verInt(0)) {
            return;
        }
        if (targVer.isOlderThan(this.testVer)) {
            this.setReportable(true);
        }
    }
}

