/*
 * Decompiled with CFR 0.152.
 */
package com.securitycentric.metacoretex.lib;

import com.securitycentric.metacoretex.Init;
import com.securitycentric.metacoretex.interfaces.Probe;
import com.securitycentric.metacoretex.lib.ProbeException;
import com.securitycentric.metacoretex.lib.Target;
import com.securitycentric.metacoretex.lib.Version;
import com.securitycentric.metacoretex.lib.VersionException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class AbstractProbe
implements Probe {
    public int probeId = -1;
    public int severity = 0;
    public int timeout = 42666;
    public Properties options = new Properties();
    public Target target;
    public ProbeException pException = null;
    public String repStr = "No Report";
    public String nameStr = "Probe X";
    public Version version = null;
    public String unspec = "unknown";
    public String copyright = "unspecified";
    public String helpStr = "No Help Available";
    public boolean enabled = true;
    public boolean safe = true;
    public boolean reportable = false;
    public Vector depVect = new Vector();
    public Hashtable provHash = new Hashtable();
    public String familyStr = "Misc";

    public void run() {
        Thread.yield();
        try {
            if (Init.safeChecks) {
                this.probeSafe();
            } else {
                this.probe();
            }
        }
        catch (ProbeException pe) {
            this.pException = pe;
        }
    }

    public int getProbeId() {
        return this.probeId;
    }

    public void setProbeId(int x) {
        this.probeId = x;
    }

    public String getFamily() {
        return this.familyStr;
    }

    public void setFamily(String newFam) {
        this.familyStr = newFam;
    }

    public String getName() {
        return this.nameStr;
    }

    public void setName(String myname) {
        this.nameStr = myname;
    }

    public boolean hasSafe() {
        return this.safe;
    }

    public String getReport() {
        return this.repStr;
    }

    public void setReport(String newRpt) {
        this.repStr = newRpt;
    }

    public void addReport(String reptAddStr) {
        this.repStr = this.repStr.concat(reptAddStr + "\n");
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target targ) {
        this.target = targ;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bol) {
        this.enabled = bol;
    }

    public void probeSafe() throws ProbeException {
        this.probe();
    }

    public Vector depends() {
        return this.depVect;
    }

    public Hashtable provides() {
        return this.provHash;
    }

    public Vector getOptionKeys() {
        Enumeration<Object> en = this.options.keys();
        Vector<Object> vect = new Vector<Object>();
        while (en.hasMoreElements()) {
            vect.add(en.nextElement());
        }
        return vect;
    }

    public void addProvides(String name, String descr) {
        this.provHash.put(name, descr);
    }

    public void addDepends(String name) {
        this.depVect.add(name);
    }

    public void addOption(String opt, String value) {
        this.options.setProperty(opt, value);
    }

    public String getOption(String opt) {
        return this.options.getProperty(opt);
    }

    public String getVersion() {
        if (this.version == null) {
            return this.unspec;
        }
        return this.version.toString();
    }

    public void setVersion(String ver) {
        try {
            this.version = new Version(ver);
        }
        catch (VersionException e) {
            this.version = null;
        }
    }

    public Properties dumpOptions() {
        return this.options;
    }

    public void replaceOptions(Properties prop) {
        this.options = prop;
    }

    public void kbPut(String key, Object obj) {
        this.target.kbPut(key, obj);
    }

    public Object kbGet(String key) {
        return this.target.kbGet(key);
    }

    public boolean kbHas(String key) {
        return this.target.kbHas(key);
    }

    public String getHost() {
        return this.target.getHost();
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int x) {
        this.severity = x;
    }

    public boolean isReportable() {
        return this.reportable;
    }

    public void setReportable(boolean x) {
        this.reportable = x;
    }

    public ProbeException getException() {
        return this.pException;
    }

    public String getHelp() {
        return this.helpStr;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setHelp(String help) {
        this.helpStr = help;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

