<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:key name="service-map" match="xlat/@to" use="../@from" />

<!-- A named template for processing service elements, so that it can be
     re-used within a tunnel element. -->
<xsl:template name="nmap-service">
    <xsl:param name="service-name" />
    <xsl:param name="service-data" />

    <service status="new">
       <xsl:variable name="mapped-service">
        <xsl:for-each select="document('service-map.xml')">
          <xsl:value-of select="key('service-map', $service-name)" />
        </xsl:for-each>
       </xsl:variable>

       <xsl:choose>
        <xsl:when test="string-length($mapped-service)>0">
         <xsl:value-of select="$mapped-service"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$service-name"/>
        </xsl:otherwise>
       </xsl:choose>

        <xsl:if test="$service-data/@product">
            <software status="new"><xsl:value-of select="$service-data/@product" /></software>
        </xsl:if>
        <xsl:if test="$service-data/@version">
            <version status="new"><xsl:value-of select="$service-data/@version" /></version>
        </xsl:if>
        <xsl:if test="$service-data/@extrainfo">
            <nmap-extra status="new"><xsl:value-of select="$service-data/@extrainfo" /></nmap-extra>
        </xsl:if>
    </service>
</xsl:template>

<xsl:template match="/">
<magictree xmlns:mt="http://www.gremwell.com/magictree" class="MtBranchObject">
    <testdata class="MtBranchObject">
    <!-- Only output hosts for which at least one port was noted. -->
    <xsl:for-each select="nmaprun/host[status/@state!=&quot;down&quot;]">
        <host status="new"><xsl:value-of select="address/@addr" />
        <!-- Prevent "unknown" host state from appearing -->
        <xsl:if test="status/@state!=&quot;unknown&quot;">
        <state status="new"><xsl:value-of select="status/@state" /></state>
        </xsl:if>
        <xsl:for-each select="hostnames/hostname">
        <hostname status="new"><xsl:value-of select="./@name" /></hostname>
        </xsl:for-each>
        <xsl:if test="os/osmatch/@name">
        <os status="new"><xsl:value-of select="os/osmatch/@name" />
        <accuracy status="new"><xsl:value-of select="os/osmatch/@accuracy" /></accuracy>
        </os>
        </xsl:if>
        <!--Handle IP protocols from protocol scan -->
        <xsl:for-each select="ports/port[@protocol='ip']">
        <ipproto status="new"><xsl:choose>
            <xsl:when test="service"><xsl:value-of select="service/@name" /></xsl:when>
            <xsl:otherwise><xsl:value-of select="@portid" /></xsl:otherwise>
            </xsl:choose>
            <state status="new"><xsl:value-of select="state/@state" /></state>
        </ipproto>
        </xsl:for-each>
        <xsl:if test="ports/port">
	    <!-- Uniquely select all IP protocols for the current host. -->
	    <xsl:for-each select="ports/port[not(@protocol=preceding-sibling::port/@protocol) and @protocol!='ip']">
	    <ipproto status="new"><xsl:value-of select="@protocol" />
	        <!-- Now get all ports for the current host with this
		     IP protocol. -->
		<xsl:for-each select="current()/../port[@protocol=current()/@protocol]">
		<port status="new"><xsl:value-of select="@portid" />
		    <state status="new"><xsl:value-of select="state/@state" /></state>
		    <!-- Only output probed service names. -->
		    <xsl:if test="service">
		        <xsl:choose>
		            <xsl:when test="service/@tunnel">
			           <tunnel status="new"><xsl:value-of select="service/@tunnel" />
				       <xsl:call-template name="nmap-service">
                           <xsl:with-param name="service-name" select="service/@name"/>
                           <xsl:with-param name="service-data" select="service"/>
                       </xsl:call-template>
			           </tunnel>
		            </xsl:when>
			        <xsl:otherwise>
                      <xsl:variable name="service-name" select="service/@name" />
                       <xsl:choose>
                       <xsl:when test="document('service-map.xml')/service-map/xlat[@from=$service-name]/@ssl">
                       <tunnel status="new">ssl
                       <xsl:call-template name="nmap-service">
                           <xsl:with-param name="service-name" select="$service-name"/>
                           <xsl:with-param name="service-data" select="service"/>
                       </xsl:call-template>
                       </tunnel>
                       </xsl:when>
                       <xsl:otherwise>
                       <xsl:call-template name="nmap-service">
                           <xsl:with-param name="service-name" select="$service-name"/>
                           <xsl:with-param name="service-data" select="service"/>
                       </xsl:call-template>
                       </xsl:otherwise>
                       </xsl:choose>
			        </xsl:otherwise>
			</xsl:choose>
		    </xsl:if>
		    <xsl:for-each select="script">
		        <finding status="new" class="MtTextObject">
			<xsl:attribute name="title">
				<xsl:value-of select="@id" />
			</xsl:attribute>
			<xsl:value-of select="@output" />
			</finding>	
		    </xsl:for-each>
        </port>
		</xsl:for-each>
	    </ipproto>
            </xsl:for-each>
        </xsl:if>
	</host>
    </xsl:for-each>
    </testdata>
</magictree>
</xsl:template>
</xsl:stylesheet>
