<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Removes the port number from the URL, if it is the default number for the protocol -->
<xsl:template name="canonical-url">
<xsl:param name="url" />
  <xsl:choose>
    <xsl:when test="matches($url, '^http://[^:/]+:80/')">
      <xsl:value-of select="replace($url,':80/', '/')" />
    </xsl:when>
    <xsl:when test="matches($url, '^https://[^:/]+:443/')">
      <xsl:value-of select="replace($url,':443/', '/')" />
    </xsl:when>
    <xsl:otherwise>
       <xsl:value-of select="$url" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="nikto-service">
<xsl:param name="scandetails" />
           <service status="new">http<banner status="new"><xsl:value-of select="$scandetails/@targetbanner"/></banner>
            <webapp status="new"><xsl:value-of select="$scandetails/@sitename"/>
            <xsl:for-each select="$scandetails/item">
              <url>
                <xsl:choose>
                    <xsl:when test="namelink">
                        <xsl:call-template name="canonical-url">
                        <xsl:with-param name="url" select="namelink"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                       <xsl:call-template name="canonical-url">
                       <xsl:with-param name="url" select="iplink"/>
                       </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
                <finding status="new" class="MtTextObject">
                    <xsl:attribute name="title">
                        <xsl:value-of select="description"/>
                    </xsl:attribute>
                    <xsl:attribute name="mergeID">
                        <xsl:number value="position()" format="1"/>
                    </xsl:attribute>
                    <xsl:value-of select="description"/>
                    <affects><xsl:value-of select="namelink"/></affects>
                    <source>nikto</source>
                    <id><xsl:value-of select="@id"/></id>
                    <httpmethod><xsl:value-of select="@method"/></httpmethod>
                    <xsl:if test="@osvdbid!='0'">
                    <osvdb><xsl:value-of select="@osvdbid"/></osvdb>
                    </xsl:if>
                </finding>
              </url>
            </xsl:for-each>
            </webapp>
          </service>
</xsl:template>

<xsl:template match="/">
<magictree xmlns:mt="http://www.gremwell.com/magictree" class="MtBranchObject">
   <testdata class="MtBranchObject">
    <xsl:for-each select="niktoscan/scandetails">
        <host status="new"><xsl:value-of select="@targetip"/>
         <ipproto>tcp
          <port status="new"><xsl:value-of select="@targetport"/>
            <xsl:choose>
              <xsl:when test="ssl">
              <tunnel>ssl
                <xsl:call-template name="nikto-service">
                 <xsl:with-param name="scandetails" select="current()" />
                </xsl:call-template>
              </tunnel>
              </xsl:when>
              <xsl:otherwise>
                 <xsl:call-template name="nikto-service">
                 <xsl:with-param name="scandetails" select="current()" />
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </port>
        </ipproto>
        </host>
    </xsl:for-each>
    </testdata>
</magictree>
</xsl:template>
</xsl:stylesheet>
