﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:key name="service-map" match="xlat/@to" use="../@from"/>

  <xsl:template name="mapped-service">
    <xsl:param name="service-name"/>
    <xsl:variable name="mapped-service">
      <xsl:for-each select="document('service-map.xml')">
        <xsl:value-of select="key('service-map', $service-name)"/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="string-length($mapped-service)&gt;0">
        <xsl:value-of select="$mapped-service"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$service-name"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="nexpose-service">
    <xsl:param name="service-data"/>
    <xsl:param name="affects"/>
    <xsl:variable name="mapped-service">
      <xsl:call-template name="mapped-service">
        <xsl:with-param name="service-name" select="lower-case($service-data/@name)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="document('service-map.xml')/service-map/xlat[@from=$service-data/@name]">
        <tunnel>ssl
           <service status="new"><xsl:value-of select="$mapped-service"/>
             <software><xsl:value-of select="description"/>
                <version><xsl:value-of select="version"/></version>
             </software>
	     <xsl:if test="count($service-data/vulnerabilities/vulnerability)>0">
             <xsl:call-template name="nexpose-findings">
               <xsl:with-param name="vulnerabilities" select="$service-data/vulnerabilities"/>
               <xsl:with-param name="affects" select="$affects"/>
             </xsl:call-template>
             </xsl:if>
           </service>
        </tunnel>
      </xsl:when>
      <xsl:otherwise>
        <service status="new">
          <xsl:value-of select="$mapped-service"/>
          <software>
            <xsl:value-of select="description"/>
            <version>
              <xsl:value-of select="version"/>
            </version>
          </software>
	  <xsl:if test="count($service-data/vulnerabilities/vulnerability)>0">
          <xsl:call-template name="nexpose-findings">
            <xsl:with-param name="vulnerabilities" select="$service-data/vulnerabilities"/>
            <xsl:with-param name="affects" select="$affects"/>
          </xsl:call-template>
	  </xsl:if>
        </service>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="nexpose-findings">
    <xsl:param name="vulnerabilities"/>
    <xsl:param name="affects"/>
    <xsl:for-each select="$vulnerabilities/vulnerability">
      <finding class="MtTextObject" status="new">
        <xsl:attribute name="title">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
        <source>nexpose</source>
        <id>
          <xsl:value-of select="@id"/>
        </id>
        <affects>
          <xsl:value-of select="$affects"/>
        </affects>
        <xsl:for-each select="id">
          <xsl:choose>
            <xsl:when test="@type='cve'">
              <cve>
                <xsl:value-of select="."/>
                <url>http://cve.mitre.org/cgi-bin/cvename.cgi?name=<xsl:value-of select="."/></url>
              </cve>
            </xsl:when>
            <xsl:when test="@type='bid'">
              <bid>
                <xsl:value-of select="."/>
                <url>http://www.securityfocus.com/bid/<xsl:value-of select="."/></url>
              </bid>
            </xsl:when>
            <xsl:when test="@type='osvdb'">
              <osvdb>
                <xsl:value-of select="."/>
                <url>http://osvdb.org/show/osvdb/<xsl:value-of select="."/></url>
              </osvdb>
            </xsl:when>
            <xsl:when test="@type='secunia'">
              <reference>Secunia Advisory SA<xsl:value-of select="."/>
               <url>http://secunia.com/advisories/<xsl:value-of select="."/></url>
               </reference>
            </xsl:when>
            <xsl:when test="@type='url'">
              <reference>
                <xsl:value-of select="."/>
                <url>http://secunia.com/advisories/<xsl:value-of select="."/></url>
              </reference>
            </xsl:when>
          </xsl:choose>
        </xsl:for-each>
        <xsl:value-of select="@id"/>
      </finding>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="/">
    <magictree xmlns:mt="http://www.gremwell.com/magictree" class="MtBranchObject">
      <testdata class="MtBranchObject">
        <xsl:for-each select="NeXposeSimpleXML/devices/device">
          <host status="new">
          <xsl:variable name="host">
            <xsl:value-of select="@address"/>
            </xsl:variable>
            <xsl:value-of select="$host"/>
            <xsl:if test="fingerprint/description">
              <os status="new">
                <xsl:value-of select="fingerprint/description"/>
                <xsl:if test="string-length(fingerprint/description/version)&gt;0">
                  <version status="new">
                    <xsl:value-of select="fingerprint/description/version"/>
                  </version>
                </xsl:if>
              </os>
            </xsl:if>
            <xsl:for-each select="vulnerabilities/vulnerability">
		<xsl:call-template name="nexpose-findings">
		  <xsl:with-param name="vulnerabilities" select="vulnerabilities"/>
                  <xsl:with-param name="affects" select="$host"/>
                </xsl:call-template>
            </xsl:for-each>
            <xsl:for-each select="services/service">
              <ipproto status="new">
                <xsl:value-of select="@protocol"/>
                <port status="new">
                  <xsl:value-of select="@port"/>
                   <xsl:call-template name="nexpose-service">
                     <xsl:with-param name="service-data" select="."/>
                     <xsl:with-param name="affects" select="concat($host, ':', @port, ' (', @protocol,')')"/>
                   </xsl:call-template>
                </port>
              </ipproto>
            </xsl:for-each>
          </host>
        </xsl:for-each>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
