if [ -z "$id" ] ; then
        echo "UUID environment variable '\$id' is empty" >&2
        exit 1
fi

if [ -z "$prefix" ] ; then
        echo "Spool files environment variable '\$prefix' is empty" >&2
        exit 1
fi

nsessionmisses=0
nexitcodemisses=0

while true ; do
	## Screen options
	## 	set session id
	## 	wipe stale sessions
	## 	quiet, list only
	if screen -wipe | egrep -q "^	[0-9]+.S$id	" ; then
		## we have a session
		sawsession=1
	else
		## there is no live SCREEN now
		if [ -r "$prefix..EXITCODE" ] ; then
			## found exitcode file
			echo "-----BEGIN WAITFORv1 OUTPUT-----"
			cat "$prefix..EXITCODE"
			echo "-----END WAITFORv1 OUTPUT-----"
			exit 0
		fi

		if [ -f "$prefix..SH.PID" ] ; then
			shpid=`cat $prefix..SH.PID`
			if kill -0 `cat $prefix..SH.PID`> /dev/null 2>&1 ; then
				if ps hwp $shpid | grep -q $prefix ; then
					## SCREEN has died prematurely, but wrapper has survived
					continue
				else
					## both SCREEN and top-level wrapper are dead or we are hit by race condition
					## (do nothing, rely on timeout check below to clear this condition)
					true
				fi
			else
				## both SCREEN and top-level wrapper are dead or we are hit by race condition
				## (do nothing, rely on timeout check below to clear this condition)
				true
			fi
		fi

		## there is no live SCREEN session nor wrapper nor exitcode file
		nmisses=`expr $nmisses + 1`
		if [ $nmisses -gt 3 ] ; then
			## something went wrong: create error log file
			## (don't write too much to stderr to avoid deadlocks)
			errfile="$prefix.waitfor.err.$$"
			echo "See '$errfile' file." >&2
			echo "screen/wrapper/exitcode not found: pid=$$, id=$id, prefix=$prefix" > "$errfile"
			## dump processes
			ps axeww >> "$errfile"
			## dump files
			for f in $prefix* ; do
				if [ -r "$f" -a "$f" != "$errfile" ] ; then
					echo "=== === === ===" >> "$errfile"
					ls -l "$f" >> "$errfile"
					cat -nA $f >> "$errfile"
				fi
			done
			exit 101
		fi
	fi

	sleep 1
done
