if [ -x /bin/which ] ; then which=/bin/which
elif [ -x /usr/bin/which ] ; then which=/usr/bin/which
else which=which ; fi

dirname=`$which dirname`
[ -x "$dirname" ] || dirname=/bin/dirname
cfg="`$dirname \"$0\"`/config"
. "$cfg"

usage() {
	echo "Usage: push-ssh-key" >&2
	exit 1
}

if [ ! -r "$dotsshdir/id_rsa" ] ; then
	mkdir -p "$dotsshdir"
	ssh-keygen -N "" -f "$dotsshdir/id_rsa" -C "Autogenerated by MagicTree"
fi

while true ; do
	echo -n "Remote SSH server (username@host, or Ctrl-C to exit): "
	read sshserver

	if [ -z "$sshserver" ] ; then
		exit
	fi

	echo "Pushing the public key into $sshserver ..."
	(
		echo "mkdir -p ~/.ssh";
		echo "cat >> ~/.ssh/authorized_keys << 'END'";
		cat "$dotsshdir/id_rsa.pub";
		echo "END"
	) | ssh -o UserKnownHostsFile="\"$dotsshdir/known_hosts\"" "$sshserver" sh

	echo "Trying to log into '$sshserver' ..."
	if ssh -i "$dotsshdir/id_rsa" -o UserKnownHostsFile="\"$dotsshdir/known_hosts\"" -o BatchMode=yes "$sshserver" true ; then
		echo "Succeeded!"
	else
		echo "ERROR: failed to log into '$sshserver' without a password"
	fi
	echo
done

