if [ -z "$prefix" ] ; then
        echo "Spool files environment variable '\$prefix' is empty" >&2
        exit 1
fi

if [ -z "$id" ] ; then
        echo "Environment variable '\$id' is empty" >&2
        exit 1
fi

## it is acceptable for suffix to be emtpy
#if [ -z "$suffix" ] ; then
#        echo "Environment variable '\$suffix' is empty" >&2
#        exit 1
#fi

file="$prefix$suffix"
if [ ! -e "$file" ] ; then
    echo "Task output file '$file' does not exist, but was seen earlier, aborting pickup." >&2
    exit 1
fi

if [ ! -f "$file" ] ; then
    echo "Task output file '$file' is not a regular file, aborting pickup." >&2
    exit 1
fi

if [ ! -r "$file" ] ; then
    echo "Task output file '$file' is not readable, aborting pickup. Check your umask and the file permissions. To recover, set the file permissions to make it readable, save and re-open MagicTree project." >&2
    exit 1
fi

echo "-----BEGIN CATv1 OUTPUT-----"
cat "$file"
echo "-----END CATv1 OUTPUT-----"
