/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.text.DecimalFormat;

public class TooLargeFileException
extends Exception {
    private static final long serialVersionUID = 6091096838075139962L;
    private long size;

    public TooLargeFileException(long size) {
        this.size = size;
    }

    public String getReadableFileSize() {
        if (this.size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(this.size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)this.size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }
}

