/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.DropListener;
import us.deathmarine.luyten.FileDialog;
import us.deathmarine.luyten.FileSaver;
import us.deathmarine.luyten.FindAllBox;
import us.deathmarine.luyten.FindBox;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;
import us.deathmarine.luyten.MainMenuBar;
import us.deathmarine.luyten.Model;
import us.deathmarine.luyten.RecentFiles;
import us.deathmarine.luyten.WindowPosition;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 5265556630724988013L;
    private static final String TITLE = "Luyten";
    public static Model model;
    private JProgressBar bar;
    private JLabel label;
    FindBox findBox;
    private FindAllBox findAllBox;
    private ConfigSaver configSaver = ConfigSaver.getLoadedInstance();
    private WindowPosition windowPosition = this.configSaver.getMainWindowPosition();
    private LuytenPreferences luytenPrefs = this.configSaver.getLuytenPreferences();
    private FileDialog fileDialog;
    private FileSaver fileSaver;
    public MainMenuBar mainMenuBar = new MainMenuBar(this);

    public MainWindow(File fileFromCommandLine) {
        this.setJMenuBar(this.mainMenuBar);
        this.adjustWindowPositionBySavedState();
        this.setHideFindBoxOnMainWindowFocus();
        this.setShowFindAllBoxOnMainWindowFocus();
        this.setQuitOnWindowClosing();
        this.setTitle(TITLE);
        this.setIconImage(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/Luyten.png"))).getImage());
        JPanel panel1 = new JPanel(new FlowLayout(0));
        this.label = new JLabel();
        this.label.setHorizontalAlignment(2);
        panel1.setBorder(new BevelBorder(1));
        panel1.setPreferredSize(new Dimension(this.getWidth() / 2, 20));
        panel1.add(this.label);
        JPanel panel2 = new JPanel(new FlowLayout(2));
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.bar.setOpaque(false);
        this.bar.setVisible(false);
        panel2.setPreferredSize(new Dimension(this.getWidth() / 3, 20));
        panel2.add(this.bar);
        model = new Model(this);
        this.getContentPane().add(model);
        JSplitPane spt = new JSplitPane(1, (Component)panel1, (Component)panel2){
            private static final long serialVersionUID = 2189946972124687305L;
            private final int location = 400;
            {
                this.location = 400;
                this.setDividerLocation(400);
            }

            @Override
            public int getDividerLocation() {
                return 400;
            }

            @Override
            public int getLastDividerLocation() {
                return 400;
            }
        };
        spt.setBorder(new BevelBorder(1));
        spt.setPreferredSize(new Dimension(this.getWidth(), 24));
        this.add((Component)spt, "South");
        if (fileFromCommandLine != null) {
            model.loadFile(fileFromCommandLine);
        }
        try {
            DropTarget dt = new DropTarget();
            dt.addDropTargetListener(new DropListener(this));
            this.setDropTarget(dt);
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
        this.fileDialog = new FileDialog(this);
        this.fileSaver = new FileSaver(this.bar, this.label);
        this.setExitOnEscWhenEnabled(model);
        if (fileFromCommandLine == null || fileFromCommandLine.getName().toLowerCase().endsWith(".jar") || fileFromCommandLine.getName().toLowerCase().endsWith(".zip")) {
            model.startWarmUpThread();
        }
        if (RecentFiles.load() > 0) {
            this.mainMenuBar.updateRecentFiles();
        }
    }

    public void onOpenFileMenu() {
        File selectedFile = this.fileDialog.doOpenDialog();
        if (selectedFile != null) {
            System.out.println("[Open]: Opening " + selectedFile.getAbsolutePath());
            this.getModel().loadFile(selectedFile);
        }
    }

    public void onCloseFileMenu() {
        this.getModel().closeFile();
    }

    public void onSaveAsMenu() {
        RSyntaxTextArea pane = this.getModel().getCurrentTextArea();
        if (pane == null) {
            return;
        }
        String tabTitle = this.getModel().getCurrentTabTitle();
        if (tabTitle == null) {
            return;
        }
        String recommendedFileName = tabTitle.replace(".class", ".java");
        File selectedFile = this.fileDialog.doSaveDialog(recommendedFileName);
        if (selectedFile != null) {
            this.fileSaver.saveText(pane.getText(), selectedFile);
        }
    }

    public void onSaveAllMenu() {
        File openedFile = this.getModel().getOpenedFile();
        if (openedFile == null) {
            return;
        }
        String fileName = openedFile.getName();
        fileName = fileName.endsWith(".class") ? fileName.replace(".class", ".java") : (fileName.toLowerCase().endsWith(".jar") ? "decompiled-" + fileName.replaceAll("\\.[jJ][aA][rR]", ".zip") : "saved-" + fileName);
        File selectedFileToSave = this.fileDialog.doSaveAllDialog(fileName);
        if (selectedFileToSave != null) {
            this.fileSaver.saveAllDecompiled(openedFile, selectedFileToSave);
        }
    }

    public void onExitMenu() {
        this.quit();
    }

    public void onSelectAllMenu() {
        try {
            RSyntaxTextArea pane = this.getModel().getCurrentTextArea();
            if (pane != null) {
                pane.requestFocusInWindow();
                pane.setSelectionStart(0);
                pane.setSelectionEnd(pane.getText().length());
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    public void onFindMenu() {
        try {
            RSyntaxTextArea pane = this.getModel().getCurrentTextArea();
            if (pane != null) {
                if (this.findBox == null) {
                    this.findBox = new FindBox(this);
                }
                this.findBox.showFindBox();
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    public void onFindAllMenu() {
        try {
            if (this.findAllBox == null) {
                this.findAllBox = new FindAllBox(this);
            }
            this.findAllBox.showFindBox();
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    public void onLegalMenu() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MainWindow.this.bar.setVisible(true);
                    MainWindow.this.bar.setIndeterminate(true);
                    String legalStr = MainWindow.this.getLegalStr();
                    MainWindow.this.getModel().showLegal(legalStr);
                }
                finally {
                    MainWindow.this.bar.setIndeterminate(false);
                    MainWindow.this.bar.setVisible(false);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onListLoadedClasses() {
        try {
            StringBuilder sb = new StringBuilder();
            this.bar.setVisible(true);
            this.bar.setIndeterminate(true);
            for (ClassLoader myCL = Thread.currentThread().getContextClassLoader(); myCL != null; myCL = myCL.getParent()) {
                sb.append("ClassLoader: " + myCL + "\n");
                Iterator<?> iter = MainWindow.list(myCL);
                while (iter.hasNext()) {
                    sb.append("\t" + iter.next() + "\n");
                }
            }
            this.getModel().show("Debug", sb.toString());
        }
        finally {
            this.bar.setIndeterminate(false);
            this.bar.setVisible(false);
        }
    }

    private static Iterator<?> list(ClassLoader CL) {
        Class<?> CL_class;
        for (CL_class = CL.getClass(); CL_class != ClassLoader.class; CL_class = CL_class.getSuperclass()) {
        }
        try {
            Field ClassLoader_classes_field = CL_class.getDeclaredField("classes");
            ClassLoader_classes_field.setAccessible(true);
            Vector classes = (Vector)ClassLoader_classes_field.get(CL);
            return classes.iterator();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Luyten.showExceptionDialog("Exception!", e);
            return null;
        }
    }

    private String getLegalStr() {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/distfiles/Procyon.License.txt")));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            sb.append("\n\n\n\n\n");
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/distfiles/RSyntaxTextArea.License.txt")));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
        return sb.toString();
    }

    public void onThemesChanged() {
        this.getModel().changeTheme(this.luytenPrefs.getThemeXml());
        this.luytenPrefs.setFont_size(this.getModel().getTheme().baseFont.getSize());
    }

    public void onSettingsChanged() {
        this.getModel().updateOpenClasses();
    }

    public void onTreeSettingsChanged() {
        this.getModel().updateTree();
    }

    public void onFileDropped(File file) {
        if (file != null) {
            this.getModel().loadFile(file);
        }
    }

    public void onFileLoadEnded(File file, boolean isSuccess) {
        try {
            if (file != null && isSuccess) {
                this.setTitle("Luyten - " + file.getName());
            } else {
                this.setTitle(TITLE);
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    public void onNavigationRequest(String uniqueStr) {
        this.getModel().navigateTo(uniqueStr);
    }

    private void adjustWindowPositionBySavedState() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (!this.windowPosition.isSavedWindowPositionValid()) {
            Dimension center = new Dimension((int)((double)screenSize.width * 0.75), (int)((double)screenSize.height * 0.75));
            int x = (int)((double)center.width * 0.2);
            int y = (int)((double)center.height * 0.2);
            this.setBounds(x, y, center.width, center.height);
        } else if (this.windowPosition.isFullScreen()) {
            int heightMinusTray = screenSize.height;
            if (screenSize.height > 30) {
                heightMinusTray -= 30;
            }
            this.setBounds(0, 0, screenSize.width, heightMinusTray);
            this.setExtendedState(6);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (MainWindow.this.getExtendedState() != 6) {
                        MainWindow.this.windowPosition.setFullScreen(false);
                        if (MainWindow.this.windowPosition.isSavedWindowPositionValid()) {
                            MainWindow.this.setBounds(MainWindow.this.windowPosition.getWindowX(), MainWindow.this.windowPosition.getWindowY(), MainWindow.this.windowPosition.getWindowWidth(), MainWindow.this.windowPosition.getWindowHeight());
                        }
                        MainWindow.this.removeComponentListener(this);
                    }
                }
            });
        } else {
            this.setBounds(this.windowPosition.getWindowX(), this.windowPosition.getWindowY(), this.windowPosition.getWindowWidth(), this.windowPosition.getWindowHeight());
        }
    }

    private void setHideFindBoxOnMainWindowFocus() {
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (MainWindow.this.findBox != null && MainWindow.this.findBox.isVisible()) {
                    MainWindow.this.findBox.setVisible(false);
                }
            }
        });
    }

    private void setShowFindAllBoxOnMainWindowFocus() {
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (MainWindow.this.findAllBox != null && MainWindow.this.findAllBox.isVisible()) {
                    MainWindow.this.findAllBox.setVisible(false);
                }
            }
        });
    }

    private void setQuitOnWindowClosing() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.quit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quit() {
        try {
            this.windowPosition.readPositionFromWindow(this);
            this.configSaver.saveConfig();
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
        finally {
            try {
                this.dispose();
            }
            finally {
                System.exit(0);
            }
        }
    }

    private void setExitOnEscWhenEnabled(JComponent mainComponent) {
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -3460391555954575248L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainWindow.this.luytenPrefs.isExitByEscEnabled()) {
                    MainWindow.this.quit();
                }
            }
        };
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        mainComponent.getInputMap(1).put(escapeKeyStroke, "ESCAPE");
        mainComponent.getActionMap().put("ESCAPE", escapeAction);
    }

    public Model getModel() {
        return model;
    }

    public JProgressBar getBar() {
        return this.bar;
    }

    public JLabel getLabel() {
        return this.label;
    }
}

