/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import com.strobel.Procyon;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.languages.Language;
import com.strobel.decompiler.languages.Languages;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;
import us.deathmarine.luyten.MainWindow;
import us.deathmarine.luyten.RecentFiles;

public class MainMenuBar
extends JMenuBar {
    private static final long serialVersionUID = -7949855817172562075L;
    private final MainWindow mainWindow;
    private final Map<String, Language> languageLookup = new HashMap<String, Language>();
    private JMenu recentFiles;
    private JMenuItem clearRecentFiles;
    private JCheckBoxMenuItem flattenSwitchBlocks;
    private JCheckBoxMenuItem forceExplicitImports;
    private JCheckBoxMenuItem forceExplicitTypes;
    private JCheckBoxMenuItem showSyntheticMembers;
    private JCheckBoxMenuItem excludeNestedTypes;
    private JCheckBoxMenuItem retainRedundantCasts;
    private JCheckBoxMenuItem unicodeReplacement;
    private JCheckBoxMenuItem debugLineNumbers;
    private JCheckBoxMenuItem showDebugInfo;
    private JCheckBoxMenuItem bytecodeLineNumbers;
    private JRadioButtonMenuItem java;
    private JRadioButtonMenuItem bytecode;
    private JRadioButtonMenuItem bytecodeAST;
    private ButtonGroup languagesGroup;
    private ButtonGroup themesGroup;
    private JCheckBoxMenuItem packageExplorerStyle;
    private JCheckBoxMenuItem filterOutInnerClassEntries;
    private JCheckBoxMenuItem singleClickOpenEnabled;
    private JCheckBoxMenuItem exitByEscEnabled;
    private DecompilerSettings settings;
    private LuytenPreferences luytenPrefs;

    public MainMenuBar(MainWindow mainWnd) {
        this.mainWindow = mainWnd;
        final ConfigSaver configSaver = ConfigSaver.getLoadedInstance();
        this.settings = configSaver.getDecompilerSettings();
        this.luytenPrefs = configSaver.getLuytenPreferences();
        final JMenu fileMenu = new JMenu("File");
        fileMenu.add(new JMenuItem("..."));
        this.add(fileMenu);
        final JMenu editMenu = new JMenu("Edit");
        editMenu.add(new JMenuItem("..."));
        this.add(editMenu);
        final JMenu themesMenu = new JMenu("Themes");
        themesMenu.add(new JMenuItem("..."));
        this.add(themesMenu);
        final JMenu operationMenu = new JMenu("Operation");
        operationMenu.add(new JMenuItem("..."));
        this.add(operationMenu);
        final JMenu settingsMenu = new JMenu("Settings");
        settingsMenu.add(new JMenuItem("..."));
        this.add(settingsMenu);
        final JMenu helpMenu = new JMenu("Help");
        helpMenu.add(new JMenuItem("..."));
        this.add(helpMenu);
        new Thread(){

            @Override
            public void run() {
                try {
                    MainMenuBar.this.buildFileMenu(fileMenu);
                    this.refreshMenuPopup(fileMenu);
                    MainMenuBar.this.buildEditMenu(editMenu);
                    this.refreshMenuPopup(editMenu);
                    MainMenuBar.this.buildThemesMenu(themesMenu);
                    this.refreshMenuPopup(themesMenu);
                    MainMenuBar.this.buildOperationMenu(operationMenu);
                    this.refreshMenuPopup(operationMenu);
                    MainMenuBar.this.buildSettingsMenu(settingsMenu, configSaver);
                    this.refreshMenuPopup(settingsMenu);
                    MainMenuBar.this.buildHelpMenu(helpMenu);
                    this.refreshMenuPopup(helpMenu);
                    MainMenuBar.this.updateRecentFiles();
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }

            private void refreshMenuPopup(JMenu menu) {
                try {
                    if (menu.isPopupMenuVisible()) {
                        menu.getPopupMenu().setVisible(false);
                        menu.getPopupMenu().setVisible(true);
                    }
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }
        }.start();
    }

    public void updateRecentFiles() {
        if (RecentFiles.paths.isEmpty()) {
            this.recentFiles.setEnabled(false);
            this.clearRecentFiles.setEnabled(false);
            return;
        }
        this.recentFiles.setEnabled(true);
        this.clearRecentFiles.setEnabled(true);
        this.recentFiles.removeAll();
        ListIterator<String> li = RecentFiles.paths.listIterator(RecentFiles.paths.size());
        boolean rfSaveNeeded = false;
        while (li.hasPrevious()) {
            String path = li.previous();
            final File file = new File(path);
            if (!file.exists()) {
                rfSaveNeeded = true;
                continue;
            }
            JMenuItem menuItem = new JMenuItem(path);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.mainWindow.getModel().loadFile(file);
                }
            });
            this.recentFiles.add(menuItem);
        }
        if (rfSaveNeeded) {
            RecentFiles.save();
        }
    }

    private void buildFileMenu(JMenu fileMenu) {
        fileMenu.removeAll();
        JMenuItem menuItem = new JMenuItem("Open File...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.mainWindow.onOpenFileMenu();
            }
        });
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem("Close File");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane house = ((MainMenuBar)MainMenuBar.this).mainWindow.getModel().house;
                if (e.getModifiers() != 2 || house.getTabCount() == 0) {
                    MainMenuBar.this.mainWindow.onCloseFileMenu();
                } else {
                    MainMenuBar.this.mainWindow.getModel().closeOpenTab(house.getSelectedIndex());
                }
            }
        });
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem("Save As...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.mainWindow.onSaveAsMenu();
            }
        });
        fileMenu.add(menuItem);
        menuItem = new JMenuItem("Save All...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.mainWindow.onSaveAllMenu();
            }
        });
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        this.recentFiles = new JMenu("Recent Files");
        fileMenu.add(this.recentFiles);
        this.clearRecentFiles = new JMenuItem("Clear Recent Files");
        this.clearRecentFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentFiles.paths.clear();
                RecentFiles.save();
                MainMenuBar.this.updateRecentFiles();
            }
        });
        fileMenu.add(this.clearRecentFiles);
        fileMenu.addSeparator();
        if (!"true".equals(System.getProperty("us.deathmarine.luyten.Luyten.running_in_osx"))) {
            menuItem = new JMenuItem("Exit");
            menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.mainWindow.onExitMenu();
                }
            });
            fileMenu.add(menuItem);
        }
    }

    private void buildEditMenu(JMenu editMenu) {
        editMenu.removeAll();
        JMenuItem menuItem = new JMenuItem("Cut");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setEnabled(false);
        editMenu.add(menuItem);
        menuItem = new JMenuItem("Copy");
        menuItem.addActionListener(new DefaultEditorKit.CopyAction());
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        editMenu.add(menuItem);
        menuItem = new JMenuItem("Paste");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setEnabled(false);
        editMenu.add(menuItem);
        editMenu.addSeparator();
        menuItem = new JMenuItem("Select All");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.mainWindow.onSelectAllMenu();
            }
        });
        editMenu.add(menuItem);
        editMenu.addSeparator();
        menuItem = new JMenuItem("Find...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.mainWindow.onFindMenu();
            }
        });
        editMenu.add(menuItem);
        menuItem = new JMenuItem("Find Next");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((MainMenuBar)MainMenuBar.this).mainWindow.findBox != null) {
                    ((MainMenuBar)MainMenuBar.this).mainWindow.findBox.fireExploreAction(true);
                }
            }
        });
        editMenu.add(menuItem);
        menuItem = new JMenuItem("Find Previous");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(114, 64));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((MainMenuBar)MainMenuBar.this).mainWindow.findBox != null) {
                    ((MainMenuBar)MainMenuBar.this).mainWindow.findBox.fireExploreAction(false);
                }
            }
        });
        editMenu.add(menuItem);
        menuItem = new JMenuItem("Find All");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.mainWindow.onFindAllMenu();
            }
        });
        editMenu.add(menuItem);
    }

    private void buildThemesMenu(JMenu themesMenu) {
        themesMenu.removeAll();
        this.themesGroup = new ButtonGroup();
        JRadioButtonMenuItem a = new JRadioButtonMenuItem(new ThemeAction("Default", "default.xml"));
        a.setSelected("default.xml".equals(this.luytenPrefs.getThemeXml()));
        this.themesGroup.add(a);
        themesMenu.add(a);
        a = new JRadioButtonMenuItem(new ThemeAction("Default-Alt", "default-alt.xml"));
        a.setSelected("default-alt.xml".equals(this.luytenPrefs.getThemeXml()));
        this.themesGroup.add(a);
        themesMenu.add(a);
        a = new JRadioButtonMenuItem(new ThemeAction("Dark", "dark.xml"));
        a.setSelected("dark.xml".equals(this.luytenPrefs.getThemeXml()));
        this.themesGroup.add(a);
        themesMenu.add(a);
        a = new JRadioButtonMenuItem(new ThemeAction("Eclipse", "eclipse.xml"));
        a.setSelected("eclipse.xml".equals(this.luytenPrefs.getThemeXml()));
        this.themesGroup.add(a);
        themesMenu.add(a);
        a = new JRadioButtonMenuItem(new ThemeAction("Visual Studio", "vs.xml"));
        a.setSelected("vs.xml".equals(this.luytenPrefs.getThemeXml()));
        this.themesGroup.add(a);
        themesMenu.add(a);
        a = new JRadioButtonMenuItem(new ThemeAction("IntelliJ", "idea.xml"));
        a.setSelected("idea.xml".equals(this.luytenPrefs.getThemeXml()));
        this.themesGroup.add(a);
        themesMenu.add(a);
    }

    private void buildOperationMenu(JMenu operationMenu) {
        operationMenu.removeAll();
        this.packageExplorerStyle = new JCheckBoxMenuItem("Package Explorer Style");
        this.packageExplorerStyle.setSelected(this.luytenPrefs.isPackageExplorerStyle());
        this.packageExplorerStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.luytenPrefs.setPackageExplorerStyle(MainMenuBar.this.packageExplorerStyle.isSelected());
                MainMenuBar.this.mainWindow.onTreeSettingsChanged();
            }
        });
        operationMenu.add(this.packageExplorerStyle);
        this.filterOutInnerClassEntries = new JCheckBoxMenuItem("Filter Out Inner Class Entries");
        this.filterOutInnerClassEntries.setSelected(this.luytenPrefs.isFilterOutInnerClassEntries());
        this.filterOutInnerClassEntries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.luytenPrefs.setFilterOutInnerClassEntries(MainMenuBar.this.filterOutInnerClassEntries.isSelected());
                MainMenuBar.this.mainWindow.onTreeSettingsChanged();
            }
        });
        operationMenu.add(this.filterOutInnerClassEntries);
        this.singleClickOpenEnabled = new JCheckBoxMenuItem("Single Click Open");
        this.singleClickOpenEnabled.setSelected(this.luytenPrefs.isSingleClickOpenEnabled());
        this.singleClickOpenEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.luytenPrefs.setSingleClickOpenEnabled(MainMenuBar.this.singleClickOpenEnabled.isSelected());
            }
        });
        operationMenu.add(this.singleClickOpenEnabled);
        this.exitByEscEnabled = new JCheckBoxMenuItem("Exit By Esc");
        this.exitByEscEnabled.setSelected(this.luytenPrefs.isExitByEscEnabled());
        this.exitByEscEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.luytenPrefs.setExitByEscEnabled(MainMenuBar.this.exitByEscEnabled.isSelected());
            }
        });
        operationMenu.add(this.exitByEscEnabled);
    }

    private void buildSettingsMenu(JMenu settingsMenu, ConfigSaver configSaver) {
        settingsMenu.removeAll();
        ActionListener settingsChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        MainMenuBar.this.populateSettingsFromSettingsMenu();
                        MainMenuBar.this.mainWindow.onSettingsChanged();
                    }
                }.start();
            }
        };
        this.flattenSwitchBlocks = new JCheckBoxMenuItem("Flatten Switch Blocks");
        this.flattenSwitchBlocks.setSelected(this.settings.getFlattenSwitchBlocks());
        this.flattenSwitchBlocks.addActionListener(settingsChanged);
        settingsMenu.add(this.flattenSwitchBlocks);
        this.forceExplicitImports = new JCheckBoxMenuItem("Force Explicit Imports");
        this.forceExplicitImports.setSelected(this.settings.getForceExplicitImports());
        this.forceExplicitImports.addActionListener(settingsChanged);
        settingsMenu.add(this.forceExplicitImports);
        this.forceExplicitTypes = new JCheckBoxMenuItem("Force Explicit Types");
        this.forceExplicitTypes.setSelected(this.settings.getForceExplicitTypeArguments());
        this.forceExplicitTypes.addActionListener(settingsChanged);
        settingsMenu.add(this.forceExplicitTypes);
        this.showSyntheticMembers = new JCheckBoxMenuItem("Show Synthetic Members");
        this.showSyntheticMembers.setSelected(this.settings.getShowSyntheticMembers());
        this.showSyntheticMembers.addActionListener(settingsChanged);
        settingsMenu.add(this.showSyntheticMembers);
        this.excludeNestedTypes = new JCheckBoxMenuItem("Exclude Nested Types");
        this.excludeNestedTypes.setSelected(this.settings.getExcludeNestedTypes());
        this.excludeNestedTypes.addActionListener(settingsChanged);
        settingsMenu.add(this.excludeNestedTypes);
        this.retainRedundantCasts = new JCheckBoxMenuItem("Retain Redundant Casts");
        this.retainRedundantCasts.setSelected(this.settings.getRetainRedundantCasts());
        this.retainRedundantCasts.addActionListener(settingsChanged);
        settingsMenu.add(this.retainRedundantCasts);
        this.unicodeReplacement = new JCheckBoxMenuItem("Enable Unicode Replacement");
        this.unicodeReplacement.setSelected(this.settings.isUnicodeOutputEnabled());
        this.unicodeReplacement.addActionListener(settingsChanged);
        settingsMenu.add(this.unicodeReplacement);
        this.debugLineNumbers = new JCheckBoxMenuItem("Show Debug Line Numbers");
        this.debugLineNumbers.setSelected(this.settings.getShowDebugLineNumbers());
        this.debugLineNumbers.addActionListener(settingsChanged);
        settingsMenu.add(this.debugLineNumbers);
        JMenu debugSettingsMenu = new JMenu("Debug Settings");
        this.showDebugInfo = new JCheckBoxMenuItem("Include Error Diagnostics");
        this.showDebugInfo.setSelected(this.settings.getIncludeErrorDiagnostics());
        this.showDebugInfo.addActionListener(settingsChanged);
        debugSettingsMenu.add(this.showDebugInfo);
        settingsMenu.add(debugSettingsMenu);
        settingsMenu.addSeparator();
        this.languageLookup.put(Languages.java().getName(), Languages.java());
        this.languageLookup.put(Languages.bytecode().getName(), Languages.bytecode());
        this.languageLookup.put(Languages.bytecodeAst().getName(), Languages.bytecodeAst());
        this.languagesGroup = new ButtonGroup();
        this.java = new JRadioButtonMenuItem(Languages.java().getName());
        this.java.getModel().setActionCommand(Languages.java().getName());
        this.java.setSelected(Languages.java().getName().equals(this.settings.getLanguage().getName()));
        this.languagesGroup.add(this.java);
        settingsMenu.add(this.java);
        this.bytecode = new JRadioButtonMenuItem(Languages.bytecode().getName());
        this.bytecode.getModel().setActionCommand(Languages.bytecode().getName());
        this.bytecode.setSelected(Languages.bytecode().getName().equals(this.settings.getLanguage().getName()));
        this.languagesGroup.add(this.bytecode);
        settingsMenu.add(this.bytecode);
        this.bytecodeAST = new JRadioButtonMenuItem(Languages.bytecodeAst().getName());
        this.bytecodeAST.getModel().setActionCommand(Languages.bytecodeAst().getName());
        this.bytecodeAST.setSelected(Languages.bytecodeAst().getName().equals(this.settings.getLanguage().getName()));
        this.languagesGroup.add(this.bytecodeAST);
        settingsMenu.add(this.bytecodeAST);
        JMenu debugLanguagesMenu = new JMenu("Debug Languages");
        for (Language language : Languages.debug()) {
            JRadioButtonMenuItem m = new JRadioButtonMenuItem(language.getName());
            m.getModel().setActionCommand(language.getName());
            m.setSelected(language.getName().equals(this.settings.getLanguage().getName()));
            this.languagesGroup.add(m);
            debugLanguagesMenu.add(m);
            this.languageLookup.put(language.getName(), language);
        }
        for (AbstractButton button : Collections.list(this.languagesGroup.getElements())) {
            button.addActionListener(settingsChanged);
        }
        settingsMenu.add(debugLanguagesMenu);
        this.bytecodeLineNumbers = new JCheckBoxMenuItem("Show Line Numbers In Bytecode");
        this.bytecodeLineNumbers.setSelected(this.settings.getIncludeLineNumbersInBytecode());
        this.bytecodeLineNumbers.addActionListener(settingsChanged);
        settingsMenu.add(this.bytecodeLineNumbers);
    }

    private void buildHelpMenu(JMenu helpMenu) {
        helpMenu.removeAll();
        JMenuItem menuItem = new JMenuItem("Legal");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.mainWindow.onLegalMenu();
            }
        });
        helpMenu.add(menuItem);
        JMenu menuDebug = new JMenu("Debug");
        menuItem = new JMenuItem("List JVM Classes");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenuBar.this.mainWindow.onListLoadedClasses();
            }
        });
        menuDebug.add(menuItem);
        helpMenu.add(menuDebug);
        menuItem = new JMenuItem("About");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JPanel pane = new JPanel();
                pane.setLayout(new BoxLayout(pane, 3));
                JLabel title = new JLabel("Luyten " + Luyten.getVersion());
                title.setFont(new Font("SansSerif", 0, 18));
                pane.add(title);
                pane.add(new JLabel("by Deathmarine"));
                String project = "https://github.com/deathmarine/Luyten/";
                JLabel link = new JLabel("<HTML><FONT color=\"#000099\"><U>" + project + "</U></FONT></HTML>");
                link.setCursor(new Cursor(12));
                link.addMouseListener(new LinkListener(project, link));
                pane.add(link);
                pane.add(new JLabel("Contributions By:"));
                pane.add(new JLabel("zerdei, toonetown, dstmath"));
                pane.add(new JLabel("virustotalop, xtrafrancyz,"));
                pane.add(new JLabel("mbax, quitten, mstrobel,"));
                pane.add(new JLabel("FisheyLP, and Syquel"));
                pane.add(new JLabel(" "));
                pane.add(new JLabel("Powered By:"));
                String procyon = "https://bitbucket.org/mstrobel/procyon";
                link = new JLabel("<HTML><FONT color=\"#000099\"><U>" + procyon + "</U></FONT></HTML>");
                link.setCursor(new Cursor(12));
                link.addMouseListener(new LinkListener(procyon, link));
                pane.add(link);
                pane.add(new JLabel("Version: " + Procyon.version()));
                pane.add(new JLabel("(c) 2018 Mike Strobel"));
                String rsyntax = "https://github.com/bobbylight/RSyntaxTextArea";
                link = new JLabel("<HTML><FONT color=\"#000099\"><U>" + rsyntax + "</U></FONT></HTML>");
                link.setCursor(new Cursor(12));
                link.addMouseListener(new LinkListener(rsyntax, link));
                pane.add(link);
                pane.add(new JLabel("Version: 3.0.2"));
                pane.add(new JLabel("(c) 2019 Robert Futrell"));
                pane.add(new JLabel(" "));
                JOptionPane.showMessageDialog(null, pane);
            }
        });
        helpMenu.add(menuItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSettingsFromSettingsMenu() {
        DecompilerSettings decompilerSettings = this.settings;
        synchronized (decompilerSettings) {
            Language language;
            this.settings.setFlattenSwitchBlocks(this.flattenSwitchBlocks.isSelected());
            this.settings.setForceExplicitImports(this.forceExplicitImports.isSelected());
            this.settings.setShowSyntheticMembers(this.showSyntheticMembers.isSelected());
            this.settings.setExcludeNestedTypes(this.excludeNestedTypes.isSelected());
            this.settings.setForceExplicitTypeArguments(this.forceExplicitTypes.isSelected());
            this.settings.setRetainRedundantCasts(this.retainRedundantCasts.isSelected());
            this.settings.setIncludeErrorDiagnostics(this.showDebugInfo.isSelected());
            this.settings.setUnicodeOutputEnabled(this.unicodeReplacement.isSelected());
            this.settings.setShowDebugLineNumbers(this.debugLineNumbers.isSelected());
            ButtonModel selectedLanguage = this.languagesGroup.getSelection();
            if (selectedLanguage != null && (language = this.languageLookup.get(selectedLanguage.getActionCommand())) != null) {
                this.settings.setLanguage(language);
            }
            if (this.java.isSelected()) {
                this.settings.setLanguage(Languages.java());
            } else if (this.bytecode.isSelected()) {
                this.settings.setLanguage(Languages.bytecode());
            } else if (this.bytecodeAST.isSelected()) {
                this.settings.setLanguage(Languages.bytecodeAst());
            }
            this.settings.setIncludeLineNumbersInBytecode(this.bytecodeLineNumbers.isSelected());
        }
    }

    private class LinkListener
    extends MouseAdapter {
        String link;
        JLabel label;

        public LinkListener(String link, JLabel label) {
            this.link = link;
            this.label = label;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                Desktop.getDesktop().browse(new URI(this.link));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.label.setText("<HTML><FONT color=\"#00aa99\"><U>" + this.link + "</U></FONT></HTML>");
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.label.setText("<HTML><FONT color=\"#000099\"><U>" + this.link + "</U></FONT></HTML>");
        }
    }

    private class ThemeAction
    extends AbstractAction {
        private static final long serialVersionUID = -6618680171943723199L;
        private String xml;

        public ThemeAction(String name, String xml) {
            this.putValue("Name", name);
            this.xml = xml;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainMenuBar.this.luytenPrefs.setThemeXml(this.xml);
            MainMenuBar.this.mainWindow.onThemesChanged();
        }
    }
}

