/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import com.strobel.assembler.metadata.JarTypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.JarEntryFilter;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;
import us.deathmarine.luyten.LuytenTypeLoader;

public class FileSaver {
    private JProgressBar bar;
    private JLabel label;
    private boolean cancel;
    private boolean extracting;

    public FileSaver(JProgressBar bar, JLabel label) {
        this.bar = bar;
        this.label = label;
        final JPopupMenu menu = new JPopupMenu("Cancel");
        JMenuItem item = new JMenuItem("Cancel");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileSaver.this.setCancel(true);
            }
        });
        menu.add(item);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                if (SwingUtilities.isRightMouseButton(ev) && FileSaver.this.isExtracting()) {
                    menu.show(ev.getComponent(), ev.getX(), ev.getY());
                }
            }
        });
    }

    public void saveText(final String text, final File file) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DecompilerSettings settings = FileSaver.this.cloneSettings();
                boolean isUnicodeEnabled = settings.isUnicodeOutputEnabled();
                long time = System.currentTimeMillis();
                try (FileOutputStream fos = new FileOutputStream(file);
                     OutputStreamWriter writer = isUnicodeEnabled ? new OutputStreamWriter((OutputStream)fos, "UTF-8") : new OutputStreamWriter(fos);
                     BufferedWriter bw = new BufferedWriter(writer);){
                    FileSaver.this.label.setText("Extracting: " + file.getName());
                    FileSaver.this.bar.setVisible(true);
                    bw.write(text);
                    bw.flush();
                    FileSaver.this.label.setText("Completed: " + FileSaver.getTime(time));
                }
                catch (Exception e1) {
                    FileSaver.this.label.setText("Cannot save file: " + file.getName());
                    Luyten.showExceptionDialog("Unable to save file!\n", e1);
                }
                finally {
                    FileSaver.this.setExtracting(false);
                    FileSaver.this.bar.setVisible(false);
                }
            }
        }).start();
    }

    public void saveAllDecompiled(final File inFile, final File outFile) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long time = System.currentTimeMillis();
                try {
                    FileSaver.this.bar.setVisible(true);
                    FileSaver.this.setExtracting(true);
                    FileSaver.this.label.setText("Extracting: " + outFile.getName());
                    System.out.println("[SaveAll]: " + inFile.getName() + " -> " + outFile.getName());
                    String inFileName = inFile.getName().toLowerCase();
                    if (inFileName.endsWith(".jar") || inFileName.endsWith(".zip")) {
                        FileSaver.this.doSaveJarDecompiled(inFile, outFile);
                    } else if (inFileName.endsWith(".class")) {
                        FileSaver.this.doSaveClassDecompiled(inFile, outFile);
                    } else {
                        FileSaver.this.doSaveUnknownFile(inFile, outFile);
                    }
                    if (FileSaver.this.cancel) {
                        FileSaver.this.label.setText("Cancelled");
                        outFile.delete();
                        FileSaver.this.setCancel(false);
                    } else {
                        FileSaver.this.label.setText("Completed: " + FileSaver.getTime(time));
                    }
                }
                catch (Exception e1) {
                    FileSaver.this.label.setText("Cannot save file: " + outFile.getName());
                    Luyten.showExceptionDialog("Unable to save file!\n", e1);
                }
                finally {
                    FileSaver.this.setExtracting(false);
                    FileSaver.this.bar.setVisible(false);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSaveJarDecompiled(File inFile, File outFile) throws Exception {
        try (JarFile jfile = new JarFile(inFile);
             FileOutputStream dest = new FileOutputStream(outFile);
             BufferedOutputStream buffDest = new BufferedOutputStream(dest);
             ZipOutputStream out = new ZipOutputStream(buffDest);){
            this.bar.setMinimum(0);
            this.bar.setMaximum(jfile.size());
            byte[] data = new byte[1024];
            DecompilerSettings settings = this.cloneSettings();
            LuytenTypeLoader typeLoader = new LuytenTypeLoader();
            MetadataSystem metadataSystem = new MetadataSystem(typeLoader);
            JarTypeLoader jarLoader = new JarTypeLoader(jfile);
            typeLoader.getTypeLoaders().add(jarLoader);
            DecompilationOptions decompilationOptions = new DecompilationOptions();
            decompilationOptions.setSettings(settings);
            decompilationOptions.setFullDecompilation(true);
            List<String> mass = null;
            JarEntryFilter jarEntryFilter = new JarEntryFilter(jfile);
            LuytenPreferences luytenPrefs = ConfigSaver.getLoadedInstance().getLuytenPreferences();
            mass = luytenPrefs.isFilterOutInnerClassEntries() ? jarEntryFilter.getEntriesWithoutInnerClasses() : jarEntryFilter.getAllEntriesFromJar();
            Enumeration<JarEntry> ent = jfile.entries();
            HashSet<String> history = new HashSet<String>();
            int tick = 0;
            while (ent.hasMoreElements() && !this.cancel) {
                JarEntry etn;
                this.bar.setValue(++tick);
                JarEntry entry = ent.nextElement();
                if (!mass.contains(entry.getName())) continue;
                this.label.setText("Extracting: " + entry.getName());
                this.bar.setVisible(true);
                if (entry.getName().endsWith(".class")) {
                    etn = new JarEntry(entry.getName().replace(".class", ".java"));
                    this.label.setText("Extracting: " + etn.getName());
                    System.out.println("[SaveAll]: " + etn.getName() + " -> " + outFile.getName());
                    if (!history.add(etn.getName())) continue;
                    out.putNextEntry(etn);
                    try {
                        boolean isUnicodeEnabled = decompilationOptions.getSettings().isUnicodeOutputEnabled();
                        String internalName = StringUtilities.removeRight(entry.getName(), ".class");
                        TypeReference type = metadataSystem.lookupType(internalName);
                        TypeDefinition resolvedType = null;
                        if (type == null || (resolvedType = type.resolve()) == null) {
                            throw new Exception("Unable to resolve type.");
                        }
                        OutputStreamWriter writer = isUnicodeEnabled ? new OutputStreamWriter((OutputStream)out, "UTF-8") : new OutputStreamWriter(out);
                        PlainTextOutput plainTextOutput = new PlainTextOutput(writer);
                        plainTextOutput.setUnicodeOutputEnabled(isUnicodeEnabled);
                        settings.getLanguage().decompileType(resolvedType, plainTextOutput, decompilationOptions);
                        ((Writer)writer).flush();
                        continue;
                    }
                    catch (Exception e) {
                        this.label.setText("Cannot decompile file: " + entry.getName());
                        Luyten.showExceptionDialog("Unable to Decompile file!\nSkipping file...", e);
                        continue;
                    }
                    finally {
                        out.closeEntry();
                        continue;
                    }
                }
                try {
                    etn = new JarEntry(entry.getName());
                    if (entry.getName().endsWith(".java")) {
                        etn = new JarEntry(entry.getName().replace(".java", ".src.java"));
                    }
                    if (!history.add(etn.getName())) continue;
                    out.putNextEntry(etn);
                    try {
                        InputStream in = jfile.getInputStream(etn);
                        if (in == null) continue;
                        try {
                            int count;
                            while ((count = in.read(data, 0, 1024)) != -1) {
                                out.write(data, 0, count);
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        out.closeEntry();
                    }
                }
                catch (ZipException ze) {
                    if (ze.getMessage().contains("duplicate")) continue;
                    throw ze;
                    return;
                }
            }
        }
    }

    private void doSaveClassDecompiled(File inFile, File outFile) throws Exception {
        DecompilerSettings settings = this.cloneSettings();
        LuytenTypeLoader typeLoader = new LuytenTypeLoader();
        MetadataSystem metadataSystem = new MetadataSystem(typeLoader);
        TypeReference type = metadataSystem.lookupType(inFile.getCanonicalPath());
        DecompilationOptions decompilationOptions = new DecompilationOptions();
        decompilationOptions.setSettings(settings);
        decompilationOptions.setFullDecompilation(true);
        boolean isUnicodeEnabled = decompilationOptions.getSettings().isUnicodeOutputEnabled();
        TypeDefinition resolvedType = null;
        if (type == null || (resolvedType = type.resolve()) == null) {
            throw new Exception("Unable to resolve type.");
        }
        StringWriter stringwriter = new StringWriter();
        PlainTextOutput plainTextOutput = new PlainTextOutput(stringwriter);
        plainTextOutput.setUnicodeOutputEnabled(isUnicodeEnabled);
        settings.getLanguage().decompileType(resolvedType, plainTextOutput, decompilationOptions);
        String decompiledSource = stringwriter.toString();
        System.out.println("[SaveAll]: " + inFile.getName() + " -> " + outFile.getName());
        try (FileOutputStream fos = new FileOutputStream(outFile);
             OutputStreamWriter writer = isUnicodeEnabled ? new OutputStreamWriter((OutputStream)fos, "UTF-8") : new OutputStreamWriter(fos);
             BufferedWriter bw = new BufferedWriter(writer);){
            bw.write(decompiledSource);
            bw.flush();
        }
    }

    private void doSaveUnknownFile(File inFile, File outFile) throws Exception {
        try (FileInputStream in = new FileInputStream(inFile);
             FileOutputStream out = new FileOutputStream(outFile);){
            int count;
            System.out.println("[SaveAll]: " + inFile.getName() + " -> " + outFile.getName());
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecompilerSettings cloneSettings() {
        DecompilerSettings settings = ConfigSaver.getLoadedInstance().getDecompilerSettings();
        DecompilerSettings newSettings = new DecompilerSettings();
        if (newSettings.getJavaFormattingOptions() == null) {
            newSettings.setJavaFormattingOptions(JavaFormattingOptions.createDefault());
        }
        DecompilerSettings decompilerSettings = settings;
        synchronized (decompilerSettings) {
            newSettings.setExcludeNestedTypes(settings.getExcludeNestedTypes());
            newSettings.setFlattenSwitchBlocks(settings.getFlattenSwitchBlocks());
            newSettings.setForceExplicitImports(settings.getForceExplicitImports());
            newSettings.setForceExplicitTypeArguments(settings.getForceExplicitTypeArguments());
            newSettings.setOutputFileHeaderText(settings.getOutputFileHeaderText());
            newSettings.setLanguage(settings.getLanguage());
            newSettings.setShowSyntheticMembers(settings.getShowSyntheticMembers());
            newSettings.setAlwaysGenerateExceptionVariableForCatchBlocks(settings.getAlwaysGenerateExceptionVariableForCatchBlocks());
            newSettings.setOutputDirectory(settings.getOutputDirectory());
            newSettings.setRetainRedundantCasts(settings.getRetainRedundantCasts());
            newSettings.setIncludeErrorDiagnostics(settings.getIncludeErrorDiagnostics());
            newSettings.setIncludeLineNumbersInBytecode(settings.getIncludeLineNumbersInBytecode());
            newSettings.setRetainPointlessSwitches(settings.getRetainPointlessSwitches());
            newSettings.setUnicodeOutputEnabled(settings.isUnicodeOutputEnabled());
            newSettings.setMergeVariables(settings.getMergeVariables());
            newSettings.setShowDebugLineNumbers(settings.getShowDebugLineNumbers());
        }
        return newSettings;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public boolean isExtracting() {
        return this.extracting;
    }

    public void setExtracting(boolean extracting) {
        this.extracting = extracting;
    }

    public static String getTime(long time) {
        long lap = System.currentTimeMillis() - time;
        StringBuilder sb = new StringBuilder();
        long hour = (lap /= 1000L) / 60L / 60L;
        long min = (lap - hour * 60L * 60L) / 60L;
        long sec = lap - hour * 60L * 60L - min * 60L;
        if (hour > 0L) {
            sb.append("Hour:").append(hour).append(" ");
        }
        sb.append("Min(s): ").append(min).append(" Sec: ").append(sec);
        return sb.toString();
    }
}

