/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import java.util.Arrays;

public final class CodeStream {
    private static final int DEFAULT_SIZE = 64;
    private byte[] _data;
    private int _length;

    public CodeStream() {
        this._data = new byte[64];
    }

    public CodeStream(int initialSize) {
        this._data = new byte[initialSize];
    }

    public void reset() {
        this.reset(64);
    }

    public void reset(int initialSize) {
        this._data = new byte[64];
        this._length = 0;
    }

    public byte[] getData() {
        return this._data;
    }

    public int getLength() {
        return this._length;
    }

    public CodeStream putByte(int b) {
        this.ensureCapacity(1);
        this._data[this._length++] = (byte)(b & 0xFF);
        return this;
    }

    CodeStream put11(int b1, int b2) {
        this.ensureCapacity(2);
        this._data[this._length++] = (byte)(b1 & 0xFF);
        this._data[this._length++] = (byte)(b2 & 0xFF);
        return this;
    }

    public CodeStream putShort(int s) {
        this.ensureCapacity(2);
        this._data[this._length++] = (byte)(s >>> 8 & 0xFF);
        this._data[this._length++] = (byte)(s & 0xFF);
        return this;
    }

    CodeStream put12(int b, int s) {
        this.ensureCapacity(3);
        this._data[this._length++] = (byte)(b & 0xFF);
        this._data[this._length++] = (byte)(s >>> 8 & 0xFF);
        this._data[this._length++] = (byte)(s & 0xFF);
        return this;
    }

    public CodeStream putInt(int i) {
        this.ensureCapacity(4);
        this._data[this._length++] = (byte)(i >>> 24 & 0xFF);
        this._data[this._length++] = (byte)(i >>> 16 & 0xFF);
        this._data[this._length++] = (byte)(i >>> 8 & 0xFF);
        this._data[this._length++] = (byte)(i & 0xFF);
        return this;
    }

    public CodeStream putLong(long l) {
        this.ensureCapacity(8);
        int i = (int)(l >>> 32);
        this._data[this._length++] = (byte)(i >>> 24 & 0xFF);
        this._data[this._length++] = (byte)(i >>> 16 & 0xFF);
        this._data[this._length++] = (byte)(i >>> 8 & 0xFF);
        this._data[this._length++] = (byte)(i & 0xFF);
        i = (int)l;
        this._data[this._length++] = (byte)(i >>> 24 & 0xFF);
        this._data[this._length++] = (byte)(i >>> 16 & 0xFF);
        this._data[this._length++] = (byte)(i >>> 8 & 0xFF);
        this._data[this._length++] = (byte)(i & 0xFF);
        return this;
    }

    public CodeStream putFloat(float f) {
        return this.putInt(Float.floatToRawIntBits(f));
    }

    public CodeStream putDouble(double d) {
        return this.putLong(Double.doubleToRawLongBits(d));
    }

    public CodeStream putUtf8(String s) {
        int charLength = s.length();
        this.ensureCapacity(2 + charLength);
        int originalLength = this._length;
        this._data[this._length++] = (byte)(charLength >>> 8);
        this._data[this._length++] = (byte)charLength;
        for (int i = 0; i < charLength; ++i) {
            int j;
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this._data[this._length++] = (byte)c;
                continue;
            }
            int byteLength = i;
            for (j = i; j < charLength; ++j) {
                c = s.charAt(j);
                if (c >= '\u0001' && c <= '\u007f') {
                    ++byteLength;
                    continue;
                }
                if (c > '\u07ff') {
                    byteLength += 3;
                    continue;
                }
                byteLength += 2;
            }
            this._data[originalLength] = (byte)(byteLength >>> 8);
            this._data[originalLength + 1] = (byte)byteLength;
            this.ensureCapacity(2 + byteLength);
            for (j = i; j < charLength; ++j) {
                c = s.charAt(j);
                if (c >= '\u0001' && c <= '\u007f') {
                    this._data[this._length++] = (byte)c;
                    continue;
                }
                if (c > '\u07ff') {
                    this._data[this._length++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this._data[this._length++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this._data[this._length++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                this._data[this._length++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this._data[this._length++] = (byte)(0x80 | c & 0x3F);
            }
            break;
        }
        return this;
    }

    public CodeStream putByteArray(byte[] b, int offset, int length) {
        this.ensureCapacity(length);
        if (b != null) {
            System.arraycopy(b, offset, this._data, this._length, length);
        }
        this._length += length;
        return this;
    }

    void ensureCapacity(int size) {
        if (this._length + size <= this._data.length) {
            return;
        }
        int length1 = 2 * this._data.length;
        int length2 = this._length + size;
        this._data = Arrays.copyOf(this._data, length1 > length2 ? length1 : length2);
    }
}

