/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import java.util.EnumSet;
import java.util.Set;

public enum MemberType {
    Constructor(1),
    Field(2),
    Method(4),
    TypeInfo(8),
    Custom(16),
    NestedType(32),
    All(MemberType.NestedType.mask | MemberType.TypeInfo.mask | MemberType.Method.mask | MemberType.Field.mask | MemberType.Constructor.mask);

    final int mask;
    private static final Set<MemberType> constructors;
    private static final Set<MemberType> fields;
    private static final Set<MemberType> methods;
    private static final Set<MemberType> types;
    private static final Set<MemberType> custom;
    private static final Set<MemberType> nestedTypes;

    public static Set<MemberType> constructorsOnly() {
        return constructors;
    }

    public static Set<MemberType> fieldsOnly() {
        return fields;
    }

    public static Set<MemberType> methodsOnly() {
        return methods;
    }

    public static Set<MemberType> typesOnly() {
        return types;
    }

    public static Set<MemberType> customOnly() {
        return custom;
    }

    public static Set<MemberType> nestedTypesOnly() {
        return nestedTypes;
    }

    public static Set<MemberType> of(MemberType m1) {
        return EnumSet.of(m1);
    }

    public static Set<MemberType> of(MemberType m1, MemberType m2) {
        return EnumSet.of(m1, m2);
    }

    public static Set<MemberType> of(MemberType m1, MemberType m2, MemberType m3) {
        return EnumSet.of(m1, m2, m3);
    }

    public static Set<MemberType> of(MemberType m1, MemberType m2, MemberType m3, MemberType m4) {
        return EnumSet.of(m1, m2, m3, m4);
    }

    public static Set<MemberType> of(MemberType m1, MemberType m2, MemberType m3, MemberType m4, MemberType m5) {
        return EnumSet.of(m1, m2, m3, m4, m5);
    }

    public static Set<MemberType> of(MemberType m1, MemberType ... others) {
        return EnumSet.of(m1, others);
    }

    private MemberType(int mask) {
        this.mask = mask;
    }

    static int mask(Set<MemberType> memberTypes) {
        int mask = 0;
        if (memberTypes.contains((Object)Constructor)) {
            mask |= MemberType.Constructor.mask;
        }
        if (memberTypes.contains((Object)Field)) {
            mask |= MemberType.Field.mask;
        }
        if (memberTypes.contains((Object)Method)) {
            mask |= MemberType.Method.mask;
        }
        if (memberTypes.contains((Object)TypeInfo)) {
            mask |= MemberType.TypeInfo.mask;
        }
        if (memberTypes.contains((Object)Custom)) {
            mask |= MemberType.Custom.mask;
        }
        if (memberTypes.contains((Object)NestedType)) {
            mask |= MemberType.NestedType.mask;
        }
        return mask;
    }

    static {
        constructors = MemberType.of(Constructor);
        fields = MemberType.of(Field);
        methods = MemberType.of(Method);
        types = MemberType.of(TypeInfo);
        custom = MemberType.of(Custom);
        nestedTypes = MemberType.of(NestedType);
    }
}

