/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.ReadOnlyList;
import com.strobel.expressions.CatchBlock;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.reflection.Type;

public final class TryExpression
extends Expression {
    private final Type _type;
    private final Expression _body;
    private final ReadOnlyList<CatchBlock> _handlers;
    private final Expression _finallyBlock;

    TryExpression(Type type, Expression body, ReadOnlyList<CatchBlock> handlers, Expression finallyBlock) {
        this._type = type;
        this._body = body;
        this._handlers = handlers;
        this._finallyBlock = finallyBlock;
    }

    public final Expression getBody() {
        return this._body;
    }

    public final ReadOnlyList<CatchBlock> getHandlers() {
        return this._handlers;
    }

    public final Expression getFinallyBlock() {
        return this._finallyBlock;
    }

    @Override
    public final ExpressionType getNodeType() {
        return ExpressionType.Try;
    }

    @Override
    public final Type<?> getType() {
        return this._type;
    }

    @Override
    protected final Expression accept(ExpressionVisitor visitor) {
        return visitor.visitTry(this);
    }

    public final TryExpression update(Expression body, ReadOnlyList<CatchBlock> handlers, Expression finallyBlock) {
        if (body == this._body && handlers == this._handlers && finallyBlock == this._finallyBlock) {
            return this;
        }
        return TryExpression.makeTry(this.getType(), body, handlers, finallyBlock);
    }
}

