/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.LabelTarget;
import com.strobel.expressions.ParameterExpression;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;

public final class ForExpression
extends Expression {
    private final ParameterExpression _variable;
    private final Expression _initializer;
    private final Expression _test;
    private final Expression _step;
    private final Expression _body;
    private final LabelTarget _breakTarget;
    private final LabelTarget _continueTarget;

    ForExpression(ParameterExpression variable, Expression initializer, Expression test, Expression step, Expression body, LabelTarget breakTarget, LabelTarget continueTarget) {
        this._variable = variable;
        this._initializer = initializer;
        this._test = test;
        this._step = step;
        this._body = body;
        this._breakTarget = breakTarget;
        this._continueTarget = continueTarget;
    }

    public ParameterExpression getVariable() {
        return this._variable;
    }

    public Expression getInitializer() {
        return this._initializer;
    }

    public Expression getTest() {
        return this._test;
    }

    public Expression getStep() {
        return this._step;
    }

    public Expression getBody() {
        return this._body;
    }

    public LabelTarget getBreakTarget() {
        return this._breakTarget;
    }

    public LabelTarget getContinueTarget() {
        return this._continueTarget;
    }

    @Override
    public ExpressionType getNodeType() {
        return ExpressionType.Extension;
    }

    @Override
    public Type<?> getType() {
        if (this._breakTarget != null) {
            return this._breakTarget.getType();
        }
        return PrimitiveTypes.Void;
    }

    @Override
    public boolean canReduce() {
        return true;
    }

    public ForExpression update(ParameterExpression variable, Expression initializer, Expression test, Expression step, Expression body, LabelTarget breakTarget, LabelTarget continueTarget) {
        if (variable == this._variable && initializer == this._initializer && body == this._body && test == this._test && step == this._step && breakTarget == this._breakTarget && continueTarget == this._continueTarget) {
            return this;
        }
        return ForExpression.makeFor(variable, initializer, test, step, body, breakTarget, continueTarget);
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitFor(this);
    }

    @Override
    protected Expression visitChildren(ExpressionVisitor visitor) {
        return this.update((ParameterExpression)visitor.visit(this._variable), visitor.visit(this._initializer), visitor.visit(this._test), visitor.visit(this._step), visitor.visit(this._body), visitor.visitLabelTarget(this._breakTarget), visitor.visitLabelTarget(this._continueTarget));
    }

    @Override
    public Expression reduce() {
        LabelTarget breakTarget = this._breakTarget != null ? this._breakTarget : ForExpression.label();
        LabelTarget continueTarget = this._continueTarget != null ? this._continueTarget : ForExpression.label();
        return ForExpression.block(new ParameterExpressionList(this._variable), ForExpression.assign(this._variable, this._initializer), ForExpression.loop(ForExpression.block((Expression)ForExpression.ifThen(ForExpression.not(this._test), ForExpression.makeBreak(breakTarget)), this._body, (Expression)ForExpression.label(continueTarget), this._step)), ForExpression.label(breakTarget));
    }
}

