/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.expressions.AnalyzeTypeIsResult;
import com.strobel.expressions.ConstantExpression;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.TypeBinaryExpression;
import com.strobel.expressions.UnaryExpression;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.Types;
import com.strobel.util.TypeUtils;

final class ConstantCheck {
    ConstantCheck() {
    }

    static boolean isNull(Expression e) {
        switch (e.getNodeType()) {
            case Constant: {
                return ((ConstantExpression)e).getValue() == null;
            }
            case Convert: {
                return ConstantCheck.isNull(((UnaryExpression)e).getOperand());
            }
            case DefaultValue: {
                return !e.getType().isPrimitive();
            }
        }
        return false;
    }

    static boolean isStringLiteral(Expression e) {
        return TypeUtils.getUnderlyingPrimitiveOrSelf(e.getType()) == Types.String && e.getNodeType() == ExpressionType.Constant;
    }

    static boolean isTrue(Expression e) {
        return TypeUtils.getUnderlyingPrimitiveOrSelf(e.getType()) == PrimitiveTypes.Boolean && e.getNodeType() == ExpressionType.Constant && Boolean.TRUE.equals(((ConstantExpression)e).getValue());
    }

    static boolean isFalse(Expression e) {
        return TypeUtils.getUnderlyingPrimitiveOrSelf(e.getType()) == PrimitiveTypes.Boolean && e.getNodeType() == ExpressionType.Constant && Boolean.FALSE.equals(((ConstantExpression)e).getValue());
    }

    static AnalyzeTypeIsResult analyzeInstanceOf(TypeBinaryExpression typeIs) {
        return ConstantCheck.analyzeInstanceOf(typeIs.getOperand(), typeIs.getTypeOperand());
    }

    private static AnalyzeTypeIsResult analyzeInstanceOf(Expression operand, Type<?> testType) {
        Type<?> operandType = operand.getType();
        if (operandType == PrimitiveTypes.Void) {
            return AnalyzeTypeIsResult.KnownFalse;
        }
        if (operandType.isPrimitive()) {
            if (testType == TypeUtils.getBoxedType(operandType)) {
                return AnalyzeTypeIsResult.KnownTrue;
            }
            return AnalyzeTypeIsResult.KnownFalse;
        }
        if (testType.isPrimitive()) {
            if (operandType == TypeUtils.getUnderlyingPrimitive(testType)) {
                return AnalyzeTypeIsResult.KnownAssignable;
            }
            return AnalyzeTypeIsResult.KnownFalse;
        }
        if (testType.isAssignableFrom(operandType)) {
            return AnalyzeTypeIsResult.KnownAssignable;
        }
        return AnalyzeTypeIsResult.Unknown;
    }
}

