/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.IResolverFrame;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringComparator;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import java.util.List;
import java.util.Stack;

public abstract class MetadataResolver
implements IMetadataResolver,
IGenericContext {
    private final Stack<IResolverFrame> _frames = new Stack();

    protected MetadataResolver() {
    }

    @Override
    public final TypeReference lookupType(String descriptor) {
        for (int i = this._frames.size() - 1; i >= 0; --i) {
            TypeReference type = ((IResolverFrame)this._frames.get(i)).findType(descriptor);
            if (type == null) continue;
            return type;
        }
        return this.lookupTypeCore(descriptor);
    }

    @Override
    public final GenericParameter findTypeVariable(String name) {
        for (int i = this._frames.size() - 1; i >= 0; --i) {
            GenericParameter type = ((IResolverFrame)this._frames.get(i)).findTypeVariable(name);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    protected abstract TypeReference lookupTypeCore(String var1);

    @Override
    public void pushFrame(IResolverFrame frame) {
        this._frames.push(VerifyArgument.notNull(frame, "frame"));
    }

    @Override
    public void popFrame() {
        this._frames.pop();
    }

    @Override
    public TypeDefinition resolve(TypeReference type) {
        TypeReference t = VerifyArgument.notNull(type, "type").getUnderlyingType();
        if (!this._frames.isEmpty()) {
            String descriptor = type.getInternalName();
            for (int i = this._frames.size() - 1; i >= 0; --i) {
                TypeReference resolved = ((IResolverFrame)this._frames.get(i)).findType(descriptor);
                if (!(resolved instanceof TypeDefinition)) continue;
                return (TypeDefinition)resolved;
            }
        }
        if (t.isNested()) {
            TypeDefinition declaringType = t.getDeclaringType().resolve();
            if (declaringType == null) {
                return null;
            }
            TypeDefinition nestedType = MetadataResolver.getNestedType(declaringType.getDeclaredTypes(), type);
            if (nestedType != null) {
                return nestedType;
            }
        }
        return this.resolveCore(t);
    }

    protected abstract TypeDefinition resolveCore(TypeReference var1);

    @Override
    public FieldDefinition resolve(FieldReference field) {
        TypeDefinition declaringType = VerifyArgument.notNull(field, "field").getDeclaringType().resolve();
        if (declaringType == null) {
            return null;
        }
        return this.getField(declaringType, field);
    }

    @Override
    public MethodDefinition resolve(MethodReference method) {
        TypeDefinition resolvedDeclaringType;
        TypeReference declaringType = VerifyArgument.notNull(method, "method").getDeclaringType();
        if (declaringType.isArray()) {
            declaringType = BuiltinTypes.Object;
        }
        if ((resolvedDeclaringType = declaringType.resolve()) == null) {
            return null;
        }
        return this.getMethod(resolvedDeclaringType, method);
    }

    final FieldDefinition getField(TypeDefinition declaringType, FieldReference reference) {
        TypeDefinition type = declaringType;
        while (type != null) {
            FieldDefinition field = MetadataResolver.getField(type.getDeclaredFields(), reference);
            if (field != null) {
                return field;
            }
            TypeReference baseType = type.getBaseType();
            if (baseType == null) {
                return null;
            }
            type = this.resolve(baseType);
        }
        return null;
    }

    final MethodDefinition getMethod(TypeDefinition declaringType, MethodReference reference) {
        TypeDefinition type = declaringType;
        MethodDefinition method = MetadataResolver.getMethod(type.getDeclaredMethods(), reference);
        if (method != null) {
            return method;
        }
        TypeReference baseType = declaringType.getBaseType();
        if (baseType != null && (type = baseType.resolve()) != null && (method = this.getMethod(type, reference)) != null) {
            return method;
        }
        for (TypeReference interfaceType : declaringType.getExplicitInterfaces()) {
            type = interfaceType.resolve();
            if (type == null || (method = this.getMethod(type, reference)) == null) continue;
            return method;
        }
        return null;
    }

    static TypeDefinition getNestedType(List<TypeDefinition> candidates, TypeReference reference) {
        int n = candidates.size();
        for (int i = 0; i < n; ++i) {
            TypeDefinition candidate = candidates.get(i);
            if (!StringComparator.Ordinal.equals(candidate.getName(), reference.getName())) continue;
            return candidate;
        }
        return null;
    }

    static FieldDefinition getField(List<FieldDefinition> candidates, FieldReference reference) {
        int n = candidates.size();
        for (int i = 0; i < n; ++i) {
            FieldDefinition candidate = candidates.get(i);
            if (!StringComparator.Ordinal.equals(candidate.getName(), reference.getName())) continue;
            TypeReference referenceType = reference.getFieldType();
            TypeReference candidateType = candidate.getFieldType();
            if (MetadataResolver.areEquivalent(candidateType, referenceType)) {
                return candidate;
            }
            TypeReference rawCandidateType = MetadataHelper.eraseRecursive(candidateType);
            TypeReference rawReferenceType = MetadataHelper.eraseRecursive(referenceType);
            if (rawCandidateType == candidateType && rawReferenceType == referenceType || !MetadataResolver.areEquivalent(rawCandidateType, rawReferenceType)) continue;
            return candidate;
        }
        return null;
    }

    static MethodDefinition getMethod(List<MethodDefinition> candidates, MethodReference reference) {
        String erasedSignature = reference.getErasedSignature();
        int n = candidates.size();
        for (int i = 0; i < n; ++i) {
            MethodDefinition candidate = candidates.get(i);
            if (!StringComparator.Ordinal.equals(candidate.getName(), reference.getName())) continue;
            if (StringComparator.Ordinal.equals(candidate.getErasedSignature(), erasedSignature)) {
                return candidate;
            }
            if (reference.hasGenericParameters() && (!candidate.hasGenericParameters() || candidate.getGenericParameters().size() != reference.getGenericParameters().size()) || !StringComparator.Ordinal.equals(candidate.getErasedSignature(), erasedSignature)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean areEquivalent(TypeReference a, TypeReference b) {
        return MetadataResolver.areEquivalent(a, b, true);
    }

    public static boolean areEquivalent(TypeReference a, TypeReference b, boolean strict) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getSimpleType() != b.getSimpleType()) {
            return false;
        }
        if (a.isArray()) {
            return MetadataResolver.areEquivalent(a.getElementType(), b.getElementType());
        }
        if (!StringUtilities.equals(a.getInternalName(), b.getInternalName())) {
            return false;
        }
        if (a instanceof CompoundTypeReference) {
            if (!(b instanceof CompoundTypeReference)) {
                return false;
            }
            CompoundTypeReference cA = (CompoundTypeReference)a;
            CompoundTypeReference cB = (CompoundTypeReference)b;
            return MetadataResolver.areEquivalent(cA.getBaseType(), cB.getBaseType()) && MetadataResolver.areEquivalent(cA.getInterfaces(), cB.getInterfaces());
        }
        if (b instanceof CompoundTypeReference) {
            return false;
        }
        if (a.isGenericParameter()) {
            if (b.isGenericParameter()) {
                return MetadataResolver.areEquivalent((GenericParameter)a, (GenericParameter)b);
            }
            return MetadataResolver.areEquivalent(a.getExtendsBound(), b);
        }
        if (b.isGenericParameter()) {
            return false;
        }
        if (a.isWildcardType()) {
            return b.isWildcardType() && MetadataResolver.areEquivalent(a.getExtendsBound(), b.getExtendsBound()) && MetadataResolver.areEquivalent(a.getSuperBound(), b.getSuperBound());
        }
        if (b.isWildcardType()) {
            return false;
        }
        if (b.isGenericType()) {
            if (!a.isGenericType()) {
                return !strict || b.isGenericDefinition();
            }
            if (a.isGenericDefinition() != b.isGenericDefinition()) {
                if (a.isGenericDefinition()) {
                    return MetadataResolver.areEquivalent(a.makeGenericType(((IGenericInstance)((Object)b)).getTypeArguments()), b);
                }
                return MetadataResolver.areEquivalent(a, b.makeGenericType(((IGenericInstance)((Object)a)).getTypeArguments()));
            }
            if (b instanceof IGenericInstance) {
                return a instanceof IGenericInstance && MetadataResolver.areEquivalent((IGenericInstance)((Object)a), (IGenericInstance)((Object)b));
            }
        }
        return true;
    }

    static boolean areParametersEquivalent(List<ParameterDefinition> a, List<ParameterDefinition> b) {
        int count = a.size();
        if (b.size() != count) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            ParameterDefinition pb = b.get(i);
            ParameterDefinition pa = a.get(i);
            TypeReference tb = pb.getParameterType();
            TypeReference ta = pa.getParameterType();
            if (ta.isGenericParameter() && !tb.isGenericParameter() && ((GenericParameter)ta).getOwner() == pa.getMethod()) {
                ta = ta.getExtendsBound();
            }
            if (MetadataResolver.areEquivalent(ta, tb)) continue;
            return false;
        }
        return true;
    }

    static <T extends TypeReference> boolean areEquivalent(List<T> a, List<T> b) {
        int count = a.size();
        if (b.size() != count) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            if (MetadataResolver.areEquivalent((TypeReference)a.get(i), (TypeReference)b.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areEquivalent(IGenericInstance a, IGenericInstance b) {
        List<TypeReference> typeArgumentsA = a.getTypeArguments();
        List<TypeReference> typeArgumentsB = b.getTypeArguments();
        int arity = typeArgumentsA.size();
        if (arity != typeArgumentsB.size()) {
            return false;
        }
        for (int i = 0; i < arity; ++i) {
            if (MetadataResolver.areEquivalent(typeArgumentsA.get(i), typeArgumentsB.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areEquivalent(GenericParameter a, GenericParameter b) {
        if (a.getPosition() != b.getPosition()) {
            return false;
        }
        IGenericParameterProvider ownerA = a.getOwner();
        IGenericParameterProvider ownerB = b.getOwner();
        if (ownerA instanceof TypeDefinition) {
            return ownerB instanceof TypeDefinition && MetadataResolver.areEquivalent((TypeDefinition)ownerA, (TypeDefinition)ownerB);
        }
        if (ownerA instanceof MethodDefinition) {
            if (!(ownerB instanceof MethodDefinition)) {
                return false;
            }
            MethodDefinition methodA = (MethodDefinition)ownerA;
            MethodDefinition methodB = (MethodDefinition)ownerB;
            return MetadataResolver.areEquivalent(methodA.getDeclaringType(), methodB.getDeclaringType()) && StringUtilities.equals(methodA.getErasedSignature(), methodB.getErasedSignature());
        }
        return true;
    }

    public static IMetadataResolver createLimitedResolver() {
        return new LimitedResolver();
    }

    private static final class LimitedResolver
    extends MetadataResolver {
        private LimitedResolver() {
        }

        @Override
        protected TypeReference lookupTypeCore(String descriptor) {
            return null;
        }

        @Override
        protected TypeDefinition resolveCore(TypeReference type) {
            return type instanceof TypeDefinition ? (TypeDefinition)type : null;
        }
    }
}

