/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.SpecialAlgorithm;

public class Oracle11g
implements SpecialAlgorithm {
    private MessageDigest m = null;
    private static final byte S_BYTE = 83;
    private static final byte TWOPOINST_BYTE = 58;

    public Oracle11g() {
        try {
            this.m = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final String crypt(String password, String salt) {
        byte[] salt1 = null;
        if (salt == null) {
            salt1 = new byte[10];
            new Random().nextBytes(salt1);
        } else {
            salt1 = DatatypeConverter.parseHexBinary((String)salt);
        }
        return this.toHash(this.cryptPerf(password.getBytes(), salt1));
    }

    private final String bytes2Utf8(byte[] ba) {
        try {
            return new String(ba, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final String toHash(byte[] b) {
        byte[] aux = new byte[b.length - 2];
        int auxIndex = 0;
        int i = 2;
        while (i < b.length) {
            aux[auxIndex] = b[i];
            ++auxIndex;
            ++i;
        }
        String returnValue1 = this.bytes2Utf8(b).substring(0, 2);
        String returnValue2 = DatatypeConverter.printHexBinary((byte[])aux);
        return String.valueOf(returnValue1) + returnValue2;
    }

    @Override
    public byte[] cryptPerf(byte[] password, byte[] salt) {
        byte[] toUpdate = new byte[password.length + salt.length];
        int i = 0;
        while (i < password.length) {
            toUpdate[i] = password[i];
            ++i;
        }
        int myIndex = password.length;
        int j = 0;
        while (j < salt.length) {
            toUpdate[myIndex] = salt[j];
            ++myIndex;
            ++j;
        }
        this.m.update(toUpdate, 0, toUpdate.length);
        byte[] mResult = this.m.digest();
        byte[] output = new byte[mResult.length + 2 + 10];
        output[0] = 83;
        output[1] = 58;
        int i2 = 0;
        while (i2 < mResult.length) {
            output[i2 + 2] = mResult[i2];
            ++i2;
        }
        int auxIndex = mResult.length + 2;
        int i3 = 0;
        while (i3 < salt.length) {
            output[auxIndex] = salt[i3];
            ++auxIndex;
            ++i3;
        }
        return output;
    }

    @Override
    public final byte[] toByteArray(String hash) {
        byte[] bhash = new byte[32];
        bhash[0] = 83;
        bhash[1] = 58;
        byte[] auxbhash = DatatypeConverter.parseHexBinary((String)hash.substring(2, hash.length()));
        int i = 0;
        while (i < auxbhash.length) {
            bhash[i + 2] = auxbhash[i];
            ++i;
        }
        return bhash;
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        byte[] salt = new byte[10];
        int auxIndex = 0;
        int hashLength = hash.length;
        int i = hashLength - 10;
        while (i < hashLength) {
            salt[auxIndex] = hash[i];
            ++auxIndex;
            ++i;
        }
        return salt;
    }

    @Override
    public byte[] appendSaltToWord(byte[] word, byte[] salt) {
        return ByteArray.concat(word, salt);
    }
}

