/*
 * Decompiled with CFR 0.152.
 */
package entities;

public class ByteArray {
    private static final byte[] SIGNS_UPPER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] SIGNS_LOWER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static final byte[] concat(byte[] source, byte[] append) {
        byte[] result = new byte[source.length + append.length];
        int i = 0;
        while (i < source.length) {
            result[i] = source[i];
            ++i;
        }
        int auxIndex = source.length;
        int i2 = 0;
        while (i2 < append.length) {
            result[auxIndex] = append[i2];
            ++auxIndex;
            ++i2;
        }
        return result;
    }

    public static final byte[] getCopyOf(byte[] source) {
        byte[] result = new byte[source.length];
        int i = 0;
        while (i < source.length) {
            result[i] = source[i];
            ++i;
        }
        return result;
    }

    public static final byte[] getSubArray(byte[] source, int indexFrom, int indexTo) {
        byte[] result = null;
        result = indexTo < indexFrom || indexTo > source.length || indexFrom < 0 ? null : new byte[indexTo - indexFrom + 1];
        int auxIndex = 0;
        int i = indexFrom;
        while (i <= indexTo) {
            result[auxIndex] = source[i];
            ++auxIndex;
            ++i;
        }
        return result;
    }

    public static final byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static final int fromByteArray(byte[] bytes) {
        return bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static final byte[] truncate(byte[] source, int newSize) {
        byte[] result = new byte[newSize];
        int i = 0;
        while (i < newSize) {
            result[i] = source[i];
            ++i;
        }
        return result;
    }

    public static final byte[] toUpperCase(byte[] source) {
        byte[] returnValue = new byte[source.length];
        int i = 0;
        while (i < source.length) {
            returnValue[i] = (byte)Character.toUpperCase(source[i]);
            ++i;
        }
        return returnValue;
    }

    public static final byte[] toLowerCase(byte[] source) {
        byte[] returnValue = new byte[source.length];
        int i = 0;
        while (i < source.length) {
            returnValue[i] = (byte)Character.toLowerCase(source[i]);
            ++i;
        }
        return returnValue;
    }

    public static final byte[] toUpperCase(String source) {
        int strSize = source.length();
        byte[] returnValue = new byte[strSize];
        int i = 0;
        while (i < strSize) {
            returnValue[i] = (byte)Character.toUpperCase(source.charAt(i));
            ++i;
        }
        return returnValue;
    }

    public static final byte[] toLowerCase(String source) {
        int strSize = source.length();
        byte[] returnValue = new byte[strSize];
        int i = 0;
        while (i < strSize) {
            returnValue[i] = (byte)Character.toLowerCase(source.charAt(i));
            ++i;
        }
        return returnValue;
    }

    public static final byte[] toByteArray(StringBuilder sb) {
        int myLength = sb.length();
        byte[] returnValue = new byte[myLength];
        int i = 0;
        while (i < myLength) {
            returnValue[i] = (byte)sb.charAt(i);
            ++i;
        }
        return returnValue;
    }

    public static final byte[] toUTF16LE(byte[] b) {
        int auxLength = b.length * 2;
        byte[] returnValue = new byte[auxLength];
        int auxIndex = 0;
        int i = 0;
        while (i < auxLength) {
            if (i % 2 == 0) {
                returnValue[i] = b[auxIndex];
                ++auxIndex;
            } else {
                returnValue[i] = 0;
            }
            ++i;
        }
        return returnValue;
    }

    public static final byte[] toUTF16BE(byte[] b) {
        int auxLength = b.length * 2;
        byte[] returnValue = new byte[auxLength];
        int auxIndex = 0;
        int i = 0;
        while (i < auxLength) {
            if (i % 2 == 0) {
                returnValue[i] = 0;
            } else {
                returnValue[i] = b[auxIndex];
                ++auxIndex;
            }
            ++i;
        }
        return returnValue;
    }

    public static final byte[] toByteArrayUpper(byte[] source) {
        int myLength = source.length;
        byte[] returnValue = new byte[myLength * 2];
        int auxIndex = 0;
        int aux = 0;
        int left = 0;
        int right = 0;
        int i = 0;
        while (i < myLength) {
            aux = source[i] & 0xFF;
            left = aux >>> 4 & 0x1F;
            right = aux & 0xF & 0xFF;
            returnValue[auxIndex] = SIGNS_UPPER[left];
            returnValue[++auxIndex] = SIGNS_UPPER[right];
            ++auxIndex;
            ++i;
        }
        return returnValue;
    }

    public static final byte[] toByteArrayLower(byte[] source) {
        int myLength = source.length;
        byte[] returnValue = new byte[myLength * 2];
        int auxIndex = 0;
        int aux = 0;
        int left = 0;
        int right = 0;
        int i = 0;
        while (i < myLength) {
            aux = source[i] & 0xFF;
            left = aux >>> 4 & 0x1F;
            right = aux & 0xF & 0xFF;
            returnValue[auxIndex] = SIGNS_LOWER[left];
            returnValue[++auxIndex] = SIGNS_LOWER[right];
            ++auxIndex;
            ++i;
        }
        return returnValue;
    }
}

