/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.choose.clazz;

import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.ui.choose.clazz.ClassComparator;
import com.aspect.snoop.util.ClasspathUtil;
import com.aspect.snoop.util.ReflectionUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ChooseClassView
extends JDialog {
    List<Class> allClasses;
    List<Class> filteredClasses;
    Class selectedClass;
    private String className;
    private JCheckBox chkHideJavaClasses;
    private JCheckBox chkHideJavaSnoopClasses;
    private JCheckBox chkOnlyMains;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JList lstClasses;
    private JTextField txtClass;

    public String getClassName() {
        return this.className;
    }

    public ChooseClassView(JDialog parent, List<Class> classes) {
        super((Dialog)parent, true);
        this.initComponents();
        this.customInit(classes);
    }

    public ChooseClassView(JDialog parent, List<Class> classes, boolean showMainsByDefault) {
        super((Dialog)parent, true);
        this.initComponents();
        this.chkOnlyMains.setSelected(showMainsByDefault);
        this.customInit(classes);
    }

    public ChooseClassView(Frame parent, List<Class> classes, boolean showMainsByDefault) {
        super(parent, true);
        this.initComponents();
        this.chkOnlyMains.setSelected(showMainsByDefault);
        this.customInit(classes);
    }

    public ChooseClassView(Frame parent, List<Class> classes) {
        this(parent, classes, false);
    }

    private void customInit(List<Class> classes) {
        this.setTitle("Choose class - " + classes.size() + " classes loaded");
        ClassComparator c = new ClassComparator();
        Collections.sort(classes, c);
        this.allClasses = classes;
        this.filteredClasses = classes;
        this.lstClasses.setCellRenderer(new ClassListCellRenderer());
        this.lstClasses.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChooseClassView.this.selectedClass = (Class)ChooseClassView.this.lstClasses.getSelectedValue();
                ChooseClassView.this.txtClass.setText(ChooseClassView.this.selectedClass.getName());
                if (e.getClickCount() == 2) {
                    ChooseClassView.this.finalizeSelection();
                    ChooseClassView.this.dispose();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.listAllClasses();
        this.filterClasses();
    }

    private void listSomeClasses(String substring) {
        DefaultListModel<Class> list = new DefaultListModel<Class>();
        String lowered = substring.toLowerCase();
        for (Class clazz : this.filteredClasses) {
            if (!clazz.getName().toLowerCase().contains(lowered)) continue;
            list.addElement(clazz);
        }
        this.lstClasses.setModel(list);
    }

    private void listAllClasses() {
        DefaultListModel<Class> list = new DefaultListModel<Class>();
        for (Class clazz : this.allClasses) {
            list.addElement(clazz);
        }
        this.lstClasses.setModel(list);
    }

    private void initComponents() {
        this.txtClass = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstClasses = new JList();
        this.chkOnlyMains = new JCheckBox();
        this.chkHideJavaClasses = new JCheckBox();
        this.chkHideJavaSnoopClasses = new JCheckBox();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(JavaSnoop.class).getContext().getResourceMap(ChooseClassView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("Form");
        this.txtClass.setText(resourceMap.getString("txtClass.text", new Object[0]));
        this.txtClass.setName("txtClass");
        this.txtClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseClassView.this.txtClassActionPerformed(evt);
            }
        });
        this.txtClass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ChooseClassView.this.txtClassKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ChooseClassView.this.txtClassKeyTyped(evt);
            }
        });
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jScrollPane1.setName("jScrollPane1");
        this.lstClasses.setModel(new AbstractListModel(){
            String[] strings = new String[]{" "};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstClasses.setSelectionMode(0);
        this.lstClasses.setName("lstClasses");
        this.jScrollPane1.setViewportView(this.lstClasses);
        this.chkOnlyMains.setText(resourceMap.getString("chkOnlyMains.text", new Object[0]));
        this.chkOnlyMains.setFocusable(false);
        this.chkOnlyMains.setName("chkOnlyMains");
        this.chkOnlyMains.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseClassView.this.chkOnlyMainsActionPerformed(evt);
            }
        });
        this.chkHideJavaClasses.setSelected(true);
        this.chkHideJavaClasses.setText(resourceMap.getString("chkHideJavaClasses.text", new Object[0]));
        this.chkHideJavaClasses.setName("chkHideJavaClasses");
        this.chkHideJavaClasses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseClassView.this.chkHideJavaClassesActionPerformed(evt);
            }
        });
        this.chkHideJavaSnoopClasses.setSelected(true);
        this.chkHideJavaSnoopClasses.setText(resourceMap.getString("chkHideJavaSnoopClasses.text", new Object[0]));
        this.chkHideJavaSnoopClasses.setName("chkHideJavaSnoopClasses");
        this.chkHideJavaSnoopClasses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseClassView.this.chkHideJavaSnoopClassesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 529, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtClass).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkOnlyMains).addGroup(layout.createSequentialGroup().addComponent(this.chkHideJavaClasses).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkHideJavaSnoopClasses))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.chkOnlyMains, -2, 19, -2))).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtClass, -2, -1, -2).addComponent(this.chkHideJavaClasses).addComponent(this.chkHideJavaSnoopClasses)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 170, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(1, this.chkHideJavaClasses, this.chkHideJavaSnoopClasses, this.chkOnlyMains);
        this.pack();
    }

    private void txtClassKeyTyped(KeyEvent evt) {
    }

    private void txtClassActionPerformed(ActionEvent evt) {
        this.lstClasses.setSelectedIndex(0);
        this.lstClasses.requestFocus();
    }

    private void chkOnlyMainsActionPerformed(ActionEvent evt) {
        this.filterClasses();
    }

    private void chkHideJavaClassesActionPerformed(ActionEvent evt) {
        this.filterClasses();
    }

    private void chkHideJavaSnoopClassesActionPerformed(ActionEvent evt) {
        this.filterClasses();
    }

    private void txtClassKeyReleased(KeyEvent evt) {
        String substring = this.txtClass.getText();
        if (substring.length() == 0) {
            this.filterClasses();
        } else {
            this.filterClasses();
            this.listSomeClasses(substring);
        }
    }

    private void finalizeSelection() {
        this.className = this.txtClass.getText();
    }

    private void filterClasses() {
        this.filteredClasses = new ArrayList<Class>();
        DefaultListModel<Class> list = new DefaultListModel<Class>();
        for (Class clazz : this.allClasses) {
            String cls = clazz.getName();
            boolean shouldShow = true;
            boolean isJavaOrSunClass = ClasspathUtil.isJavaOrSunClass(cls);
            if (this.chkHideJavaClasses.isSelected()) {
                boolean bl = shouldShow = !isJavaOrSunClass;
            }
            if (shouldShow && this.chkHideJavaSnoopClasses.isSelected()) {
                boolean bl = shouldShow = !ClasspathUtil.isJavaSnoopClass(cls);
            }
            if (shouldShow && !isJavaOrSunClass && this.chkOnlyMains.isSelected() && !ReflectionUtil.hasMainClass(clazz)) {
                shouldShow = false;
            }
            if (!shouldShow) continue;
            this.filteredClasses.add(clazz);
            list.addElement(clazz);
        }
        this.lstClasses.setModel(list);
    }

    public Class getChosenClass() {
        return this.selectedClass;
    }

    class ClassListCellRenderer
    extends DefaultListCellRenderer {
        ClassListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
            Class c = (Class)value;
            String name = c.getName();
            if (c.isInterface()) {
                name = name + " (interface)";
            } else if (Modifier.isAbstract(c.getModifiers())) {
                name = name + " (abstract)";
            }
            return super.getListCellRendererComponent((JList<?>)list, name, index, iss, chf);
        }
    }
}

