/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.util;

import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.agent.SnoopAgent;

public class CanaryUtil {
    public static String currentCanary = null;

    public static String getChirp(String canaryType, String className, String methodName, String returnType) {
        StringBuilder sb = new StringBuilder();
        String nl = System.getProperty("line.separator");
        sb.append("  com.aspect.snoop.util.CanaryUtil.canaryChirp(");
        sb.append(canaryType);
        sb.append(".class, ");
        sb.append(className);
        sb.append(".class, \"");
        sb.append(methodName);
        sb.append("\", $sig, $args);");
        sb.append(nl);
        return sb.toString();
    }

    public static void canaryChirp(Class canaryType, Class clazz, String methodName, Class[] types, Object[] objects) {
        if (!CanaryUtil.canaryIsHeard(canaryType, types, objects)) {
            return;
        }
        try {
            SnoopAgent.getMainView().getCanaryView().addChirp(clazz, clazz.getDeclaredMethod(methodName, types));
        }
        catch (Exception ex) {
            AgentLogger.error("Problem receiving canary", ex);
        }
    }

    private static boolean canaryIsHeard(Class canaryType, Class[] types, Object[] objects) {
        if (currentCanary == null) {
            System.err.println("Got canary message but canary is null");
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Object value;
            Class type;
            if (objects[i] == null || !canaryType.equals(type = types[i])) continue;
            if (type.equals(String.class)) {
                value = (String)objects[i];
                if (value == null || !((String)value).contains(currentCanary)) continue;
                AgentLogger.info("Reporting canary: found '" + (String)value + "' which matches canary '" + currentCanary + "'");
                return true;
            }
            if (type.equals(Short.class)) {
                value = (Short)objects[i];
                if (!Short.valueOf(currentCanary).equals(value)) continue;
                return true;
            }
            if (type.equals(Integer.class)) {
                value = (Integer)objects[i];
                if (!Integer.valueOf(currentCanary).equals(value)) continue;
                return true;
            }
            if (type.equals(Long.class)) {
                value = (Long)objects[i];
                if (!Long.valueOf(currentCanary).equals(value)) continue;
                return true;
            }
            if (type.equals(Double.class)) {
                value = (Double)objects[i];
                if (!Double.valueOf(currentCanary).equals(value)) continue;
                return true;
            }
            if (!type.equals(Float.class)) continue;
            value = (Float)objects[i];
            if (!Float.valueOf(currentCanary).equals(value)) continue;
            return true;
        }
        return false;
    }
}

