/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper;

import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.ui.tamper.EditObjectView;
import com.aspect.snoop.ui.tamper.Parameter;
import com.aspect.snoop.ui.tamper.array.EditArrayView;
import com.aspect.snoop.ui.tamper.bytearray.EditByteArrayView;
import com.aspect.snoop.ui.tamper.list.EditListView;
import com.aspect.snoop.ui.tamper.map.EditMapView;
import com.aspect.snoop.util.ReflectionUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ParameterTableModel
extends AbstractTableModel {
    private List<Parameter> parameters;
    private JTable table;
    private static Class[] columnTypes = new Class[]{Integer.class, String.class, String.class, JButton.class};
    private static String[] columnNames = new String[]{"Index", "Type", "Value", ""};

    public ParameterTableModel(JTable table, List<Parameter> parameters) {
        this.table = table;
        this.parameters = parameters;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int column) {
        return columnTypes[column];
    }

    @Override
    public int getRowCount() {
        return this.parameters.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public void setValueAt(Object newObject, int rowIndex, int columnIndex) {
        Parameter p = this.parameters.get(rowIndex);
        try {
            String s = (String)newObject;
            if (p.getObject() instanceof Boolean) {
                p.setObject(Boolean.valueOf(s));
            } else if (p.getObject() instanceof Character) {
                p.setObject(Character.valueOf(s.charAt(0)));
            } else if (p.getObject() instanceof String) {
                p.setObject(s);
            } else if (p.getObject() instanceof Byte) {
                p.setObject(Byte.parseByte(s));
            } else if (p.getObject() instanceof Short) {
                p.setObject(Short.parseShort(s));
            } else if (p.getObject() instanceof Integer) {
                p.setObject(Integer.parseInt(s));
            } else if (p.getObject() instanceof Long) {
                p.setObject(Long.parseLong(s));
            } else if (p.getObject() instanceof Double) {
                p.setObject(Double.parseDouble(s));
            } else if (p.getObject() instanceof Float) {
                p.setObject(Float.valueOf(Float.parseFloat(s)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Parameter p = this.parameters.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    return p.getIndex();
                }
                case 1: {
                    if (p.getObject() != null) {
                        return ReflectionUtil.getSimpleClassName(p.getObject().getClass().getName());
                    }
                }
                case 2: {
                    return p.getObject();
                }
                case 3: {
                    if (p.getObject() == null) {
                        return null;
                    }
                    if (ReflectionUtil.isPrimitiveButNotArray(p.getObject())) break;
                    final Parameter param = p;
                    final Object o = p.getObject();
                    JButton btn = new JButton("Edit");
                    btn.setEnabled(true);
                    btn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (o instanceof Map) {
                                EditMapView view = new EditMapView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (Map)o);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                ParameterTableModel.this.fireTableStructureChanged();
                            } else if (o instanceof List) {
                                EditListView view = new EditListView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (List)o);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                ParameterTableModel.this.fireTableStructureChanged();
                            } else if (o instanceof byte[]) {
                                EditByteArrayView view = new EditByteArrayView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (byte[])o);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                param.setObject(view.getBytes());
                                ParameterTableModel.this.fireTableStructureChanged();
                            } else if (o.getClass().isArray()) {
                                EditArrayView view = new EditArrayView((Frame)JavaSnoop.getApplication().getMainFrame(), true, (Object[])o);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                ParameterTableModel.this.fireTableStructureChanged();
                            } else {
                                EditObjectView view = new EditObjectView((Frame)JavaSnoop.getApplication().getMainFrame(), true, o);
                                view.setVisible(true);
                                UIUtil.waitForInput(view);
                                if (view.shouldReplaceObject()) {
                                    Object replacement = view.getObjectReplacement();
                                    param.setObject(replacement);
                                }
                                ParameterTableModel.this.fireTableStructureChanged();
                            }
                        }
                    });
                    return btn;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Parameter p;
        return columnIndex == 2 ? ReflectionUtil.isPrimitiveButNotArray((p = this.parameters.get(rowIndex)).getObject()) : columnIndex == 3;
    }
}

