/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.hook;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.ui.hook.MethodTableModel;
import com.aspect.snoop.util.ClasspathUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Dialog;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class FunctionSearchView
extends JDialog {
    List<Class> classes;
    Method methodChosen;
    private JButton btnSearch;
    private JCheckBox chkHideJavaClasses;
    private JCheckBox chkHideJavaSnoopClasses;
    private JCheckBox chkIgnoreCase;
    private JCheckBox chkReturnType;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JComboBox lstReturnType;
    private JTable tblResults;
    private JTextField txtMethod;

    public Method getChosenMethod() {
        return this.methodChosen;
    }

    public FunctionSearchView(JDialog parent, boolean modal, List<Class> classes) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.classes = classes;
        this.methodChosen = null;
        ArrayList<AccessibleObject> empty = new ArrayList<AccessibleObject>();
        this.tblResults.setModel(new MethodTableModel(empty));
        this.tblResults.setRowHeight(20);
        this.tblResults.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.tblResults.getColumnModel().getColumn(1).setPreferredWidth(575);
        this.tblResults.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int sel;
                if (e.getClickCount() == 2 && (sel = FunctionSearchView.this.tblResults.getSelectedRow()) != -1) {
                    FunctionSearchView.this.methodChosen = (Method)FunctionSearchView.this.tblResults.getModel().getValueAt(sel, 1);
                    FunctionSearchView.this.dispose();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public Method getMethodChosen() {
        return this.methodChosen;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtMethod = new JTextField();
        this.btnSearch = new JButton();
        this.chkHideJavaClasses = new JCheckBox();
        this.chkHideJavaSnoopClasses = new JCheckBox();
        this.chkReturnType = new JCheckBox();
        this.lstReturnType = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.tblResults = new JTable();
        this.chkIgnoreCase = new JCheckBox();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(FunctionSearchView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.txtMethod.setText(resourceMap.getString("txtMethod.text", new Object[0]));
        this.txtMethod.setName("txtMethod");
        this.txtMethod.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                FunctionSearchView.this.txtMethodKeyTyped(evt);
            }
        });
        ApplicationActionMap actionMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getActionMap(FunctionSearchView.class, (Object)this);
        this.btnSearch.setAction(actionMap.get("populateResults"));
        this.btnSearch.setText(resourceMap.getString("btnSearch.text", new Object[0]));
        this.btnSearch.setFocusable(false);
        this.btnSearch.setName("btnSearch");
        this.chkHideJavaClasses.setSelected(true);
        this.chkHideJavaClasses.setText(resourceMap.getString("chkHideJavaClasses.text", new Object[0]));
        this.chkHideJavaClasses.setFocusable(false);
        this.chkHideJavaClasses.setName("chkHideJavaClasses");
        this.chkHideJavaSnoopClasses.setSelected(true);
        this.chkHideJavaSnoopClasses.setText(resourceMap.getString("chkHideJavaSnoopClasses.text", new Object[0]));
        this.chkHideJavaSnoopClasses.setFocusable(false);
        this.chkHideJavaSnoopClasses.setName("chkHideJavaSnoopClasses");
        this.chkReturnType.setAction(actionMap.get("flipReturnType"));
        this.chkReturnType.setText(resourceMap.getString("chkReturnType.text", new Object[0]));
        this.chkReturnType.setName("chkReturnType");
        this.lstReturnType.setModel(new DefaultComboBoxModel<String>(new String[]{"void", "String", "boolean", "byte", "char", "short", "int", "long", "double", "float"}));
        this.lstReturnType.setEnabled(false);
        this.lstReturnType.setName("lstReturnType");
        this.jScrollPane2.setName("jScrollPane2");
        this.tblResults.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblResults.setName("tblResults");
        this.jScrollPane2.setViewportView(this.tblResults);
        this.chkIgnoreCase.setSelected(true);
        this.chkIgnoreCase.setText(resourceMap.getString("chkIgnoreCase.text", new Object[0]));
        this.chkIgnoreCase.setName("chkIgnoreCase");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.txtMethod, -2, 205, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearch))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.chkHideJavaClasses).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkHideJavaSnoopClasses)).addGroup(layout.createSequentialGroup().addComponent(this.chkReturnType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lstReturnType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkIgnoreCase, -1, -1, Short.MAX_VALUE))).addGap(12, 12, 12)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jScrollPane2, -1, 568, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.chkHideJavaClasses).addComponent(this.chkHideJavaSnoopClasses)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtMethod, -2, -1, -2).addComponent(this.btnSearch).addComponent(this.chkReturnType).addComponent(this.lstReturnType, -2, -1, -2).addComponent(this.chkIgnoreCase)).addContainerGap(265, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(66, 66, 66).addComponent(this.jScrollPane2, -1, 243, Short.MAX_VALUE).addContainerGap())));
        this.pack();
    }

    private void txtMethodKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.btnSearch.setEnabled(false);
            this.populateResults();
            this.btnSearch.setEnabled(true);
        }
    }

    @Action
    public void populateResults() {
        if (this.txtMethod.getText().length() < 3) {
            UIUtil.showErrorMessage(this, "You must type at least 3 characters before searching");
            return;
        }
        String substring = this.txtMethod.getText();
        String loweredSubstring = substring.toLowerCase();
        ArrayList<AccessibleObject> hits = new ArrayList<AccessibleObject>();
        for (int i = 0; i < this.classes.size(); ++i) {
            Class cls = this.classes.get(i);
            if (this.chkHideJavaClasses.isSelected() && ClasspathUtil.isJavaOrSunClass(cls.getName()) || this.chkHideJavaSnoopClasses.isSelected() && ClasspathUtil.isJavaSnoopClass(cls.getName())) continue;
            try {
                String loweredMethodName;
                int j;
                Method[] methods = cls.getDeclaredMethods();
                Constructor<?>[] constructors = cls.getDeclaredConstructors();
                for (j = 0; j < constructors.length; ++j) {
                    Constructor<?> constructor = constructors[j];
                    loweredMethodName = constructor.getName().toLowerCase();
                    if ((this.chkIgnoreCase.isSelected() || !constructor.getName().contains(substring)) && (!this.chkIgnoreCase.isSelected() || !loweredMethodName.contains(loweredSubstring))) continue;
                    if (this.chkReturnType.isSelected()) {
                        if (!this.isReturnTypeMatch(Void.class, (String)this.lstReturnType.getSelectedItem())) continue;
                        hits.add(constructor);
                        continue;
                    }
                    hits.add(constructor);
                }
                for (j = 0; j < methods.length; ++j) {
                    Method m = methods[j];
                    loweredMethodName = m.getName().toLowerCase();
                    if ((this.chkIgnoreCase.isSelected() || !m.getName().contains(substring)) && (!this.chkIgnoreCase.isSelected() || !loweredMethodName.contains(loweredSubstring))) continue;
                    if (this.chkReturnType.isSelected()) {
                        if (!this.isReturnTypeMatch(m.getReturnType(), (String)this.lstReturnType.getSelectedItem())) continue;
                        hits.add(m);
                        continue;
                    }
                    hits.add(m);
                }
                continue;
            }
            catch (NoClassDefFoundError ncde) {
                ncde.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        MethodTableModel model = new MethodTableModel(hits);
        this.tblResults.setModel(model);
        this.tblResults.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.tblResults.getColumnModel().getColumn(1).setPreferredWidth(575);
        this.tblResults.repaint();
        this.tblResults.updateUI();
        if (hits.isEmpty()) {
            UIUtil.showErrorMessage(this, "No methods found");
        }
    }

    private boolean isReturnTypeMatch(Class c, String ret) {
        boolean result = false;
        if ("String".equals(ret) && c.equals(String.class)) {
            result = true;
        } else if ("boolean".equals(ret) && (c.equals(Boolean.TYPE) || c.equals(Boolean.class))) {
            result = true;
        } else if ("char".equals(ret) && (c.equals(Character.TYPE) || c.equals(Character.class))) {
            result = true;
        } else if ("byte".equals(ret) && (c.equals(Byte.TYPE) || c.equals(Byte.class))) {
            result = true;
        } else if ("short".equals(ret) && (c.equals(Short.TYPE) || c.equals(Short.class))) {
            result = true;
        } else if ("int".equals(ret) && (c.equals(Integer.TYPE) || c.equals(Integer.class))) {
            result = true;
        } else if ("long".equals(ret) && (c.equals(Long.TYPE) || c.equals(Long.class))) {
            result = true;
        } else if ("double".equals(ret) && (c.equals(Double.class) || c.equals(Double.TYPE))) {
            result = true;
        } else if ("float".equals(ret) && (c.equals(Float.TYPE) || c.equals(Float.class))) {
            result = true;
        } else if ("void".equals(ret) && (c.equals(Void.TYPE) || c.equals(Void.class))) {
            result = true;
        }
        return result;
    }

    @Action
    public void flipReturnType() {
        this.lstReturnType.setEnabled(this.chkReturnType.isSelected());
    }
}

