/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.FrameView;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.org.jdesktop.application.SingleFrameApplication;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.SnoopSession;
import com.aspect.snoop.agent.AgentCommunicationException;
import com.aspect.snoop.agent.AgentJarCreator;
import com.aspect.snoop.ui.JavaSnoopAboutBox;
import com.aspect.snoop.ui.choose.process.ChooseProcessView;
import com.aspect.snoop.ui.choose.process.NewProcessInfoView;
import com.aspect.snoop.util.AttachUtil;
import com.aspect.snoop.util.UIUtil;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import java.awt.Frame;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class StartupView
extends FrameView {
    private static final Logger logger = Logger.getLogger(StartupView.class);
    private JButton btnAttach;
    private JButton btnStart;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel mainPanel;
    private JProgressBar progressBar;
    private JDialog aboutBox;

    public StartupView(SingleFrameApplication app) {
        super((Application)app);
        this.initComponents();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = JavaSnoop.getApplication().getMainFrame();
            this.aboutBox = new JavaSnoopAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        JavaSnoop.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.btnAttach = new JButton();
        this.jLabel5 = new JLabel();
        this.btnStart = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        JLabel imageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        ApplicationActionMap actionMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getActionMap(StartupView.class, (Object)this);
        this.btnAttach.setAction(actionMap.get("attachToExisting"));
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(StartupView.class);
        this.btnAttach.setFont(resourceMap.getFont("btnAttach.font"));
        this.btnAttach.setText(resourceMap.getString("btnAttach.text", new Object[0]));
        this.btnAttach.setToolTipText(resourceMap.getString("btnAttach.toolTipText", new Object[0]));
        this.btnAttach.setName("btnAttach");
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.btnStart.setAction(actionMap.get("startNewProcess"));
        this.btnStart.setFont(resourceMap.getFont("btnStart.font"));
        this.btnStart.setText(resourceMap.getString("btnStart.text", new Object[0]));
        this.btnStart.setToolTipText(resourceMap.getString("btnStart.toolTipText", new Object[0]));
        this.btnStart.setName("btnStart");
        this.jLabel2.setFont(resourceMap.getFont("jLabel2.font"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        imageLabel.setHorizontalAlignment(0);
        imageLabel.setIcon(resourceMap.getIcon("imageLabel.icon"));
        imageLabel.setAlignmentX(0.5f);
        imageLabel.setHorizontalTextPosition(0);
        imageLabel.setName("imageLabel");
        this.progressBar.setEnabled(false);
        this.progressBar.setName("progressBar");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.progressBar, -2, 284, -2)).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.btnAttach, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -1, 86, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStart, -2, 143, -2)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(imageLabel, -2, 138, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 246, Short.MAX_VALUE).addComponent(this.jLabel4, -1, 246, Short.MAX_VALUE).addComponent(this.jLabel3))).addGroup(mainPanelLayout.createSequentialGroup().addGap(83, 83, 83).addComponent(this.jLabel2)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(imageLabel, -2, 118, -2).addGroup(mainPanelLayout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel1).addGap(27, 27, 27).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnAttach, -2, 60, -2).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnStart, -2, 60, -2).addComponent(this.jLabel5))).addGap(18, 18, 18).addComponent(this.progressBar, -1, 22, Short.MAX_VALUE).addContainerGap()));
        this.setComponent(this.mainPanel);
    }

    @Action
    public void attachToExisting() {
        ChooseProcessView view = new ChooseProcessView(this.getFrame(), true);
        view.setVisible(true);
        UIUtil.waitForInput(view);
        final String pid = view.getPid();
        if (pid == null) {
            return;
        }
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString("Building agent...");
        this.progressBar.setStringPainted(true);
        SwingWorker worker = new SwingWorker(){

            @Override
            protected void done() {
                StartupView.this.progressBar.setString("Agent attached! UI should appear momentarily...");
                StartupView.this.progressBar.setIndeterminate(false);
            }

            protected Object doInBackground() throws Exception {
                try {
                    String agentJarPath = AgentJarCreator.createAgentJar(false);
                    StartupView.this.progressBar.setString("Attaching agent...");
                    logger.info((Object)("Attaching to process ID " + pid + " with generated agent at " + agentJarPath));
                    AttachUtil.loadAgentInOtherVM(agentJarPath, pid);
                }
                catch (AttachNotSupportedException ex) {
                    logger.error((Object)ex);
                    UIUtil.showErrorMessage(StartupView.this.getFrame(), "Targeted virtual machine does not support attaching: " + ex.getMessage());
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                    UIUtil.showErrorMessage(StartupView.this.getFrame(), "Could not attach to new virtual machine due to I/O error: " + ex.getMessage());
                }
                catch (AgentLoadException ex) {
                    logger.error((Object)ex);
                    UIUtil.showErrorMessage(StartupView.this.getFrame(), "Could not load agent: " + ex.getMessage());
                }
                catch (AgentInitializationException ex) {
                    logger.error((Object)ex);
                    UIUtil.showErrorMessage(StartupView.this.getFrame(), "Could not initialize agent: " + ex.getMessage());
                }
                catch (AgentCommunicationException ex) {
                    logger.error((Object)ex);
                    UIUtil.showErrorMessage(StartupView.this.getFrame(), "Could not communicate with agent. It's possible that this process has already been attached to once.");
                }
                return null;
            }
        };
        worker.execute();
    }

    @Action
    public void startNewProcess() {
        NewProcessInfoView view = new NewProcessInfoView((Frame)this.getFrame(), true);
        view.setVisible(true);
        UIUtil.waitForInput(view);
        final SnoopSession session = view.getSnoopSession();
        if (session == null) {
            return;
        }
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString("Building agent...");
        this.progressBar.setStringPainted(true);
        SwingWorker worker = new SwingWorker(){

            @Override
            protected void done() {
                StartupView.this.progressBar.setString("Process started! UI should appear momentarily...");
                StartupView.this.progressBar.setValue(0);
                StartupView.this.progressBar.setIndeterminate(false);
            }

            protected Object doInBackground() throws Exception {
                try {
                    String agentJarPath = AgentJarCreator.createAgentJar(false);
                    StartupView.this.progressBar.setString("Starting process with agent...");
                    logger.info((Object)("Starting new process with generated agent at " + agentJarPath));
                    AttachUtil.launchInNewVM(agentJarPath, session);
                }
                catch (AttachNotSupportedException ex) {
                    logger.error((Object)ex);
                    UIUtil.showErrorMessage(StartupView.this.getFrame(), "Targeted virtual machine does not support attaching: " + ex.getMessage());
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                    UIUtil.showErrorMessage(StartupView.this.getFrame(), "Could not attach to new virtual machine due to I/O error: " + ex.getMessage());
                }
                catch (AgentCommunicationException ex) {
                    logger.error((Object)ex);
                    UIUtil.showErrorMessage(StartupView.this.getFrame(), "Could not communicate with agent. It's possible that this process has already been attached to once.");
                }
                return null;
            }
        };
        worker.execute();
    }
}

