/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class ConfigurableCaret
extends DefaultCaret {
    public static final int MIN_STYLE = 0;
    public static final int VERTICAL_LINE_STYLE = 0;
    public static final int UNDERLINE_STYLE = 1;
    public static final int BLOCK_STYLE = 2;
    public static final int BLOCK_BORDER_STYLE = 3;
    public static final int THICK_VERTICAL_LINE_STYLE = 4;
    public static final int MAX_STYLE = 4;
    private static transient Action selectWord = null;
    private static transient Action selectLine = null;
    private transient MouseEvent selectedWordEvent = null;
    private transient Segment seg = new Segment();
    private int style;
    private ChangeableHighlightPainter selectionPainter;
    private static final boolean IS_JAVA_1_4 = "1.4".equals(System.getProperty("java.specification.version"));

    public ConfigurableCaret() {
        this(0);
    }

    public ConfigurableCaret(int n) {
        this.setStyle(n);
        this.selectionPainter = new ChangeableHighlightPainter();
    }

    private void adjustCaret(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(mouseEvent);
        } else {
            this.positionCaret(mouseEvent);
        }
    }

    private void adjustFocus(boolean bl) {
        RTextArea rTextArea = this.getTextArea();
        if (rTextArea != null && rTextArea.isEnabled() && rTextArea.isRequestFocusEnabled()) {
            if (bl) {
                rTextArea.requestFocusInWindow();
            } else {
                rTextArea.requestFocus();
            }
        }
    }

    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            this.validateWidth(rectangle);
            this.x = rectangle.x - 1;
            this.y = rectangle.y;
            this.width = rectangle.width + 4;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    public void deinstall(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.deinstall(jTextComponent);
    }

    protected RTextArea getTextArea() {
        return (RTextArea)this.getComponent();
    }

    public boolean getRoundedSelectionEdges() {
        return ((ChangeableHighlightPainter)this.getSelectionPainter()).getRoundedEdges();
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.selectionPainter;
    }

    public int getStyle() {
        return this.style;
    }

    public void install(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.install(jTextComponent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            JTextComponent jTextComponent;
            RTextArea rTextArea = this.getTextArea();
            int n = mouseEvent.getClickCount();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (n <= 2) {
                    if (IS_JAVA_1_4) {
                        if (n == 1) {
                            this.selectedWordEvent = null;
                        } else {
                            this.selectWord(mouseEvent);
                            this.selectedWordEvent = null;
                        }
                    }
                } else {
                    switch (n %= 2) {
                        case 0: {
                            this.selectWord(mouseEvent);
                            this.selectedWordEvent = null;
                            break;
                        }
                        case 1: {
                            Action action = null;
                            ActionMap actionMap = rTextArea.getActionMap();
                            if (actionMap != null) {
                                action = actionMap.get("select-line");
                            }
                            if (action == null) {
                                if (selectLine == null) {
                                    selectLine = new RTextAreaEditorKit.SelectLineAction();
                                }
                                action = selectLine;
                            }
                            action.actionPerformed(new ActionEvent(rTextArea, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                        }
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) && n == 1 && rTextArea.isEditable() && rTextArea.isEnabled() && (jTextComponent = (JTextComponent)mouseEvent.getSource()) != null) {
                try {
                    Toolkit toolkit = jTextComponent.getToolkit();
                    Clipboard clipboard = toolkit.getSystemSelection();
                    if (clipboard != null) {
                        Transferable transferable;
                        this.adjustCaret(mouseEvent);
                        TransferHandler transferHandler = jTextComponent.getTransferHandler();
                        if (transferHandler != null && (transferable = clipboard.getContents(null)) != null) {
                            transferHandler.importData(jTextComponent, transferable);
                        }
                        this.adjustFocus(true);
                    } else {
                        rTextArea.paste();
                    }
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            try {
                RTextArea rTextArea = this.getTextArea();
                graphics.setColor(rTextArea.getCaretColor());
                TextUI textUI = rTextArea.getUI();
                Rectangle rectangle = textUI.modelToView(rTextArea, this.getDot());
                this.validateWidth(rectangle);
                rectangle.height -= 2;
                switch (this.style) {
                    case 2: {
                        graphics.setXORMode(Color.WHITE);
                        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        break;
                    }
                    case 3: {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                        break;
                    }
                    case 1: {
                        graphics.setXORMode(Color.WHITE);
                        int n = rectangle.y + rectangle.height;
                        graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
                        break;
                    }
                    default: {
                        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                        break;
                    }
                    case 4: {
                        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                        ++rectangle.x;
                        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.setStyle(objectInputStream.readInt());
        this.seg = new Segment();
    }

    private void selectWord(MouseEvent mouseEvent) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == mouseEvent.getX() && this.selectedWordEvent.getY() == mouseEvent.getY()) {
            return;
        }
        Action action = null;
        RTextArea rTextArea = this.getTextArea();
        ActionMap actionMap = rTextArea.getActionMap();
        if (actionMap != null) {
            action = actionMap.get("select-word");
        }
        if (action == null) {
            if (selectWord == null) {
                selectWord = new RTextAreaEditorKit.SelectWordAction();
            }
            action = selectWord;
        }
        action.actionPerformed(new ActionEvent(rTextArea, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
        this.selectedWordEvent = mouseEvent;
    }

    public void setRoundedSelectionEdges(boolean bl) {
        ((ChangeableHighlightPainter)this.getSelectionPainter()).setRoundedEdges(bl);
    }

    public void setSelectionVisible(boolean bl) {
        super.setSelectionVisible(true);
    }

    public void setStyle(int n) {
        if (n < 0 || n > 4) {
            n = 0;
        }
        this.style = n;
        this.repaint();
    }

    private void validateWidth(Rectangle rectangle) {
        if (rectangle != null && rectangle.width <= 1) {
            try {
                RTextArea rTextArea = this.getTextArea();
                rTextArea.getDocument().getText(this.getDot(), 1, this.seg);
                Font font = rTextArea.getFont();
                FontMetrics fontMetrics = rTextArea.getFontMetrics(font);
                rectangle.width = fontMetrics.charWidth(this.seg.array[this.seg.offset]);
                if (rectangle.width == 0) {
                    rectangle.width = fontMetrics.charWidth(' ');
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                rectangle.width = 8;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.getStyle());
    }
}

