/*
 * Decompiled with CFR 0.152.
 */
package soot.util.dot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import soot.util.dot.DotGraphAttribute;
import soot.util.dot.DotGraphUtility;
import soot.util.dot.Renderable;

public class DotGraphNode
implements Renderable {
    private String name;
    private List<DotGraphAttribute> attributes;

    public DotGraphNode(String name) {
        this.name = "\"" + DotGraphUtility.replaceQuotes(name) + "\"";
    }

    public String getName() {
        return this.name;
    }

    public void setLabel(String label) {
        label = DotGraphUtility.replaceQuotes(label);
        label = DotGraphUtility.replaceReturns(label);
        this.setAttribute("label", "\"" + label + "\"");
    }

    public void setHTMLLabel(String label) {
        label = DotGraphUtility.replaceReturns(label);
        this.setAttribute("label", label);
    }

    public void setShape(String shape) {
        this.setAttribute("shape", shape);
    }

    public void setStyle(String style) {
        this.setAttribute("style", style);
    }

    public void setAttribute(String id, String value2) {
        if (this.attributes == null) {
            this.attributes = new LinkedList<DotGraphAttribute>();
        }
        this.setAttribute(new DotGraphAttribute(id, value2));
    }

    public void setAttribute(DotGraphAttribute attr2) {
        if (this.attributes == null) {
            this.attributes = new LinkedList<DotGraphAttribute>();
        }
        this.attributes.add(attr2);
    }

    @Override
    public void render(OutputStream out, int indent) throws IOException {
        StringBuffer line = new StringBuffer(this.getName());
        if (this.attributes != null) {
            line.append(" [");
            for (DotGraphAttribute attr2 : this.attributes) {
                line.append(attr2.toString());
                line.append(",");
            }
            line.append("];");
        }
        DotGraphUtility.renderLine(out, new String(line), indent);
    }
}

