/*
 * Decompiled with CFR 0.152.
 */
package soot.util.dot;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import soot.util.dot.DotGraphAttribute;
import soot.util.dot.DotGraphCommand;
import soot.util.dot.DotGraphEdge;
import soot.util.dot.DotGraphNode;
import soot.util.dot.DotGraphUtility;
import soot.util.dot.Renderable;

public class DotGraph
implements Renderable {
    private String graphname;
    private boolean isSubGraph;
    private HashMap<String, DotGraphNode> nodes;
    private List<Renderable> drawElements;
    private List<DotGraphAttribute> attributes;
    public static final String DOT_EXTENSION = ".dot";

    public DotGraph(String graphname) {
        this.graphname = graphname;
        this.isSubGraph = false;
        this.nodes = new HashMap(100);
        this.drawElements = new LinkedList<Renderable>();
        this.attributes = new LinkedList<DotGraphAttribute>();
    }

    public void plot(String filename) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
            this.render(out, 0);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DotGraphEdge drawEdge(String from2, String to2) {
        DotGraphNode src = this.drawNode(from2);
        DotGraphNode dst = this.drawNode(to2);
        DotGraphEdge edge = new DotGraphEdge(src, dst);
        this.drawElements.add(edge);
        return edge;
    }

    public DotGraphNode drawNode(String name) {
        DotGraphNode node = this.getNode(name);
        if (node == null) {
            throw new RuntimeException("Assertion failed.");
        }
        if (!this.drawElements.contains(node)) {
            this.drawElements.add(node);
        }
        return node;
    }

    public DotGraphNode getNode(String name) {
        if (name == null) {
            return null;
        }
        DotGraphNode node = this.nodes.get(name);
        if (node == null) {
            node = new DotGraphNode(name);
            this.nodes.put(name, node);
        }
        return node;
    }

    public void setNodeShape(String shape) {
        StringBuffer command = new StringBuffer("node [shape=");
        command.append(shape);
        command.append("];");
        this.drawElements.add(new DotGraphCommand(new String(command)));
    }

    public void setNodeStyle(String style) {
        StringBuffer command = new StringBuffer("node [style=");
        command.append(style);
        command.append("];");
        this.drawElements.add(new DotGraphCommand(new String(command)));
    }

    public void setGraphSize(double width, double height) {
        String size2 = "\"" + width + "," + height + "\"";
        this.setGraphAttribute("size", size2);
    }

    public void setPageSize(double width, double height) {
        String size2 = "\"" + width + ", " + height + "\"";
        this.setGraphAttribute("page", size2);
    }

    public void setOrientation(String orientation) {
        this.setGraphAttribute("orientation", orientation);
    }

    public void setGraphName(String name) {
        this.graphname = name;
    }

    public void setGraphLabel(String label) {
        label = DotGraphUtility.replaceQuotes(label);
        label = DotGraphUtility.replaceReturns(label);
        this.setGraphAttribute("label", "\"" + label + "\"");
    }

    public void setGraphAttribute(String id, String value2) {
        this.setGraphAttribute(new DotGraphAttribute(id, value2));
    }

    public void setGraphAttribute(DotGraphAttribute attr2) {
        this.attributes.add(attr2);
    }

    public void drawUndirectedEdge(String label1, String label2) {
    }

    public DotGraph createSubGraph(String label) {
        DotGraph subgraph = new DotGraph(label);
        subgraph.isSubGraph = true;
        this.drawElements.add(subgraph);
        return subgraph;
    }

    @Override
    public void render(OutputStream out, int indent) throws IOException {
        String graphname = this.graphname;
        if (!this.isSubGraph) {
            DotGraphUtility.renderLine(out, "digraph \"" + graphname + "\" {", indent);
        } else {
            DotGraphUtility.renderLine(out, "subgraph \"" + graphname + "\" {", indent);
        }
        for (DotGraphAttribute attr2 : this.attributes) {
            DotGraphUtility.renderLine(out, attr2.toString() + ";", indent + 4);
        }
        for (Renderable element2 : this.drawElements) {
            element2.render(out, indent + 4);
        }
        DotGraphUtility.renderLine(out, "}", indent);
    }
}

