/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Unit;
import soot.toolkits.graph.UnitGraph;

public abstract class UnitMap<T>
implements Map<Unit, T> {
    private Map<Unit, T> unitToResult;

    public UnitMap(Body b) {
        this.unitToResult = new HashMap<Unit, T>();
        this.map(b);
    }

    public UnitMap(UnitGraph g) {
        this(g.getBody());
    }

    public UnitMap(Body b, int initialCapacity) {
        this.unitToResult = new HashMap<Unit, T>(initialCapacity);
        this.map(b);
    }

    public UnitMap(UnitGraph g, int initialCapacity) {
        this(g.getBody(), initialCapacity);
    }

    public UnitMap(Body b, int initialCapacity, float loadFactor) {
        this.unitToResult = new HashMap<Unit, T>(initialCapacity);
        this.init();
        this.map(b);
    }

    public UnitMap(UnitGraph g, int initialCapacity, float loadFactor) {
        this(g.getBody(), initialCapacity);
    }

    private void map(Body b) {
        for (Unit currentUnit : b.getUnits()) {
            T o = this.mapTo(currentUnit);
            if (o == null) continue;
            this.unitToResult.put(currentUnit, o);
        }
    }

    protected void init() {
    }

    protected abstract T mapTo(Unit var1);

    @Override
    public void clear() {
        this.unitToResult.clear();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.unitToResult.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.unitToResult.containsValue(value2);
    }

    @Override
    public Set<Map.Entry<Unit, T>> entrySet() {
        return this.unitToResult.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.unitToResult.equals(o);
    }

    @Override
    public T get(Object key2) {
        return this.unitToResult.get(key2);
    }

    @Override
    public int hashCode() {
        return this.unitToResult.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.unitToResult.isEmpty();
    }

    @Override
    public Set<Unit> keySet() {
        return this.unitToResult.keySet();
    }

    @Override
    public T put(Unit key2, T value2) {
        return this.unitToResult.put(key2, value2);
    }

    @Override
    public void putAll(Map<? extends Unit, ? extends T> t) {
        this.unitToResult.putAll(t);
    }

    @Override
    public T remove(Object key2) {
        return this.unitToResult.remove(key2);
    }

    @Override
    public int size() {
        return this.unitToResult.size();
    }

    @Override
    public Collection<T> values() {
        return this.unitToResult.values();
    }
}

