/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import com.google.common.collect.Maps;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Singletons;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.Pair;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public class SmartLocalDefsPool {
    protected Map<Body, Pair<Long, SmartLocalDefs>> pool = Maps.newHashMap();

    public SmartLocalDefs getSmartLocalDefsFor(Body b) {
        Pair<Long, SmartLocalDefs> modCountAndSLD = this.pool.get(b);
        if (modCountAndSLD != null && ((Long)modCountAndSLD.o1).longValue() == b.getModificationCount()) {
            return (SmartLocalDefs)modCountAndSLD.o2;
        }
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(b);
        SmartLocalDefs newSLD = new SmartLocalDefs(g, new SimpleLiveLocals(g));
        this.pool.put(b, new Pair<Long, SmartLocalDefs>(b.getModificationCount(), newSLD));
        return newSLD;
    }

    public void clear() {
        this.pool.clear();
    }

    public static SmartLocalDefsPool v() {
        return G.v().soot_toolkits_scalar_SmartLocalDefsPool();
    }

    public SmartLocalDefsPool(Singletons.Global g) {
    }

    public void invalidate(Body b) {
        this.pool.remove(b);
    }
}

