/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Iterator;
import java.util.List;
import soot.toolkits.scalar.FlowSet;

public abstract class AbstractFlowSet<T>
implements FlowSet<T> {
    @Override
    public abstract AbstractFlowSet<T> clone();

    @Override
    public FlowSet<T> emptySet() {
        Object t = this.clone();
        t.clear();
        return t;
    }

    @Override
    public void copy(FlowSet<T> dest) {
        if (this == dest) {
            return;
        }
        dest.clear();
        for (T t : this) {
            dest.add(t);
        }
    }

    @Override
    public void clear() {
        for (T t : this) {
            this.remove(t);
        }
    }

    @Override
    public void union(FlowSet<T> other) {
        if (this == other) {
            return;
        }
        this.union(other, this);
    }

    @Override
    public void union(FlowSet<T> other, FlowSet<T> dest) {
        if (dest != this && dest != other) {
            dest.clear();
        }
        if (dest != null && dest != this) {
            for (T t : this) {
                dest.add(t);
            }
        }
        if (other != null && dest != other) {
            for (T t : other) {
                dest.add(t);
            }
        }
    }

    @Override
    public void intersection(FlowSet<T> other) {
        if (this == other) {
            return;
        }
        this.intersection(other, this);
    }

    @Override
    public void intersection(FlowSet<T> other, FlowSet<T> dest) {
        if (dest == this && dest == other) {
            return;
        }
        AbstractFlowSet<T> elements = null;
        AbstractFlowSet flowSet = null;
        if (dest == this) {
            elements = this;
            flowSet = other;
        } else {
            elements = other;
            flowSet = this;
        }
        dest.clear();
        for (Object t : elements) {
            if (!flowSet.contains(t)) continue;
            dest.add(t);
        }
    }

    @Override
    public void difference(FlowSet<T> other) {
        this.difference(other, this);
    }

    @Override
    public void difference(FlowSet<T> other, FlowSet<T> dest) {
        if (dest == this && dest == other) {
            dest.clear();
            return;
        }
        FlowSet<T> flowSet = other == dest ? other.clone() : other;
        dest.clear();
        for (T t : this) {
            if (flowSet.contains(t)) continue;
            dest.add(t);
        }
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract int size();

    @Override
    public abstract void add(T var1);

    @Override
    public void add(T obj, FlowSet<T> dest) {
        if (dest != this) {
            this.copy(dest);
        }
        dest.add(obj);
    }

    @Override
    public abstract void remove(T var1);

    @Override
    public void remove(T obj, FlowSet<T> dest) {
        if (dest != this) {
            this.copy(dest);
        }
        dest.remove(obj);
    }

    @Override
    public boolean isSubSet(FlowSet<T> other) {
        if (other == this) {
            return true;
        }
        for (T t : other) {
            if (this.contains(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract boolean contains(T var1);

    @Override
    public abstract Iterator<T> iterator();

    @Override
    public abstract List<T> toList();

    public boolean equals(Object o) {
        if (!(o instanceof FlowSet)) {
            return false;
        }
        FlowSet other = (FlowSet)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (T t : this) {
            if (other.contains(t)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = 1;
        for (T t : this) {
            result2 += t.hashCode();
        }
        return result2;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        boolean isFirst = true;
        for (T t : this) {
            if (!isFirst) {
                buffer.append(", ");
            }
            isFirst = false;
            buffer.append(t);
        }
        buffer.append("}");
        return buffer.toString();
    }
}

