/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import soot.toolkits.graph.DirectedGraph;

public class StronglyConnectedComponentsFast<N> {
    protected final List<List<N>> componentList = new ArrayList<List<N>>();
    protected final List<List<N>> trueComponentList = new ArrayList<List<N>>();
    protected int index = 0;
    protected Map<N, Integer> indexForNode;
    protected Map<N, Integer> lowlinkForNode;
    protected Stack<N> s;
    protected DirectedGraph<N> g;

    public StronglyConnectedComponentsFast(DirectedGraph<N> g) {
        this.g = g;
        this.s = new Stack();
        List<N> heads2 = g.getHeads();
        this.indexForNode = new HashMap<N, Integer>();
        this.lowlinkForNode = new HashMap<N, Integer>();
        for (N head2 : heads2) {
            if (this.indexForNode.containsKey(head2)) continue;
            this.recurse(head2);
        }
        this.indexForNode = null;
        this.lowlinkForNode = null;
        this.s = null;
        g = null;
    }

    protected void recurse(N v) {
        this.indexForNode.put(v, this.index);
        int lowLinkForNodeV = this.index++;
        this.lowlinkForNode.put(v, lowLinkForNodeV);
        this.s.push(v);
        for (N succ : this.g.getSuccsOf(v)) {
            Integer indexForNodeSucc = this.indexForNode.get(succ);
            if (indexForNodeSucc == null) {
                this.recurse(succ);
                lowLinkForNodeV = Math.min(lowLinkForNodeV, this.lowlinkForNode.get(succ));
                this.lowlinkForNode.put(v, lowLinkForNodeV);
                continue;
            }
            if (!this.s.contains(succ)) continue;
            lowLinkForNodeV = Math.min(lowLinkForNodeV, indexForNodeSucc);
            this.lowlinkForNode.put(v, lowLinkForNodeV);
        }
        if (lowLinkForNodeV == this.indexForNode.get(v)) {
            N v2;
            ArrayList<N> scc = new ArrayList<N>();
            do {
                v2 = this.s.pop();
                scc.add(v2);
            } while (v != v2);
            this.componentList.add(scc);
            if (scc.size() > 1) {
                this.trueComponentList.add(scc);
            } else {
                Object n = scc.get(0);
                if (this.g.getSuccsOf(n).contains(n)) {
                    this.trueComponentList.add(scc);
                }
            }
        }
    }

    public List<List<N>> getComponents() {
        return this.componentList;
    }

    public List<List<N>> getTrueComponents() {
        return this.trueComponentList;
    }
}

