/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.toolkits.graph.MutableDirectedGraph;

public class HashMutableDirectedGraph<N>
implements MutableDirectedGraph<N> {
    protected Map<N, Set<N>> nodeToPreds = new HashMap<N, Set<N>>();
    protected Map<N, Set<N>> nodeToSuccs = new HashMap<N, Set<N>>();
    protected Set<N> heads = new HashSet<N>();
    protected Set<N> tails = new HashSet<N>();

    private static <T> List<T> getCopy(Collection<? extends T> c) {
        return Collections.unmodifiableList(new ArrayList<T>(c));
    }

    public void clearAll() {
        this.nodeToPreds.clear();
        this.nodeToSuccs.clear();
        this.heads.clear();
        this.tails.clear();
    }

    public Object clone() {
        HashMutableDirectedGraph<N> g = new HashMutableDirectedGraph<N>();
        g.nodeToPreds.putAll(this.nodeToPreds);
        g.nodeToSuccs.putAll(this.nodeToSuccs);
        g.heads.addAll(this.heads);
        g.tails.addAll(this.tails);
        return g;
    }

    @Override
    public List<N> getHeads() {
        return HashMutableDirectedGraph.getCopy(this.heads);
    }

    @Override
    public List<N> getTails() {
        return HashMutableDirectedGraph.getCopy(this.tails);
    }

    @Override
    public List<N> getPredsOf(N s2) {
        Set<N> preds = this.nodeToPreds.get(s2);
        if (preds != null) {
            return HashMutableDirectedGraph.getCopy(preds);
        }
        throw new RuntimeException(s2 + "not in graph!");
    }

    public Set<N> getPredsOfAsSet(N s2) {
        Set<N> preds = this.nodeToPreds.get(s2);
        if (preds != null) {
            return Collections.unmodifiableSet(preds);
        }
        throw new RuntimeException(s2 + "not in graph!");
    }

    @Override
    public List<N> getSuccsOf(N s2) {
        Set<N> succs = this.nodeToSuccs.get(s2);
        if (succs != null) {
            return HashMutableDirectedGraph.getCopy(succs);
        }
        throw new RuntimeException(s2 + "not in graph!");
    }

    public Set<N> getSuccsOfAsSet(N s2) {
        Set<N> succs = this.nodeToSuccs.get(s2);
        if (succs != null) {
            return Collections.unmodifiableSet(succs);
        }
        throw new RuntimeException(s2 + "not in graph!");
    }

    @Override
    public int size() {
        return this.nodeToPreds.keySet().size();
    }

    @Override
    public Iterator<N> iterator() {
        return this.nodeToPreds.keySet().iterator();
    }

    @Override
    public void addEdge(N from2, N to2) {
        if (from2 == null || to2 == null) {
            throw new RuntimeException("edge from or to null");
        }
        if (this.containsEdge(from2, to2)) {
            return;
        }
        Set<N> succsList = this.nodeToSuccs.get(from2);
        if (succsList == null) {
            throw new RuntimeException(from2 + " not in graph!");
        }
        Set<N> predsList = this.nodeToPreds.get(to2);
        if (predsList == null) {
            throw new RuntimeException(to2 + " not in graph!");
        }
        this.heads.remove(to2);
        this.tails.remove(from2);
        succsList.add(to2);
        predsList.add(from2);
    }

    @Override
    public void removeEdge(N from2, N to2) {
        if (!this.containsEdge(from2, to2)) {
            return;
        }
        Set<N> succs = this.nodeToSuccs.get(from2);
        if (succs == null) {
            throw new RuntimeException(from2 + " not in graph!");
        }
        Set<N> preds = this.nodeToPreds.get(to2);
        if (preds == null) {
            throw new RuntimeException(to2 + " not in graph!");
        }
        succs.remove(to2);
        preds.remove(from2);
        if (succs.isEmpty()) {
            this.tails.add(from2);
        }
        if (preds.isEmpty()) {
            this.heads.add(to2);
        }
    }

    @Override
    public boolean containsEdge(N from2, N to2) {
        Set<N> succs = this.nodeToSuccs.get(from2);
        if (succs == null) {
            return false;
        }
        return succs.contains(to2);
    }

    @Override
    public boolean containsNode(Object node) {
        return this.nodeToPreds.keySet().contains(node);
    }

    @Override
    public List<N> getNodes() {
        return HashMutableDirectedGraph.getCopy(this.nodeToPreds.keySet());
    }

    @Override
    public void addNode(N node) {
        if (this.containsNode((Object)node)) {
            throw new RuntimeException("Node already in graph");
        }
        this.nodeToSuccs.put(node, new LinkedHashSet());
        this.nodeToPreds.put(node, new LinkedHashSet());
        this.heads.add(node);
        this.tails.add(node);
    }

    @Override
    public void removeNode(N node) {
        for (Object n : new ArrayList(this.nodeToSuccs.get(node))) {
            this.removeEdge(node, n);
        }
        this.nodeToSuccs.remove(node);
        for (Object n : new ArrayList(this.nodeToPreds.get(node))) {
            this.removeEdge(n, node);
        }
        this.nodeToPreds.remove(node);
        this.heads.remove(node);
        this.tails.remove(node);
    }

    public void printGraph() {
        for (N node : this) {
            G.v().out.println("Node = " + node);
            G.v().out.println("Preds:");
            for (N p : this.getPredsOf(node)) {
                G.v().out.print("     ");
                G.v().out.println(p);
            }
            G.v().out.println("Succs:");
            for (N s2 : this.getSuccsOf(node)) {
                G.v().out.print("     ");
                G.v().out.println(s2);
            }
        }
    }
}

