/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.jimple.Jimple;

public class TrapSplitter
extends BodyTransformer {
    public TrapSplitter(Singletons.Global g) {
    }

    public static TrapSplitter v() {
        return G.v().soot_toDex_TrapSplitter();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        TrapOverlap to2;
        if (b.getTraps().size() < 2) {
            return;
        }
        while ((to2 = this.getNextOverlap(b)) != null) {
            if (to2.t1.getBeginUnit() == to2.t1.getEndUnit()) {
                b.getTraps().remove(to2.t1);
                continue;
            }
            if (to2.t2.getBeginUnit() == to2.t2.getEndUnit()) {
                b.getTraps().remove(to2.t2);
                continue;
            }
            if (to2.t1.getBeginUnit() != to2.t2Start) {
                Trap newTrap = Jimple.v().newTrap(to2.t1.getException(), to2.t1.getBeginUnit(), to2.t2Start, to2.t1.getHandlerUnit());
                this.safeAddTrap(b, newTrap);
                to2.t1.setBeginUnit(to2.t2Start);
                continue;
            }
            if (to2.t1.getBeginUnit() != to2.t2.getBeginUnit()) continue;
            Unit firstEndUnit = to2.t1.getBeginUnit();
            while (firstEndUnit != to2.t1.getEndUnit() && firstEndUnit != to2.t2.getEndUnit()) {
                firstEndUnit = b.getUnits().getSuccOf(firstEndUnit);
            }
            if (firstEndUnit == to2.t1.getEndUnit()) {
                Trap newTrap;
                if (to2.t1.getException() != to2.t2.getException()) {
                    newTrap = Jimple.v().newTrap(to2.t2.getException(), to2.t1.getBeginUnit(), firstEndUnit, to2.t2.getHandlerUnit());
                    this.safeAddTrap(b, newTrap);
                } else if (to2.t1.getHandlerUnit() != to2.t2.getHandlerUnit()) {
                    newTrap = Jimple.v().newTrap(to2.t1.getException(), to2.t1.getBeginUnit(), firstEndUnit, to2.t1.getHandlerUnit());
                    this.safeAddTrap(b, newTrap);
                }
                to2.t2.setBeginUnit(firstEndUnit);
                continue;
            }
            if (firstEndUnit != to2.t2.getEndUnit()) continue;
            if (to2.t1.getException() != to2.t2.getException()) {
                Trap newTrap2 = Jimple.v().newTrap(to2.t1.getException(), to2.t1.getBeginUnit(), firstEndUnit, to2.t1.getHandlerUnit());
                this.safeAddTrap(b, newTrap2);
                to2.t1.setBeginUnit(firstEndUnit);
                continue;
            }
            if (to2.t1.getHandlerUnit() != to2.t2.getHandlerUnit()) {
                b.getTraps().remove(to2.t2);
                continue;
            }
            to2.t1.setBeginUnit(firstEndUnit);
        }
    }

    private void safeAddTrap(Body b, Trap newTrap) {
        if (newTrap.getBeginUnit() != newTrap.getEndUnit()) {
            b.getTraps().add(newTrap);
        }
    }

    private TrapOverlap getNextOverlap(Body b) {
        for (Trap t1 : b.getTraps()) {
            Unit splitUnit = t1.getBeginUnit();
            while (splitUnit != t1.getEndUnit()) {
                for (Trap t2 : b.getTraps()) {
                    if (t1 == t2 || t1.getEndUnit() == t2.getEndUnit() && t1.getException() != t2.getException() || t2.getBeginUnit() != splitUnit) continue;
                    return new TrapOverlap(t1, t2, t2.getBeginUnit());
                }
                splitUnit = b.getUnits().getSuccOf(splitUnit);
            }
        }
        return null;
    }

    private class TrapOverlap {
        private Trap t1;
        private Trap t2;
        private Unit t2Start;

        public TrapOverlap(Trap t1, Trap t2, Unit t2Start) {
            this.t1 = t1;
            this.t2 = t2;
            this.t2Start = t2Start;
        }
    }
}

