/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.BuilderOffsetInstruction;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.MethodImplementationBuilder;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.immutable.ImmutableAnnotation;
import org.jf.dexlib2.immutable.ImmutableAnnotationElement;
import org.jf.dexlib2.immutable.ImmutableExceptionHandler;
import org.jf.dexlib2.immutable.ImmutableMethodParameter;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.immutable.value.ImmutableAnnotationEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableArrayEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableBooleanEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableByteEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableCharEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableDoubleEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEnumEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableFieldEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableFloatEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableLongEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableMethodEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableNullEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableShortEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableStringEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableTypeEncodedValue;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.FileDataStore;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.CompilationDeathException;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.PackManager;
import soot.PatchingChain;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SourceLocator;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.dexpler.Util;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.EmptySwitchEliminator;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LineNumberTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.ParamNamesTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;
import soot.toDex.FastDexTrapTightener;
import soot.toDex.LabelAssigner;
import soot.toDex.LocalRegisterAssignmentInformation;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;
import soot.toDex.StmtVisitor;
import soot.toDex.SynchronizedMethodTransformer;
import soot.toDex.TrapSplitter;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn10t;
import soot.toDex.instructions.Insn30t;
import soot.toDex.instructions.InsnWithOffset;

public class DexPrinter {
    private static final String CLASSES_DEX = "classes.dex";
    private static DexBuilder dexFile;
    private File originalApk;

    public DexPrinter() {
        dexFile = DexBuilder.makeDexBuilder(19);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printApk(String outputDir, File originalApk) throws IOException {
        ZipOutputStream outputApk;
        if (Options.v().output_jar()) {
            outputApk = PackManager.v().getJarFile();
            G.v().out.println("Writing APK to: " + Options.v().output_dir());
        } else {
            String outputFileName = outputDir + File.separatorChar + originalApk.getName();
            File outputFile = new File(outputFileName);
            if (outputFile.exists() && !Options.v().force_overwrite()) {
                throw new CompilationDeathException("Output file " + outputFile + " exists. Not overwriting.");
            }
            outputApk = new ZipOutputStream(new FileOutputStream(outputFile));
            G.v().out.println("Writing APK to: " + outputFileName);
        }
        G.v().out.println("do not forget to sign the .apk file with jarsigner and to align it with zipalign");
        ZipFile original = new ZipFile(originalApk);
        this.copyAllButClassesDexAndSigFiles(original, outputApk);
        original.close();
        File tmpFile = File.createTempFile("toDex", null);
        FileInputStream fis = new FileInputStream(tmpFile);
        try {
            outputApk.putNextEntry(new ZipEntry(CLASSES_DEX));
            this.writeTo(tmpFile.getAbsolutePath());
            while (fis.available() > 0) {
                byte[] data = new byte[fis.available()];
                fis.read(data);
                outputApk.write(data);
            }
            outputApk.closeEntry();
            outputApk.close();
        }
        finally {
            fis.close();
            tmpFile.delete();
        }
    }

    private void copyAllButClassesDexAndSigFiles(ZipFile source, ZipOutputStream destination) throws IOException {
        Enumeration<? extends ZipEntry> sourceEntries = source.entries();
        while (sourceEntries.hasMoreElements()) {
            ZipEntry sourceEntry = sourceEntries.nextElement();
            String sourceEntryName = sourceEntry.getName();
            if (sourceEntryName.equals(CLASSES_DEX) || DexPrinter.isSignatureFile(sourceEntryName)) continue;
            ZipEntry destinationEntry = new ZipEntry(sourceEntryName);
            destinationEntry.setMethod(sourceEntry.getMethod());
            destinationEntry.setSize(sourceEntry.getSize());
            destinationEntry.setCrc(sourceEntry.getCrc());
            destination.putNextEntry(destinationEntry);
            InputStream zipEntryInput = source.getInputStream(sourceEntry);
            byte[] buffer = new byte[2048];
            int bytesRead = zipEntryInput.read(buffer);
            while (bytesRead > 0) {
                destination.write(buffer, 0, bytesRead);
                bytesRead = zipEntryInput.read(buffer);
            }
            zipEntryInput.close();
        }
    }

    private static boolean isSignatureFile(String fileName) {
        StringBuilder sigFileRegex = new StringBuilder();
        sigFileRegex.append("META\\-INF");
        sigFileRegex.append('/');
        sigFileRegex.append("[^/]+");
        sigFileRegex.append("(\\.SF|\\.DSA|\\.RSA|\\.EC)$");
        return fileName.matches(sigFileRegex.toString());
    }

    private void writeTo(String fileName) throws IOException {
        FileDataStore fds = new FileDataStore(new File(fileName));
        dexFile.writeTo(fds);
        fds.close();
    }

    private EncodedValue buildEncodedValueForAnnotation(AnnotationElem elem) {
        switch (elem.getKind()) {
            case 'Z': {
                if (elem instanceof AnnotationIntElem) {
                    AnnotationIntElem e = (AnnotationIntElem)elem;
                    if (e.getValue() == 0) {
                        return ImmutableBooleanEncodedValue.FALSE_VALUE;
                    }
                    if (e.getValue() == 1) {
                        return ImmutableBooleanEncodedValue.TRUE_VALUE;
                    }
                    throw new RuntimeException("error: boolean value from int with value != 0 or 1.");
                }
                if (elem instanceof AnnotationBooleanElem) {
                    AnnotationBooleanElem e = (AnnotationBooleanElem)elem;
                    if (e.getValue()) {
                        return ImmutableBooleanEncodedValue.TRUE_VALUE;
                    }
                    return ImmutableBooleanEncodedValue.FALSE_VALUE;
                }
                throw new RuntimeException("Annotation type incompatible with target type boolean");
            }
            case 'S': {
                AnnotationIntElem e = (AnnotationIntElem)elem;
                return new ImmutableShortEncodedValue((short)e.getValue());
            }
            case 'B': {
                AnnotationIntElem e = (AnnotationIntElem)elem;
                return new ImmutableByteEncodedValue((byte)e.getValue());
            }
            case 'C': {
                AnnotationIntElem e = (AnnotationIntElem)elem;
                return new ImmutableCharEncodedValue((char)e.getValue());
            }
            case 'I': {
                AnnotationIntElem e = (AnnotationIntElem)elem;
                return new ImmutableIntEncodedValue(e.getValue());
            }
            case 'J': {
                AnnotationLongElem e = (AnnotationLongElem)elem;
                return new ImmutableLongEncodedValue(e.getValue());
            }
            case 'F': {
                AnnotationFloatElem e = (AnnotationFloatElem)elem;
                return new ImmutableFloatEncodedValue(e.getValue());
            }
            case 'D': {
                AnnotationDoubleElem e = (AnnotationDoubleElem)elem;
                return new ImmutableDoubleEncodedValue(e.getValue());
            }
            case 's': {
                AnnotationStringElem e = (AnnotationStringElem)elem;
                return new ImmutableStringEncodedValue(e.getValue());
            }
            case 'e': {
                String classT;
                AnnotationEnumElem e = (AnnotationEnumElem)elem;
                String fieldT = classT = SootToDexUtils.getDexClassName(e.getTypeName());
                BuilderFieldReference fref = dexFile.internFieldReference(new ImmutableFieldReference(classT, e.getConstantName(), fieldT));
                return new ImmutableEnumEncodedValue(fref);
            }
            case 'c': {
                AnnotationClassElem e = (AnnotationClassElem)elem;
                return new ImmutableTypeEncodedValue(SootToDexUtils.getDexClassName(e.getDesc()));
            }
            case '[': {
                AnnotationArrayElem e = (AnnotationArrayElem)elem;
                HashSet<EncodedValue> values2 = new HashSet<EncodedValue>();
                for (int i = 0; i < e.getNumValues(); ++i) {
                    EncodedValue val = this.buildEncodedValueForAnnotation(e.getValueAt(i));
                    values2.add(val);
                }
                return new ImmutableArrayEncodedValue(values2);
            }
            case '@': {
                AnnotationAnnotationElem e = (AnnotationAnnotationElem)elem;
                HashSet<String> alreadyWritten = new HashSet<String>();
                ArrayList<ImmutableAnnotationElement> elements = null;
                if (!e.getValue().getElems().isEmpty()) {
                    elements = new ArrayList<ImmutableAnnotationElement>();
                    for (AnnotationElem ae : e.getValue().getElems()) {
                        if (!alreadyWritten.add(ae.getName())) {
                            throw new RuntimeException("Duplicate annotation attribute: " + ae.getName());
                        }
                        ImmutableAnnotationElement element2 = new ImmutableAnnotationElement(ae.getName(), this.buildEncodedValueForAnnotation(ae));
                        elements.add(element2);
                    }
                }
                return new ImmutableAnnotationEncodedValue(SootToDexUtils.getDexClassName(e.getValue().getType()), elements);
            }
            case 'f': {
                AnnotationStringElem e = (AnnotationStringElem)elem;
                String fSig = e.getValue();
                String[] sp2 = fSig.split(" ");
                String classString = SootToDexUtils.getDexClassName(sp2[0].split(":")[0]);
                if (classString.isEmpty()) {
                    throw new RuntimeException("Empty class name in annotation");
                }
                String typeString = sp2[1];
                if (typeString.isEmpty()) {
                    throw new RuntimeException("Empty type string in annotation");
                }
                String fieldName = sp2[2];
                BuilderFieldReference fref = dexFile.internFieldReference(new ImmutableFieldReference(classString, fieldName, typeString));
                return new ImmutableFieldEncodedValue(fref);
            }
            case 'M': {
                AnnotationStringElem e = (AnnotationStringElem)elem;
                String[] sp3 = e.getValue().split(" ");
                String classString = SootToDexUtils.getDexClassName(sp3[0].split(":")[0]);
                if (classString.isEmpty()) {
                    throw new RuntimeException("Empty class name in annotation");
                }
                String returnType = sp3[1];
                String[] sp2 = sp3[2].split("\\(");
                String methodNameString = sp2[0];
                String parameters = sp2[1].replaceAll("\\)", "");
                ArrayList<String> paramTypeList = null;
                if (!parameters.isEmpty()) {
                    paramTypeList = new ArrayList<String>();
                    if (parameters.length() > 0) {
                        for (String p : parameters.split(",")) {
                            paramTypeList.add(p);
                        }
                    }
                }
                BuilderMethodReference mref = dexFile.internMethodReference(new ImmutableMethodReference(classString, methodNameString, paramTypeList, returnType));
                return new ImmutableMethodEncodedValue(mref);
            }
            case 'N': {
                return ImmutableNullEncodedValue.INSTANCE;
            }
        }
        throw new RuntimeException("Unknown Elem Attr Kind: " + elem.getKind());
    }

    private EncodedValue makeConstantItem(SootField sf, Tag t) {
        if (!(t instanceof ConstantValueTag)) {
            throw new RuntimeException("error: t not ConstantValueTag.");
        }
        if (t instanceof IntegerConstantValueTag) {
            Type sft = sf.getType();
            IntegerConstantValueTag i = (IntegerConstantValueTag)t;
            if (sft instanceof BooleanType) {
                int v = i.getIntValue();
                if (v == 0) {
                    return ImmutableBooleanEncodedValue.FALSE_VALUE;
                }
                if (v == 1) {
                    return ImmutableBooleanEncodedValue.TRUE_VALUE;
                }
                throw new RuntimeException("error: boolean value from int with value != 0 or 1.");
            }
            if (sft instanceof CharType) {
                return new ImmutableCharEncodedValue((char)i.getIntValue());
            }
            if (sft instanceof ByteType) {
                return new ImmutableByteEncodedValue((byte)i.getIntValue());
            }
            if (sft instanceof IntType) {
                return new ImmutableIntEncodedValue(i.getIntValue());
            }
            if (sft instanceof ShortType) {
                return new ImmutableShortEncodedValue((short)i.getIntValue());
            }
            throw new RuntimeException("error: unexpected constant tag type: " + t + " for field " + sf);
        }
        if (t instanceof LongConstantValueTag) {
            LongConstantValueTag l = (LongConstantValueTag)t;
            return new ImmutableLongEncodedValue(l.getLongValue());
        }
        if (t instanceof DoubleConstantValueTag) {
            DoubleConstantValueTag d = (DoubleConstantValueTag)t;
            return new ImmutableDoubleEncodedValue(d.getDoubleValue());
        }
        if (t instanceof FloatConstantValueTag) {
            FloatConstantValueTag f = (FloatConstantValueTag)t;
            return new ImmutableFloatEncodedValue(f.getFloatValue());
        }
        if (t instanceof StringConstantValueTag) {
            StringConstantValueTag s2 = (StringConstantValueTag)t;
            return new ImmutableStringEncodedValue(s2.getStringValue());
        }
        throw new RuntimeException("Unexpected constant type");
    }

    private void addAsClassDefItem(SootClass c) {
        String sourceFile = null;
        if (c.hasTag("SourceFileTag")) {
            SourceFileTag sft = (SourceFileTag)c.getTag("SourceFileTag");
            sourceFile = sft.getSourceFile();
        }
        String classType = SootToDexUtils.getDexTypeDescriptor(c.getType());
        int accessFlags = c.getModifiers();
        String superClass = c.hasSuperclass() ? SootToDexUtils.getDexTypeDescriptor(c.getSuperclass().getType()) : null;
        ArrayList<String> interfaces = null;
        if (!c.getInterfaces().isEmpty()) {
            interfaces = new ArrayList<String>();
            for (SootClass ifc : c.getInterfaces()) {
                interfaces.add(SootToDexUtils.getDexTypeDescriptor(ifc.getType()));
            }
        }
        ArrayList<BuilderField> fields = null;
        if (!c.getFields().isEmpty()) {
            fields = new ArrayList<BuilderField>();
            for (SootField f : c.getFields()) {
                EncodedValue staticInit = null;
                for (Tag t : f.getTags()) {
                    if (!(t instanceof ConstantValueTag)) continue;
                    if (staticInit != null) {
                        G.v().out.println("warning: more than one constant tag for field: " + f + ": " + t);
                        continue;
                    }
                    staticInit = this.makeConstantItem(f, t);
                }
                if (staticInit == null) {
                    staticInit = BuilderEncodedValues.defaultValueForType(SootToDexUtils.getDexTypeDescriptor(f.getType()));
                }
                Set<Annotation> fieldAnnotations = this.buildFieldAnnotations(f);
                BuilderField field2 = dexFile.internField(classType, f.getName(), SootToDexUtils.getDexTypeDescriptor(f.getType()), f.getModifiers(), staticInit, fieldAnnotations);
                fields.add(field2);
            }
        }
        dexFile.internClassDef(classType, accessFlags, superClass, interfaces, sourceFile, this.buildClassAnnotations(c), fields, this.toMethods(c));
    }

    private Set<Annotation> buildClassAnnotations(SootClass c) {
        Object memberClassesItem;
        List<Annotation> innerClassItem;
        InnerClassAttribute icTag;
        HashSet<String> skipList = new HashSet<String>();
        Set<Annotation> annotations = this.buildCommonAnnotations(c, skipList);
        if (c.hasTag("EnclosingMethodTag")) {
            EnclosingMethodTag eMethTag = (EnclosingMethodTag)c.getTag("EnclosingMethodTag");
            Annotation enclosingMethodItem = this.buildEnclosingMethodTag(eMethTag, skipList);
            if (enclosingMethodItem != null) {
                annotations.add(enclosingMethodItem);
            }
        } else if (c.hasOuterClass() && skipList.add("Ldalvik/annotation/EnclosingClass;")) {
            ImmutableAnnotationElement enclosingElement = new ImmutableAnnotationElement("value", new ImmutableTypeEncodedValue(SootToDexUtils.getDexClassName(c.getOuterClass().getName())));
            annotations.add(new ImmutableAnnotation(2, "Ldalvik/annotation/EnclosingClass;", Collections.singleton(enclosingElement)));
        }
        if (c.hasOuterClass() && (icTag = (InnerClassAttribute)c.getOuterClass().getTag("InnerClassAttribute")) != null && (innerClassItem = this.buildInnerClassAttribute(c, icTag, skipList)) != null) {
            annotations.addAll(innerClassItem);
        }
        if ((icTag = (InnerClassAttribute)c.getTag("InnerClassAttribute")) != null && (memberClassesItem = this.buildMemberClassesAttribute(c, icTag, skipList)) != null) {
            annotations.addAll((Collection<Annotation>)memberClassesItem);
        }
        for (Tag tag : c.getTags()) {
            if (!tag.getName().equals("VisibilityAnnotationTag")) continue;
            List<ImmutableAnnotation> visibilityItems = this.buildVisibilityAnnotationTag((VisibilityAnnotationTag)tag, skipList);
            annotations.addAll(visibilityItems);
        }
        ArrayList<AnnotationElem> defaults = new ArrayList<AnnotationElem>();
        for (SootMethod method : c.getMethods()) {
            AnnotationDefaultTag tag = (AnnotationDefaultTag)method.getTag("AnnotationDefaultTag");
            if (tag == null) continue;
            tag.getDefaultVal().setName(method.getName());
            defaults.add(tag.getDefaultVal());
        }
        if (defaults.size() > 0) {
            VisibilityAnnotationTag visibilityAnnotationTag = new VisibilityAnnotationTag(1);
            AnnotationTag a2 = new AnnotationTag("Ldalvik/annotation/AnnotationDefault;");
            visibilityAnnotationTag.addAnnotation(a2);
            AnnotationTag at = new AnnotationTag(SootToDexUtils.getDexClassName(c.getName()));
            AnnotationAnnotationElem ae = new AnnotationAnnotationElem(at, '@', "value");
            a2.addElem(ae);
            for (AnnotationElem aelem : defaults) {
                at.addElem(aelem);
            }
            List<ImmutableAnnotation> visibilityItems = this.buildVisibilityAnnotationTag(visibilityAnnotationTag, skipList);
            annotations.addAll(visibilityItems);
        }
        return annotations;
    }

    private Set<Annotation> buildFieldAnnotations(SootField f) {
        HashSet<String> skipList = new HashSet<String>();
        Set<Annotation> annotations = this.buildCommonAnnotations(f, skipList);
        for (Tag t : f.getTags()) {
            if (!t.getName().equals("VisibilityAnnotationTag")) continue;
            List<ImmutableAnnotation> visibilityItems = this.buildVisibilityAnnotationTag((VisibilityAnnotationTag)t, skipList);
            annotations.addAll(visibilityItems);
        }
        return annotations;
    }

    private Set<Annotation> buildMethodAnnotations(SootMethod m) {
        HashSet<String> skipList = new HashSet<String>();
        Set<Annotation> annotations = this.buildCommonAnnotations(m, skipList);
        for (Tag t : m.getTags()) {
            if (!t.getName().equals("VisibilityAnnotationTag")) continue;
            List<ImmutableAnnotation> visibilityItems = this.buildVisibilityAnnotationTag((VisibilityAnnotationTag)t, skipList);
            annotations.addAll(visibilityItems);
        }
        return annotations;
    }

    private Set<Annotation> buildMethodParameterAnnotations(SootMethod m, int paramIdx) {
        HashSet<String> skipList = new HashSet<String>();
        Set<Annotation> annotations = this.buildCommonAnnotations(m, skipList);
        for (Tag t : m.getTags()) {
            if (!t.getName().equals("VisibilityParameterAnnotationTag")) continue;
            VisibilityParameterAnnotationTag vat = (VisibilityParameterAnnotationTag)t;
            List<ImmutableAnnotation> visibilityItems = this.buildVisibilityParameterAnnotationTag(vat, skipList, paramIdx);
            annotations.addAll(visibilityItems);
        }
        return annotations;
    }

    private Set<Annotation> buildCommonAnnotations(AbstractHost host, Set<String> skipList) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        if (host.hasTag("DeprecatedTag") && !skipList.contains("Ljava/lang/Deprecated;")) {
            ImmutableAnnotation ann = new ImmutableAnnotation(1, "Ljava/lang/Deprecated;", Collections.emptySet());
            annotations.add(ann);
            skipList.add("Ljava/lang/Deprecated;");
        }
        if (host.hasTag("SignatureTag") && !skipList.contains("Ldalvik/annotation/Signature;")) {
            SignatureTag tag = (SignatureTag)host.getTag("SignatureTag");
            List<String> splitSignature = SootToDexUtils.splitSignature(tag.getSignature());
            HashSet<ImmutableAnnotationElement> elements = null;
            if (splitSignature != null && splitSignature.size() > 0) {
                elements = new HashSet<ImmutableAnnotationElement>();
                ArrayList<ImmutableStringEncodedValue> valueList = new ArrayList<ImmutableStringEncodedValue>();
                for (String s2 : splitSignature) {
                    ImmutableStringEncodedValue val = new ImmutableStringEncodedValue(s2);
                    valueList.add(val);
                }
                ImmutableArrayEncodedValue valueValue = new ImmutableArrayEncodedValue(valueList);
                ImmutableAnnotationElement valueElement = new ImmutableAnnotationElement("value", valueValue);
                elements.add(valueElement);
            } else {
                G.v().out.println("Signature annotation without value detected");
            }
            ImmutableAnnotation ann = new ImmutableAnnotation(2, "Ldalvik/annotation/Signature;", elements);
            annotations.add(ann);
            skipList.add("Ldalvik/annotation/Signature;");
        }
        return annotations;
    }

    private List<ImmutableAnnotation> buildVisibilityAnnotationTag(VisibilityAnnotationTag t, Set<String> skipList) {
        if (t.getAnnotations() == null) {
            return Collections.emptyList();
        }
        ArrayList<ImmutableAnnotation> annotations = new ArrayList<ImmutableAnnotation>();
        for (AnnotationTag at : t.getAnnotations()) {
            String type = at.getType();
            if (!skipList.add(type)) continue;
            HashSet<String> alreadyWritten = new HashSet<String>();
            ArrayList<ImmutableAnnotationElement> elements = null;
            if (!at.getElems().isEmpty()) {
                elements = new ArrayList<ImmutableAnnotationElement>();
                for (AnnotationElem ae : at.getElems()) {
                    if (ae.getName() == null || ae.getName().isEmpty()) {
                        throw new RuntimeException("Null or empty annotation name encountered");
                    }
                    if (!alreadyWritten.add(ae.getName())) {
                        throw new RuntimeException("Duplicate annotation attribute: " + ae.getName());
                    }
                    EncodedValue value2 = this.buildEncodedValueForAnnotation(ae);
                    ImmutableAnnotationElement element2 = new ImmutableAnnotationElement(ae.getName(), value2);
                    elements.add(element2);
                }
            }
            String typeName = SootToDexUtils.getDexClassName(at.getType());
            ImmutableAnnotation ann = new ImmutableAnnotation(DexPrinter.getVisibility(t.getVisibility()), typeName, elements);
            annotations.add(ann);
        }
        return annotations;
    }

    private List<ImmutableAnnotation> buildVisibilityParameterAnnotationTag(VisibilityParameterAnnotationTag t, Set<String> skipList, int paramIdx) {
        if (t.getVisibilityAnnotations() == null) {
            return Collections.emptyList();
        }
        int paramTagIdx = 0;
        ArrayList<ImmutableAnnotation> annotations = new ArrayList<ImmutableAnnotation>();
        for (VisibilityAnnotationTag vat : t.getVisibilityAnnotations()) {
            if (paramTagIdx == paramIdx && vat != null && vat.getAnnotations() != null) {
                for (AnnotationTag at : vat.getAnnotations()) {
                    String type = at.getType();
                    if (!skipList.add(type)) continue;
                    HashSet<String> alreadyWritten = new HashSet<String>();
                    ArrayList<ImmutableAnnotationElement> elements = null;
                    if (!at.getElems().isEmpty()) {
                        elements = new ArrayList<ImmutableAnnotationElement>();
                        for (AnnotationElem ae : at.getElems()) {
                            if (ae.getName() == null || ae.getName().isEmpty()) {
                                throw new RuntimeException("Null or empty annotation name encountered");
                            }
                            if (!alreadyWritten.add(ae.getName())) {
                                throw new RuntimeException("Duplicate annotation attribute: " + ae.getName());
                            }
                            EncodedValue value2 = this.buildEncodedValueForAnnotation(ae);
                            ImmutableAnnotationElement element2 = new ImmutableAnnotationElement(ae.getName(), value2);
                            elements.add(element2);
                        }
                    }
                    ImmutableAnnotation ann = new ImmutableAnnotation(DexPrinter.getVisibility(vat.getVisibility()), SootToDexUtils.getDexClassName(at.getType()), elements);
                    annotations.add(ann);
                }
            }
            ++paramTagIdx;
        }
        return annotations;
    }

    private Annotation buildEnclosingMethodTag(EnclosingMethodTag t, Set<String> skipList) {
        if (!skipList.add("Ldalvik/annotation/EnclosingMethod;")) {
            return null;
        }
        if (t.getEnclosingMethod() == null) {
            return null;
        }
        String[] split1 = t.getEnclosingMethodSig().split("\\)");
        String parametersS = split1[0].replaceAll("\\(", "");
        String returnTypeS = split1[1];
        ArrayList<String> typeList = new ArrayList<String>();
        if (!parametersS.equals("")) {
            for (String p : Util.splitParameters(parametersS)) {
                if (p.isEmpty()) continue;
                typeList.add(p);
            }
        }
        ImmutableMethodReference mRef = new ImmutableMethodReference(SootToDexUtils.getDexClassName(t.getEnclosingClass()), t.getEnclosingMethod(), typeList, returnTypeS);
        ImmutableMethodEncodedValue methodRef = new ImmutableMethodEncodedValue(dexFile.internMethodReference(mRef));
        ImmutableAnnotationElement methodElement = new ImmutableAnnotationElement("value", methodRef);
        return new ImmutableAnnotation(2, "Ldalvik/annotation/EnclosingMethod;", Collections.singleton(methodElement));
    }

    private List<Annotation> buildInnerClassAttribute(SootClass parentClass, InnerClassAttribute t, Set<String> skipList) {
        if (t.getSpecs() == null) {
            return null;
        }
        ArrayList<ImmutableAnnotation> anns = null;
        for (Tag tag : t.getSpecs()) {
            InnerClassTag icTag = (InnerClassTag)tag;
            String outerClass = this.getOuterClassNameFromTag(icTag);
            String innerClass = icTag.getInnerClass().replaceAll("/", ".");
            if (!parentClass.hasOuterClass() || !innerClass.equals(parentClass.getName())) continue;
            if (parentClass.getName().equals(outerClass) && icTag.getOuterClass() == null) {
                outerClass = null;
            }
            if (parentClass.getName().equals(outerClass) || !skipList.add("Ldalvik/annotation/InnerClass;")) continue;
            ArrayList<ImmutableAnnotationElement> elements = new ArrayList<ImmutableAnnotationElement>();
            ImmutableAnnotationElement flagsElement = new ImmutableAnnotationElement("accessFlags", new ImmutableIntEncodedValue(icTag.getAccessFlags()));
            elements.add(flagsElement);
            ImmutableEncodedValue nameValue = icTag.getShortName() != null && !icTag.getShortName().isEmpty() ? new ImmutableStringEncodedValue(icTag.getShortName()) : ImmutableNullEncodedValue.INSTANCE;
            ImmutableAnnotationElement nameElement = new ImmutableAnnotationElement("name", nameValue);
            elements.add(nameElement);
            if (anns == null) {
                anns = new ArrayList<ImmutableAnnotation>();
            }
            anns.add(new ImmutableAnnotation(2, "Ldalvik/annotation/InnerClass;", elements));
        }
        return anns;
    }

    private String getOuterClassNameFromTag(InnerClassTag icTag) {
        String outerClass = icTag.getOuterClass() == null ? icTag.getInnerClass().replaceAll("\\$[0-9,a-z,A-Z]*$", "").replaceAll("/", ".") : icTag.getOuterClass().replaceAll("/", ".");
        return outerClass;
    }

    private List<Annotation> buildMemberClassesAttribute(SootClass parentClass, InnerClassAttribute t, Set<String> skipList) {
        ArrayList<ImmutableAnnotation> anns = null;
        HashSet<String> memberClasses = null;
        for (Tag tag : t.getSpecs()) {
            InnerClassTag icTag = (InnerClassTag)tag;
            String outerClass = this.getOuterClassNameFromTag(icTag);
            if (icTag.getOuterClass() == null || !parentClass.getName().equals(outerClass)) continue;
            if (memberClasses == null) {
                memberClasses = new HashSet<String>();
            }
            memberClasses.add(SootToDexUtils.getDexClassName(icTag.getInnerClass()));
        }
        if (memberClasses != null && !memberClasses.isEmpty() && skipList.add("Ldalvik/annotation/MemberClasses;")) {
            ArrayList<ImmutableTypeEncodedValue> classes = new ArrayList<ImmutableTypeEncodedValue>();
            for (String memberClass : memberClasses) {
                ImmutableTypeEncodedValue classValue = new ImmutableTypeEncodedValue(memberClass);
                classes.add(classValue);
            }
            ImmutableArrayEncodedValue immutableArrayEncodedValue = new ImmutableArrayEncodedValue(classes);
            ImmutableAnnotationElement element2 = new ImmutableAnnotationElement("value", immutableArrayEncodedValue);
            ImmutableAnnotation memberAnnotation = new ImmutableAnnotation(2, "Ldalvik/annotation/MemberClasses;", Collections.singletonList(element2));
            if (anns == null) {
                anns = new ArrayList<ImmutableAnnotation>();
            }
            anns.add(memberAnnotation);
        }
        return anns;
    }

    private static int getVisibility(int visibility) {
        if (visibility == 0) {
            return 1;
        }
        if (visibility == 1) {
            return 2;
        }
        if (visibility == 2) {
            return 0;
        }
        throw new RuntimeException("Unknown annotation visibility: '" + visibility + "'");
    }

    private Collection<BuilderMethod> toMethods(SootClass clazz) {
        if (clazz.getMethods().isEmpty()) {
            return null;
        }
        String classType = SootToDexUtils.getDexTypeDescriptor(clazz.getType());
        ArrayList<BuilderMethod> methods = new ArrayList<BuilderMethod>();
        for (SootMethod sm : clazz.getMethods()) {
            if (sm.isPhantom()) continue;
            MethodImplementation impl = this.toMethodImplementation(sm);
            ArrayList<String> parameterNames = null;
            if (sm.hasTag("ParamNamesTag")) {
                parameterNames = ((ParamNamesTag)sm.getTag("ParamNamesTag")).getNames();
            }
            int paramIdx = 0;
            ArrayList<ImmutableMethodParameter> parameters = null;
            if (sm.getParameterCount() > 0) {
                parameters = new ArrayList<ImmutableMethodParameter>();
                for (Type tp : sm.getParameterTypes()) {
                    String paramType = SootToDexUtils.getDexTypeDescriptor(tp);
                    parameters.add(new ImmutableMethodParameter(paramType, this.buildMethodParameterAnnotations(sm, paramIdx), sm.isConcrete() && parameterNames != null ? (String)parameterNames.get(paramIdx) : null));
                    ++paramIdx;
                }
            }
            String returnType = SootToDexUtils.getDexTypeDescriptor(sm.getReturnType());
            int accessFlags = SootToDexUtils.getDexAccessFlags(sm);
            BuilderMethod meth = dexFile.internMethod(classType, sm.getName(), parameters, returnType, accessFlags, this.buildMethodAnnotations(sm), impl);
            methods.add(meth);
        }
        return methods;
    }

    protected static BuilderFieldReference toFieldReference(SootField f, DexBuilder belongingDexFile) {
        ImmutableFieldReference fieldRef = new ImmutableFieldReference(SootToDexUtils.getDexClassName(f.getDeclaringClass().getName()), f.getName(), SootToDexUtils.getDexTypeDescriptor(f.getType()));
        return belongingDexFile.internFieldReference(fieldRef);
    }

    protected static BuilderMethodReference toMethodReference(SootMethodRef m, DexBuilder belongingDexFile) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Type t : m.parameterTypes()) {
            parameters.add(SootToDexUtils.getDexTypeDescriptor(t));
        }
        ImmutableMethodReference methodRef = new ImmutableMethodReference(SootToDexUtils.getDexClassName(m.declaringClass().getName()), m.name(), parameters, SootToDexUtils.getDexTypeDescriptor(m.returnType()));
        return belongingDexFile.internMethodReference(methodRef);
    }

    protected static BuilderTypeReference toTypeReference(Type t, DexBuilder belongingDexFile) {
        return belongingDexFile.internTypeReference(SootToDexUtils.getDexTypeDescriptor(t));
    }

    private MethodImplementation toMethodImplementation(SootMethod m) {
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        Body activeBody = m.retrieveActiveBody();
        if ((m.getName().contains("<") || m.getName().equals(">")) && !m.getName().equals("<init>") && !m.getName().equals("<clinit>")) {
            throw new RuntimeException("Invalid method name: " + m.getName());
        }
        EmptySwitchEliminator.v().transform(activeBody);
        SynchronizedMethodTransformer.v().transform(activeBody);
        FastDexTrapTightener.v().transform(activeBody);
        TrapSplitter.v().transform(activeBody);
        int inWords = SootToDexUtils.getDexWords(m.getParameterTypes());
        if (!m.isStatic()) {
            ++inWords;
        }
        PatchingChain<Unit> units = activeBody.getUnits();
        StmtVisitor stmtV = new StmtVisitor(m, dexFile);
        this.toInstructions(units, stmtV);
        int registerCount = stmtV.getRegisterCount();
        if (inWords > registerCount) {
            registerCount = inWords;
        }
        MethodImplementationBuilder builder = new MethodImplementationBuilder(registerCount);
        LabelAssigner labelAssinger = new LabelAssigner(builder);
        List<BuilderInstruction> instructions = stmtV.getRealInsns(labelAssinger);
        this.fixLongJumps(instructions, labelAssinger, stmtV);
        HashMap<Local, Integer> seenRegisters = new HashMap<Local, Integer>();
        Map<Instruction, LocalRegisterAssignmentInformation> instructionRegisterMap = stmtV.getInstructionRegisterMap();
        for (LocalRegisterAssignmentInformation assignment : stmtV.getParameterInstructionsList()) {
            if (assignment.getLocal().getName().equals("this")) continue;
            this.addRegisterAssignmentDebugInfo(assignment, seenRegisters, builder);
        }
        for (BuilderInstruction ins : instructions) {
            Stmt origStmt = stmtV.getStmtForInstruction(ins);
            if (stmtV.getInstructionPayloadMap().containsKey(ins)) {
                builder.addLabel(labelAssinger.getLabelName(stmtV.getInstructionPayloadMap().get(ins)));
            }
            if (origStmt != null) {
                String labelName;
                for (Trap t : m.getActiveBody().getTraps()) {
                    if (t.getBeginUnit() != origStmt && t.getEndUnit() != origStmt && t.getHandlerUnit() != origStmt) continue;
                    labelAssinger.getOrCreateLabel(origStmt);
                    break;
                }
                if ((labelName = labelAssinger.getLabelName(origStmt)) != null && !builder.getLabel(labelName).isPlaced()) {
                    builder.addLabel(labelName);
                }
                if (stmtV.getStmtForInstruction(ins) != null) {
                    List<Tag> tags2 = origStmt.getTags();
                    for (Tag t : tags2) {
                        if (t instanceof LineNumberTag) {
                            LineNumberTag lnt = (LineNumberTag)t;
                            builder.addLineNumber(lnt.getLineNumber());
                            continue;
                        }
                        if (!(t instanceof SourceFileTag)) continue;
                        SourceFileTag sft = (SourceFileTag)t;
                        builder.addSetSourceFile(dexFile.internStringReference(sft.getSourceFile()));
                    }
                }
            }
            builder.addInstruction(ins);
            LocalRegisterAssignmentInformation registerAssignmentTag = instructionRegisterMap.get(ins);
            if (registerAssignmentTag == null) continue;
            this.addRegisterAssignmentDebugInfo(registerAssignmentTag, seenRegisters, builder);
        }
        Iterator<Object> iterator2 = seenRegisters.values().iterator();
        while (iterator2.hasNext()) {
            int registersLeft = (Integer)iterator2.next();
            builder.addEndLocal(registersLeft);
        }
        this.toTries(activeBody.getTraps(), stmtV, builder, labelAssinger);
        for (Label lbl : labelAssinger.getAllLabels()) {
            if (lbl.isPlaced()) continue;
            throw new RuntimeException("Label not placed: " + lbl);
        }
        return builder.getMethodImplementation();
    }

    private void fixLongJumps(List<BuilderInstruction> instructions, LabelAssigner labelAssigner, StmtVisitor stmtV) {
        boolean hasChanged = true;
        block0: while (hasChanged) {
            hasChanged = false;
            HashMap<Label, Integer> labelToInsOffset = new HashMap<Label, Integer>();
            for (int i = 0; i < instructions.size(); ++i) {
                Label lbl;
                BuilderInstruction bi = instructions.get(i);
                Stmt origStmt = stmtV.getStmtForInstruction(bi);
                if (origStmt == null || (lbl = labelAssigner.getLabelUnsafe(origStmt)) == null) continue;
                labelToInsOffset.put(lbl, i);
            }
            for (int j = 0; j < instructions.size(); ++j) {
                Insn jumpInsn;
                BuilderOffsetInstruction boj;
                Label targetLbl;
                Integer offset;
                BuilderInstruction bj = instructions.get(j);
                if (!(bj instanceof BuilderOffsetInstruction) || (offset = (Integer)labelToInsOffset.get(targetLbl = (boj = (BuilderOffsetInstruction)bj).getTarget())) == null || !((jumpInsn = stmtV.getInsnForInstruction(boj)) instanceof InsnWithOffset)) continue;
                InsnWithOffset offsetInsn = (InsnWithOffset)jumpInsn;
                int distance = this.getDistanceBetween(instructions, j, offset);
                if (Math.abs(distance) <= offsetInsn.getMaxJumpOffset()) continue;
                this.insertIntermediateJump(offset, j, stmtV, instructions, labelAssigner);
                hasChanged = true;
                continue block0;
            }
        }
    }

    private void insertIntermediateJump(int targetInsPos, int jumpInsPos, StmtVisitor stmtV, List<BuilderInstruction> instructions, LabelAssigner labelAssigner) {
        BuilderInstruction originalJumpInstruction = instructions.get(jumpInsPos);
        Insn originalJumpInsn = stmtV.getInsnForInstruction(originalJumpInstruction);
        if (originalJumpInsn == null) {
            return;
        }
        if (!(originalJumpInsn instanceof InsnWithOffset)) {
            throw new RuntimeException("Unexpected jump instruction target");
        }
        InsnWithOffset offsetInsn = (InsnWithOffset)originalJumpInsn;
        int distance = Math.max(targetInsPos, jumpInsPos) - Math.min(targetInsPos, jumpInsPos);
        if (distance == 0) {
            return;
        }
        int newJumpIdx = Math.min(targetInsPos, jumpInsPos) + distance / 2;
        int sign = (int)Math.signum(targetInsPos - jumpInsPos);
        if (distance > offsetInsn.getMaxJumpOffset()) {
            newJumpIdx = jumpInsPos + sign;
        }
        while (stmtV.getStmtForInstruction(instructions.get(newJumpIdx)) == null) {
            if ((newJumpIdx += sign) >= 0 && newJumpIdx < instructions.size()) continue;
            throw new RuntimeException("No position for inserting intermediate jump instruction found");
        }
        NopStmt nop = Jimple.v().newNopStmt();
        Insn30t newJump = new Insn30t(Opcode.GOTO_32);
        newJump.setTarget(stmtV.getStmtForInstruction(instructions.get(targetInsPos)));
        BuilderInstruction newJumpInstruction = newJump.getRealInsn(labelAssigner);
        instructions.add(newJumpIdx, newJumpInstruction);
        stmtV.fakeNewInsn(nop, newJump, newJumpInstruction);
        if (newJumpIdx < jumpInsPos) {
            ++jumpInsPos;
        }
        if (newJumpIdx < targetInsPos) {
            ++targetInsPos;
        }
        offsetInsn.setTarget(nop);
        BuilderInstruction replacementJumpInstruction = offsetInsn.getRealInsn(labelAssigner);
        instructions.add(jumpInsPos, replacementJumpInstruction);
        instructions.remove(originalJumpInstruction);
        stmtV.fakeNewInsn(stmtV.getStmtForInstruction(originalJumpInstruction), originalJumpInsn, replacementJumpInstruction);
        Stmt afterNewJump = stmtV.getStmtForInstruction(instructions.get(newJumpIdx + 1));
        Insn10t jumpAround = new Insn10t(Opcode.GOTO);
        jumpAround.setTarget(afterNewJump);
        BuilderInstruction jumpAroundInstruction = jumpAround.getRealInsn(labelAssigner);
        instructions.add(newJumpIdx, jumpAroundInstruction);
    }

    private int getDistanceBetween(List<BuilderInstruction> instructions, int i, int j) {
        if (i == j) {
            return 0;
        }
        int dist = 0;
        for (int idx = Math.min(i, j); idx < Math.max(i, j); ++idx) {
            BuilderInstruction bi = instructions.get(idx);
            dist += bi.getFormat().size / 2;
        }
        return dist;
    }

    private void addRegisterAssignmentDebugInfo(LocalRegisterAssignmentInformation registerAssignment, Map<Local, Integer> seenRegisters, MethodImplementationBuilder builder) {
        Local local = registerAssignment.getLocal();
        String dexLocalType = SootToDexUtils.getDexTypeDescriptor(local.getType());
        BuilderStringReference localName = dexFile.internStringReference(local.getName());
        Register reg = registerAssignment.getRegister();
        int register2 = reg.getNumber();
        Integer beforeRegister = seenRegisters.get(local);
        if (beforeRegister != null) {
            if (beforeRegister == register2) {
                return;
            }
            builder.addEndLocal(beforeRegister);
        }
        builder.addStartLocal(register2, localName, dexFile.internTypeReference(dexLocalType), dexFile.internStringReference(""));
        seenRegisters.put(local, register2);
    }

    private void toInstructions(Collection<Unit> units, StmtVisitor stmtV) {
        for (Unit u : units) {
            stmtV.beginNewStmt((Stmt)u);
            u.apply(stmtV);
        }
        stmtV.finalizeInstructions();
    }

    private void toTries(Collection<Trap> traps, StmtVisitor stmtV, MethodImplementationBuilder builder, LabelAssigner labelAssigner) {
        HashMap codeRangesToTryItem = new HashMap();
        for (Trap t : traps) {
            Stmt beginStmt = (Stmt)t.getBeginUnit();
            Stmt endStmt = (Stmt)t.getEndUnit();
            int startCodeAddress = labelAssigner.getLabel(beginStmt).getCodeAddress();
            int endCodeAddress = labelAssigner.getLabel(endStmt).getCodeAddress();
            String exceptionType = SootToDexUtils.getDexTypeDescriptor(t.getException().getType());
            ImmutableExceptionHandler exceptionHandler = new ImmutableExceptionHandler(exceptionType, labelAssigner.getLabel((Stmt)t.getHandlerUnit()).getCodeAddress());
            ArrayList<ImmutableExceptionHandler> newHandlers = new ArrayList<ImmutableExceptionHandler>();
            CodeRange range2 = new CodeRange(startCodeAddress, endCodeAddress);
            for (CodeRange r : codeRangesToTryItem.keySet()) {
                List oldHandlers;
                if (r.containsRange(range2)) {
                    range2.startAddress = r.startAddress;
                    range2.endAddress = r.endAddress;
                    oldHandlers = (List)codeRangesToTryItem.get(r);
                    if (oldHandlers == null) break;
                    newHandlers.addAll(oldHandlers);
                    break;
                }
                if (!range2.containsRange(r)) continue;
                range2.startAddress = r.startAddress;
                range2.endAddress = r.endAddress;
                oldHandlers = (List)codeRangesToTryItem.get(range2);
                if (oldHandlers != null) {
                    newHandlers.addAll(oldHandlers);
                }
                codeRangesToTryItem.remove(r);
                break;
            }
            if (!newHandlers.contains(exceptionHandler)) {
                newHandlers.add(exceptionHandler);
            }
            codeRangesToTryItem.put(range2, newHandlers);
        }
        for (CodeRange range3 : codeRangesToTryItem.keySet()) {
            for (ExceptionHandler handler : (List)codeRangesToTryItem.get(range3)) {
                builder.addCatch(dexFile.internTypeReference(handler.getExceptionType()), labelAssigner.getLabelAtAddress(range3.startAddress), labelAssigner.getLabelAtAddress(range3.endAddress), labelAssigner.getLabelAtAddress(handler.getHandlerCodeAddress()));
            }
        }
    }

    public void add(SootClass c) {
        if (c.isPhantom()) {
            return;
        }
        this.addAsClassDefItem(c);
        Map<String, File> dexClassIndex = SourceLocator.v().dexClassIndex();
        if (dexClassIndex == null) {
            return;
        }
        File sourceForClass = dexClassIndex.get(c.getName());
        if (sourceForClass == null || sourceForClass.getName().endsWith(".dex")) {
            return;
        }
        if (this.originalApk != null && !this.originalApk.equals(sourceForClass)) {
            throw new CompilationDeathException("multiple APKs as source of an application are not supported");
        }
        this.originalApk = sourceForClass;
    }

    public void print() {
        String outputDir = SourceLocator.v().getOutputDir();
        try {
            if (this.originalApk != null && Options.v().output_format() != 11) {
                this.printApk(outputDir, this.originalApk);
            } else {
                String fileName = outputDir + File.separatorChar + CLASSES_DEX;
                G.v().out.println("Writing dex to: " + fileName);
                this.writeTo(fileName);
            }
        }
        catch (IOException e) {
            throw new CompilationDeathException("I/O exception while printing dex", e);
        }
    }

    private static class CodeRange {
        int startAddress;
        int endAddress;

        public CodeRange(int startAddress, int endAddress) {
            this.startAddress = startAddress;
            this.endAddress = endAddress;
        }

        public boolean containsRange(CodeRange r) {
            return r.startAddress >= this.startAddress && r.endAddress <= this.endAddress;
        }

        public String toString() {
            return this.startAddress + "-" + this.endAddress;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null && !(other instanceof CodeRange)) {
                return false;
            }
            CodeRange cr = (CodeRange)other;
            return this.startAddress == cr.startAddress && this.endAddress == cr.endAddress;
        }

        public int hashCode() {
            return 17 * this.startAddress + 13 * this.endAddress;
        }
    }
}

