/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.integer;

import soot.ArrayType;
import soot.IntegerType;
import soot.Local;
import soot.NullType;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConcreteRef;
import soot.jimple.ConditionExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.typing.integer.TypeResolver;
import soot.jimple.toolkits.typing.integer.TypeVariable;

class ConstraintCollector
extends AbstractStmtSwitch {
    private TypeResolver resolver;
    private boolean uses;
    private JimpleBody stmtBody;

    public ConstraintCollector(TypeResolver resolver, boolean uses) {
        this.resolver = resolver;
        this.uses = uses;
    }

    public void collect(Stmt stmt, JimpleBody stmtBody) {
        this.stmtBody = stmtBody;
        stmt.apply(this);
    }

    private void handleInvokeExpr(InvokeExpr ie) {
        if (!this.uses) {
            return;
        }
        SootMethodRef method = ie.getMethodRef();
        for (int i = 0; i < ie.getArgCount(); ++i) {
            Local local;
            if (!(ie.getArg(i) instanceof Local) || !((local = (Local)ie.getArg(i)).getType() instanceof IntegerType)) continue;
            TypeVariable localType = this.resolver.typeVariable(local);
            localType.addParent(this.resolver.typeVariable(method.parameterType(i)));
        }
        if (ie instanceof DynamicInvokeExpr) {
            DynamicInvokeExpr die = (DynamicInvokeExpr)ie;
            SootMethodRef bootstrapMethod = die.getBootstrapMethodRef();
            for (int i = 0; i < die.getBootstrapArgCount(); ++i) {
                Local local;
                if (!(die.getBootstrapArg(i) instanceof Local) || !((local = (Local)die.getBootstrapArg(i)).getType() instanceof IntegerType)) continue;
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(bootstrapMethod.parameterType(i)));
            }
        }
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        Type fieldType;
        Type baset;
        ConcreteRef ref;
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        TypeVariable left = null;
        TypeVariable right = null;
        if (l instanceof ArrayRef) {
            ref = (ArrayRef)l;
            baset = ((Local)ref.getBase()).getType();
            if (baset instanceof ArrayType) {
                ArrayType base = (ArrayType)baset;
                Value index = ref.getIndex();
                if (this.uses) {
                    if (base.numDimensions == 1 && base.baseType instanceof IntegerType) {
                        left = this.resolver.typeVariable(base.baseType);
                    }
                    if (index instanceof Local) {
                        this.resolver.typeVariable((Local)index).addParent(this.resolver.INT);
                    }
                }
            }
        } else if (l instanceof Local) {
            if (((Local)l).getType() instanceof IntegerType) {
                left = this.resolver.typeVariable((Local)l);
            }
        } else if (l instanceof InstanceFieldRef) {
            if (this.uses && (fieldType = (ref = (InstanceFieldRef)l).getFieldRef().type()) instanceof IntegerType) {
                left = this.resolver.typeVariable(ref.getFieldRef().type());
            }
        } else {
            if (!(l instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment left hand side type: " + l.getClass());
            if (this.uses && (fieldType = ((StaticFieldRef)(ref = (StaticFieldRef)l)).getFieldRef().type()) instanceof IntegerType) {
                left = this.resolver.typeVariable(((StaticFieldRef)ref).getFieldRef().type());
            }
        }
        if (r instanceof ArrayRef) {
            ref = (ArrayRef)r;
            baset = ((Local)ref.getBase()).getType();
            if (!(baset instanceof NullType)) {
                Value index = ref.getIndex();
                if (baset instanceof ArrayType) {
                    ArrayType base = (ArrayType)baset;
                    if (base.numDimensions == 1 && base.baseType instanceof IntegerType) {
                        right = this.resolver.typeVariable(base.baseType);
                    }
                } else if (baset instanceof IntegerType) {
                    right = this.resolver.typeVariable(baset);
                }
                if (this.uses && index instanceof Local) {
                    this.resolver.typeVariable((Local)index).addParent(this.resolver.INT);
                }
            }
        } else if (!(r instanceof DoubleConstant) && !(r instanceof FloatConstant)) {
            if (r instanceof IntConstant) {
                int value2 = ((IntConstant)r).value;
                right = value2 < Short.MIN_VALUE ? this.resolver.INT : (value2 < -128 ? this.resolver.SHORT : (value2 < 0 ? this.resolver.BYTE : (value2 < 2 ? this.resolver.R0_1 : (value2 < 128 ? this.resolver.R0_127 : (value2 < 32768 ? this.resolver.R0_32767 : (value2 < 65536 ? this.resolver.CHAR : this.resolver.INT))))));
            } else if (!(r instanceof LongConstant || r instanceof NullConstant || r instanceof StringConstant || r instanceof ClassConstant)) {
                if (r instanceof BinopExpr) {
                    int value3;
                    BinopExpr be2 = (BinopExpr)r;
                    Value lv = be2.getOp1();
                    Value rv = be2.getOp2();
                    TypeVariable lop = null;
                    TypeVariable rop = null;
                    if (lv instanceof Local) {
                        if (((Local)lv).getType() instanceof IntegerType) {
                            lop = this.resolver.typeVariable((Local)lv);
                        }
                    } else if (!(lv instanceof DoubleConstant) && !(lv instanceof FloatConstant)) {
                        if (lv instanceof IntConstant) {
                            value3 = ((IntConstant)lv).value;
                            lop = value3 < Short.MIN_VALUE ? this.resolver.INT : (value3 < -128 ? this.resolver.SHORT : (value3 < 0 ? this.resolver.BYTE : (value3 < 2 ? this.resolver.R0_1 : (value3 < 128 ? this.resolver.R0_127 : (value3 < 32768 ? this.resolver.R0_32767 : (value3 < 65536 ? this.resolver.CHAR : this.resolver.INT))))));
                        } else if (!(lv instanceof LongConstant || lv instanceof NullConstant || lv instanceof StringConstant || lv instanceof ClassConstant)) {
                            throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
                        }
                    }
                    if (rv instanceof Local) {
                        if (((Local)rv).getType() instanceof IntegerType) {
                            rop = this.resolver.typeVariable((Local)rv);
                        }
                    } else if (!(rv instanceof DoubleConstant) && !(rv instanceof FloatConstant)) {
                        if (rv instanceof IntConstant) {
                            value3 = ((IntConstant)rv).value;
                            rop = value3 < Short.MIN_VALUE ? this.resolver.INT : (value3 < -128 ? this.resolver.SHORT : (value3 < 0 ? this.resolver.BYTE : (value3 < 2 ? this.resolver.R0_1 : (value3 < 128 ? this.resolver.R0_127 : (value3 < 32768 ? this.resolver.R0_32767 : (value3 < 65536 ? this.resolver.CHAR : this.resolver.INT))))));
                        } else if (!(rv instanceof LongConstant || rv instanceof NullConstant || rv instanceof StringConstant || rv instanceof ClassConstant)) {
                            throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
                        }
                    }
                    if (be2 instanceof AddExpr || be2 instanceof SubExpr || be2 instanceof DivExpr || be2 instanceof RemExpr || be2 instanceof MulExpr) {
                        if (lop != null && rop != null) {
                            if (this.uses) {
                                if (lop.type() == null) {
                                    lop.addParent(this.resolver.INT);
                                }
                                if (rop.type() == null) {
                                    rop.addParent(this.resolver.INT);
                                }
                            }
                            right = this.resolver.INT;
                        }
                    } else if (be2 instanceof AndExpr || be2 instanceof OrExpr || be2 instanceof XorExpr) {
                        if (lop != null && rop != null) {
                            TypeVariable common = this.resolver.typeVariable();
                            if (rop != null) {
                                rop.addParent(common);
                            }
                            if (lop != null) {
                                lop.addParent(common);
                            }
                            right = common;
                        }
                    } else if (be2 instanceof ShlExpr) {
                        if (this.uses) {
                            if (lop != null && lop.type() == null) {
                                lop.addParent(this.resolver.INT);
                            }
                            if (rop.type() == null) {
                                rop.addParent(this.resolver.INT);
                            }
                        }
                        right = lop == null ? null : this.resolver.INT;
                    } else if (be2 instanceof ShrExpr || be2 instanceof UshrExpr) {
                        if (this.uses) {
                            if (lop != null && lop.type() == null) {
                                lop.addParent(this.resolver.INT);
                            }
                            if (rop.type() == null) {
                                rop.addParent(this.resolver.INT);
                            }
                        }
                        right = lop;
                    } else if (be2 instanceof CmpExpr || be2 instanceof CmpgExpr || be2 instanceof CmplExpr) {
                        right = this.resolver.BYTE;
                    } else {
                        if (!(be2 instanceof EqExpr) && !(be2 instanceof GeExpr) && !(be2 instanceof GtExpr) && !(be2 instanceof LeExpr) && !(be2 instanceof LtExpr) && !(be2 instanceof NeExpr)) throw new RuntimeException("Unhandled binary expression type: " + be2.getClass());
                        if (this.uses) {
                            TypeVariable common = this.resolver.typeVariable();
                            if (rop != null) {
                                rop.addParent(common);
                            }
                            if (lop != null) {
                                lop.addParent(common);
                            }
                        }
                        right = this.resolver.BOOLEAN;
                    }
                } else if (r instanceof CastExpr) {
                    CastExpr ce = (CastExpr)r;
                    if (ce.getCastType() instanceof IntegerType) {
                        right = this.resolver.typeVariable(ce.getCastType());
                    }
                } else if (r instanceof InstanceOfExpr) {
                    right = this.resolver.BOOLEAN;
                } else if (r instanceof InvokeExpr) {
                    InvokeExpr ie = (InvokeExpr)r;
                    this.handleInvokeExpr(ie);
                    if (ie.getMethodRef().returnType() instanceof IntegerType) {
                        right = this.resolver.typeVariable(ie.getMethodRef().returnType());
                    }
                } else if (r instanceof NewArrayExpr) {
                    Value size2;
                    NewArrayExpr nae = (NewArrayExpr)r;
                    if (this.uses && (size2 = nae.getSize()) instanceof Local) {
                        TypeVariable var = this.resolver.typeVariable((Local)size2);
                        var.addParent(this.resolver.INT);
                    }
                } else if (!(r instanceof NewExpr)) {
                    if (r instanceof NewMultiArrayExpr) {
                        NewMultiArrayExpr nmae = (NewMultiArrayExpr)r;
                        if (this.uses) {
                            for (int i = 0; i < nmae.getSizeCount(); ++i) {
                                Value size3 = nmae.getSize(i);
                                if (!(size3 instanceof Local)) continue;
                                TypeVariable var = this.resolver.typeVariable((Local)size3);
                                var.addParent(this.resolver.INT);
                            }
                        }
                    } else if (r instanceof LengthExpr) {
                        right = this.resolver.INT;
                    } else if (r instanceof NegExpr) {
                        NegExpr ne = (NegExpr)r;
                        if (ne.getOp() instanceof Local) {
                            Local local = (Local)ne.getOp();
                            if (local.getType() instanceof IntegerType) {
                                if (this.uses) {
                                    this.resolver.typeVariable(local).addParent(this.resolver.INT);
                                }
                                TypeVariable v = this.resolver.typeVariable();
                                v.addChild(this.resolver.BYTE);
                                v.addChild(this.resolver.typeVariable(local));
                                right = v;
                            }
                        } else if (!(ne.getOp() instanceof DoubleConstant) && !(ne.getOp() instanceof FloatConstant)) {
                            if (ne.getOp() instanceof IntConstant) {
                                int value4 = ((IntConstant)ne.getOp()).value;
                                right = value4 < Short.MIN_VALUE ? this.resolver.INT : (value4 < -128 ? this.resolver.SHORT : (value4 < 0 ? this.resolver.BYTE : (value4 < 2 ? this.resolver.BYTE : (value4 < 128 ? this.resolver.BYTE : (value4 < 32768 ? this.resolver.SHORT : (value4 < 65536 ? this.resolver.INT : this.resolver.INT))))));
                            } else if (!(ne.getOp() instanceof LongConstant)) {
                                throw new RuntimeException("Unhandled neg expression operand type: " + ne.getOp().getClass());
                            }
                        }
                    } else if (r instanceof Local) {
                        Local local = (Local)r;
                        if (local.getType() instanceof IntegerType) {
                            right = this.resolver.typeVariable(local);
                        }
                    } else if (r instanceof InstanceFieldRef) {
                        ref = (InstanceFieldRef)r;
                        if (ref.getFieldRef().type() instanceof IntegerType) {
                            right = this.resolver.typeVariable(ref.getFieldRef().type());
                        }
                    } else {
                        if (!(r instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment right hand side type: " + r.getClass());
                        ref = (StaticFieldRef)r;
                        if (((StaticFieldRef)ref).getFieldRef().type() instanceof IntegerType) {
                            right = this.resolver.typeVariable(((StaticFieldRef)ref).getFieldRef().type());
                        }
                    }
                }
            }
        }
        if (left == null || right == null || left.type() != null && right.type() != null) return;
        right.addParent(left);
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        if (l instanceof Local && ((Local)l).getType() instanceof IntegerType) {
            TypeVariable left = this.resolver.typeVariable((Local)l);
            TypeVariable right = this.resolver.typeVariable(r.getType());
            right.addParent(left);
        }
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        if (this.uses) {
            int value2;
            ConditionExpr cond;
            ConditionExpr expr = cond = (ConditionExpr)stmt.getCondition();
            Value lv = expr.getOp1();
            Value rv = expr.getOp2();
            TypeVariable lop = null;
            TypeVariable rop = null;
            if (lv instanceof Local) {
                if (((Local)lv).getType() instanceof IntegerType) {
                    lop = this.resolver.typeVariable((Local)lv);
                }
            } else if (!(lv instanceof DoubleConstant) && !(lv instanceof FloatConstant)) {
                if (lv instanceof IntConstant) {
                    value2 = ((IntConstant)lv).value;
                    lop = value2 < Short.MIN_VALUE ? this.resolver.INT : (value2 < -128 ? this.resolver.SHORT : (value2 < 0 ? this.resolver.BYTE : (value2 < 2 ? this.resolver.R0_1 : (value2 < 128 ? this.resolver.R0_127 : (value2 < 32768 ? this.resolver.R0_32767 : (value2 < 65536 ? this.resolver.CHAR : this.resolver.INT))))));
                } else if (!(lv instanceof LongConstant || lv instanceof NullConstant || lv instanceof StringConstant || lv instanceof ClassConstant)) {
                    throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
                }
            }
            if (rv instanceof Local) {
                if (((Local)rv).getType() instanceof IntegerType) {
                    rop = this.resolver.typeVariable((Local)rv);
                }
            } else if (!(rv instanceof DoubleConstant) && !(rv instanceof FloatConstant)) {
                if (rv instanceof IntConstant) {
                    value2 = ((IntConstant)rv).value;
                    rop = value2 < Short.MIN_VALUE ? this.resolver.INT : (value2 < -128 ? this.resolver.SHORT : (value2 < 0 ? this.resolver.BYTE : (value2 < 2 ? this.resolver.R0_1 : (value2 < 128 ? this.resolver.R0_127 : (value2 < 32768 ? this.resolver.R0_32767 : (value2 < 65536 ? this.resolver.CHAR : this.resolver.INT))))));
                } else if (!(rv instanceof LongConstant || rv instanceof NullConstant || rv instanceof StringConstant || rv instanceof ClassConstant)) {
                    throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
                }
            }
            if (rop != null && lop != null) {
                TypeVariable common = this.resolver.typeVariable();
                if (rop != null) {
                    rop.addParent(common);
                }
                if (lop != null) {
                    lop.addParent(common);
                }
            }
        }
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        Value key2;
        if (this.uses && (key2 = stmt.getKey()) instanceof Local) {
            this.resolver.typeVariable((Local)key2).addParent(this.resolver.INT);
        }
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local && ((Local)stmt.getOp()).getType() instanceof IntegerType) {
            this.resolver.typeVariable((Local)stmt.getOp()).addParent(this.resolver.typeVariable(this.stmtBody.getMethod().getReturnType()));
        }
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        Value key2;
        if (this.uses && (key2 = stmt.getKey()) instanceof Local) {
            this.resolver.typeVariable((Local)key2).addParent(this.resolver.INT);
        }
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
    }

    public void defaultCase(Stmt stmt) {
        throw new RuntimeException("Unhandled statement type: " + stmt.getClass());
    }
}

