/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Collection;
import java.util.Collections;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.IntType;
import soot.IntegerType;
import soot.ShortType;
import soot.Type;
import soot.jimple.toolkits.typing.fast.BottomType;
import soot.jimple.toolkits.typing.fast.BytecodeHierarchy;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;
import soot.jimple.toolkits.typing.fast.TypeResolver;

public class AugHierarchy
implements IHierarchy {
    @Override
    public Collection<Type> lcas(Type a2, Type b) {
        return AugHierarchy.lcas_(a2, b);
    }

    public static Collection<Type> lcas_(Type a2, Type b) {
        if (TypeResolver.typesEqual(a2, b)) {
            return Collections.singletonList(a2);
        }
        if (a2 instanceof BottomType) {
            return Collections.singletonList(b);
        }
        if (b instanceof BottomType) {
            return Collections.singletonList(a2);
        }
        if (a2 instanceof IntegerType && b instanceof IntegerType) {
            if (a2 instanceof Integer1Type) {
                return Collections.singletonList(b);
            }
            if (b instanceof Integer1Type) {
                return Collections.singletonList(a2);
            }
            if (a2 instanceof BooleanType || b instanceof BooleanType) {
                return Collections.emptyList();
            }
            if (a2 instanceof ByteType && b instanceof Integer32767Type || b instanceof ByteType && a2 instanceof Integer32767Type) {
                return Collections.singletonList(ShortType.v());
            }
            if (a2 instanceof CharType && (b instanceof ShortType || b instanceof ByteType) || b instanceof CharType && (a2 instanceof ShortType || a2 instanceof ByteType)) {
                return Collections.singletonList(IntType.v());
            }
            if (AugHierarchy.ancestor_(a2, b)) {
                return Collections.singletonList(a2);
            }
            return Collections.singletonList(b);
        }
        if (a2 instanceof IntegerType || b instanceof IntegerType) {
            return Collections.emptyList();
        }
        return BytecodeHierarchy.lcas_(a2, b);
    }

    @Override
    public boolean ancestor(Type ancestor, Type child) {
        return AugHierarchy.ancestor_(ancestor, child);
    }

    public static boolean ancestor_(Type ancestor, Type child) {
        if (TypeResolver.typesEqual(ancestor, child)) {
            return true;
        }
        if (ancestor instanceof Integer1Type) {
            return child instanceof BottomType;
        }
        if (ancestor instanceof BooleanType) {
            return child instanceof BottomType || child instanceof Integer1Type;
        }
        if (ancestor instanceof Integer127Type) {
            return child instanceof BottomType || child instanceof Integer1Type;
        }
        if (ancestor instanceof ByteType || ancestor instanceof Integer32767Type) {
            return child instanceof BottomType || child instanceof Integer1Type || child instanceof Integer127Type;
        }
        if (ancestor instanceof CharType) {
            return child instanceof BottomType || child instanceof Integer1Type || child instanceof Integer127Type || child instanceof Integer32767Type;
        }
        if (ancestor instanceof ShortType) {
            return child instanceof BottomType || child instanceof Integer1Type || child instanceof Integer127Type || child instanceof Integer32767Type || child instanceof ByteType;
        }
        if (ancestor instanceof IntType) {
            return child instanceof BottomType || child instanceof Integer1Type || child instanceof Integer127Type || child instanceof Integer32767Type || child instanceof ByteType || child instanceof CharType || child instanceof ShortType;
        }
        if (child instanceof IntegerType) {
            return false;
        }
        return BytecodeHierarchy.ancestor_(ancestor, child);
    }
}

