/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.util.List;
import soot.ArrayType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.RefType;
import soot.SootMethodRef;
import soot.TrapManager;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.ConcreteRef;
import soot.jimple.ConditionExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleBody;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.RemExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.jimple.toolkits.typing.TypeResolver;
import soot.jimple.toolkits.typing.TypeVariable;

class ConstraintCollector
extends AbstractStmtSwitch {
    private TypeResolver resolver;
    private boolean uses;
    private JimpleBody stmtBody;

    public ConstraintCollector(TypeResolver resolver, boolean uses) {
        this.resolver = resolver;
        this.uses = uses;
    }

    public void collect(Stmt stmt, JimpleBody stmtBody) {
        this.stmtBody = stmtBody;
        stmt.apply(this);
    }

    private void handleInvokeExpr(InvokeExpr ie) {
        Local local;
        Value base;
        if (!this.uses) {
            return;
        }
        SootMethodRef method = ie.getMethodRef();
        for (int i = 0; i < ie.getArgCount(); ++i) {
            if (!(ie.getArg(i) instanceof Local)) continue;
            Local local2 = (Local)ie.getArg(i);
            TypeVariable localType = this.resolver.typeVariable(local2);
            localType.addParent(this.resolver.typeVariable(method.parameterType(i)));
        }
        if (ie instanceof InterfaceInvokeExpr) {
            InterfaceInvokeExpr invoke = (InterfaceInvokeExpr)ie;
            base = invoke.getBase();
            if (base instanceof Local) {
                local = (Local)base;
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.declaringClass()));
            }
        } else if (ie instanceof SpecialInvokeExpr) {
            SpecialInvokeExpr invoke = (SpecialInvokeExpr)ie;
            base = invoke.getBase();
            if (base instanceof Local) {
                local = (Local)base;
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.declaringClass()));
            }
        } else if (ie instanceof VirtualInvokeExpr) {
            VirtualInvokeExpr invoke = (VirtualInvokeExpr)ie;
            base = invoke.getBase();
            if (base instanceof Local) {
                local = (Local)base;
                TypeVariable localType = this.resolver.typeVariable(local);
                localType.addParent(this.resolver.typeVariable(method.declaringClass()));
            }
        } else if (!(ie instanceof StaticInvokeExpr)) {
            if (ie instanceof DynamicInvokeExpr) {
                DynamicInvokeExpr invoke = (DynamicInvokeExpr)ie;
                SootMethodRef bootstrapMethod = invoke.getBootstrapMethodRef();
                for (int i = 0; i < invoke.getBootstrapArgCount(); ++i) {
                    if (!(invoke.getArg(i) instanceof Local)) continue;
                    Local local3 = (Local)invoke.getBootstrapArg(i);
                    TypeVariable localType = this.resolver.typeVariable(local3);
                    localType.addParent(this.resolver.typeVariable(bootstrapMethod.parameterType(i)));
                }
            } else {
                throw new RuntimeException("Unhandled invoke expression type: " + ie.getClass());
            }
        }
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        this.handleInvokeExpr(stmt.getInvokeExpr());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        TypeVariable var;
        Value size2;
        Object baseType;
        TypeVariable baseType2;
        Value index;
        Value base;
        ConcreteRef ref;
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        TypeVariable left = null;
        TypeVariable right = null;
        if (l instanceof ArrayRef) {
            ref = (ArrayRef)l;
            base = ref.getBase();
            index = ref.getIndex();
            baseType2 = this.resolver.typeVariable((Local)base);
            baseType2.makeElement();
            left = baseType2.element();
            if (index instanceof Local && this.uses) {
                this.resolver.typeVariable((Local)index).addParent(this.resolver.typeVariable(IntType.v()));
            }
        } else if (l instanceof Local) {
            left = this.resolver.typeVariable((Local)l);
        } else if (l instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)l;
            if (this.uses) {
                baseType = this.resolver.typeVariable((Local)ref.getBase());
                ((TypeVariable)baseType).addParent(this.resolver.typeVariable(ref.getField().getDeclaringClass()));
                left = this.resolver.typeVariable(ref.getField().getType());
            }
        } else {
            if (!(l instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment left hand side type: " + l.getClass());
            if (this.uses) {
                ref = (StaticFieldRef)l;
                left = this.resolver.typeVariable(((StaticFieldRef)ref).getField().getType());
            }
        }
        if (r instanceof ArrayRef) {
            ref = (ArrayRef)r;
            base = ref.getBase();
            index = ref.getIndex();
            baseType2 = this.resolver.typeVariable((Local)base);
            baseType2.makeElement();
            right = baseType2.element();
            if (index instanceof Local && this.uses) {
                this.resolver.typeVariable((Local)index).addParent(this.resolver.typeVariable(IntType.v()));
            }
        } else if (r instanceof DoubleConstant) {
            right = this.resolver.typeVariable(DoubleType.v());
        } else if (r instanceof FloatConstant) {
            right = this.resolver.typeVariable(FloatType.v());
        } else if (r instanceof IntConstant) {
            right = this.resolver.typeVariable(IntType.v());
        } else if (r instanceof LongConstant) {
            right = this.resolver.typeVariable(LongType.v());
        } else if (r instanceof NullConstant) {
            right = this.resolver.typeVariable(NullType.v());
        } else if (r instanceof StringConstant) {
            right = this.resolver.typeVariable(RefType.v("java.lang.String"));
        } else if (r instanceof ClassConstant) {
            right = this.resolver.typeVariable(RefType.v("java.lang.Class"));
        } else if (r instanceof BinopExpr) {
            TypeVariable rop;
            TypeVariable lop;
            BinopExpr be2 = (BinopExpr)r;
            Value lv = be2.getOp1();
            Value rv = be2.getOp2();
            if (lv instanceof Local) {
                lop = this.resolver.typeVariable((Local)lv);
            } else if (lv instanceof DoubleConstant) {
                lop = this.resolver.typeVariable(DoubleType.v());
            } else if (lv instanceof FloatConstant) {
                lop = this.resolver.typeVariable(FloatType.v());
            } else if (lv instanceof IntConstant) {
                lop = this.resolver.typeVariable(IntType.v());
            } else if (lv instanceof LongConstant) {
                lop = this.resolver.typeVariable(LongType.v());
            } else if (lv instanceof NullConstant) {
                lop = this.resolver.typeVariable(NullType.v());
            } else if (lv instanceof StringConstant) {
                lop = this.resolver.typeVariable(RefType.v("java.lang.String"));
            } else {
                if (!(lv instanceof ClassConstant)) throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
                lop = this.resolver.typeVariable(RefType.v("java.lang.Class"));
            }
            if (rv instanceof Local) {
                rop = this.resolver.typeVariable((Local)rv);
            } else if (rv instanceof DoubleConstant) {
                rop = this.resolver.typeVariable(DoubleType.v());
            } else if (rv instanceof FloatConstant) {
                rop = this.resolver.typeVariable(FloatType.v());
            } else if (rv instanceof IntConstant) {
                rop = this.resolver.typeVariable(IntType.v());
            } else if (rv instanceof LongConstant) {
                rop = this.resolver.typeVariable(LongType.v());
            } else if (rv instanceof NullConstant) {
                rop = this.resolver.typeVariable(NullType.v());
            } else if (rv instanceof StringConstant) {
                rop = this.resolver.typeVariable(RefType.v("java.lang.String"));
            } else {
                if (!(rv instanceof ClassConstant)) throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
                rop = this.resolver.typeVariable(RefType.v("java.lang.Class"));
            }
            if (be2 instanceof AddExpr || be2 instanceof SubExpr || be2 instanceof MulExpr || be2 instanceof DivExpr || be2 instanceof RemExpr || be2 instanceof AndExpr || be2 instanceof OrExpr || be2 instanceof XorExpr) {
                if (this.uses) {
                    TypeVariable common = this.resolver.typeVariable();
                    rop.addParent(common);
                    lop.addParent(common);
                }
                if (left != null) {
                    rop.addParent(left);
                    lop.addParent(left);
                }
            } else if (be2 instanceof ShlExpr || be2 instanceof ShrExpr || be2 instanceof UshrExpr) {
                if (this.uses) {
                    rop.addParent(this.resolver.typeVariable(IntType.v()));
                }
                right = lop;
            } else {
                if (!(be2 instanceof CmpExpr) && !(be2 instanceof CmpgExpr) && !(be2 instanceof CmplExpr) && !(be2 instanceof EqExpr) && !(be2 instanceof GeExpr) && !(be2 instanceof GtExpr) && !(be2 instanceof LeExpr) && !(be2 instanceof LtExpr) && !(be2 instanceof NeExpr)) throw new RuntimeException("Unhandled binary expression type: " + be2.getClass());
                if (this.uses) {
                    TypeVariable common = this.resolver.typeVariable();
                    rop.addParent(common);
                    lop.addParent(common);
                }
                right = this.resolver.typeVariable(IntType.v());
            }
        } else if (r instanceof CastExpr) {
            CastExpr ce = (CastExpr)r;
            right = this.resolver.typeVariable(ce.getCastType());
        } else if (r instanceof InstanceOfExpr) {
            right = this.resolver.typeVariable(IntType.v());
        } else if (r instanceof InvokeExpr) {
            InvokeExpr ie = (InvokeExpr)r;
            this.handleInvokeExpr(ie);
            right = this.resolver.typeVariable(ie.getMethodRef().returnType());
        } else if (r instanceof NewArrayExpr) {
            NewArrayExpr nae = (NewArrayExpr)r;
            baseType = nae.getBaseType();
            right = baseType instanceof ArrayType ? this.resolver.typeVariable(ArrayType.v(((ArrayType)baseType).baseType, ((ArrayType)baseType).numDimensions + 1)) : this.resolver.typeVariable(ArrayType.v((Type)baseType, 1));
            if (this.uses && (size2 = nae.getSize()) instanceof Local) {
                var = this.resolver.typeVariable((Local)size2);
                var.addParent(this.resolver.typeVariable(IntType.v()));
            }
        } else if (r instanceof NewExpr) {
            NewExpr na = (NewExpr)r;
            right = this.resolver.typeVariable(na.getBaseType());
        } else if (r instanceof NewMultiArrayExpr) {
            NewMultiArrayExpr nmae = (NewMultiArrayExpr)r;
            right = this.resolver.typeVariable(nmae.getBaseType());
            if (this.uses) {
                for (int i = 0; i < nmae.getSizeCount(); ++i) {
                    size2 = nmae.getSize(i);
                    if (!(size2 instanceof Local)) continue;
                    var = this.resolver.typeVariable((Local)size2);
                    var.addParent(this.resolver.typeVariable(IntType.v()));
                }
            }
        } else if (r instanceof LengthExpr) {
            LengthExpr le = (LengthExpr)r;
            if (this.uses && le.getOp() instanceof Local) {
                this.resolver.typeVariable((Local)le.getOp()).makeElement();
            }
            right = this.resolver.typeVariable(IntType.v());
        } else if (r instanceof NegExpr) {
            NegExpr ne = (NegExpr)r;
            if (ne.getOp() instanceof Local) {
                right = this.resolver.typeVariable((Local)ne.getOp());
            } else if (ne.getOp() instanceof DoubleConstant) {
                right = this.resolver.typeVariable(DoubleType.v());
            } else if (ne.getOp() instanceof FloatConstant) {
                right = this.resolver.typeVariable(FloatType.v());
            } else if (ne.getOp() instanceof IntConstant) {
                right = this.resolver.typeVariable(IntType.v());
            } else {
                if (!(ne.getOp() instanceof LongConstant)) throw new RuntimeException("Unhandled neg expression operand type: " + ne.getOp().getClass());
                right = this.resolver.typeVariable(LongType.v());
            }
        } else if (r instanceof Local) {
            right = this.resolver.typeVariable((Local)r);
        } else if (r instanceof InstanceFieldRef) {
            ref = (InstanceFieldRef)r;
            if (this.uses) {
                baseType = this.resolver.typeVariable((Local)ref.getBase());
                ((TypeVariable)baseType).addParent(this.resolver.typeVariable(ref.getField().getDeclaringClass()));
            }
            right = this.resolver.typeVariable(ref.getField().getType());
        } else {
            if (!(r instanceof StaticFieldRef)) throw new RuntimeException("Unhandled assignment right hand side type: " + r.getClass());
            ref = (StaticFieldRef)r;
            right = this.resolver.typeVariable(((StaticFieldRef)ref).getField().getType());
        }
        if (left == null || right == null) return;
        right.addParent(left);
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
        Value l = stmt.getLeftOp();
        Value r = stmt.getRightOp();
        if (l instanceof Local) {
            TypeVariable left = this.resolver.typeVariable((Local)l);
            if (!(r instanceof CaughtExceptionRef)) {
                TypeVariable right = this.resolver.typeVariable(r.getType());
                right.addParent(left);
            } else {
                List<RefType> exceptionTypes = TrapManager.getExceptionTypesOf(stmt, this.stmtBody);
                for (Type type : exceptionTypes) {
                    this.resolver.typeVariable(type).addParent(left);
                }
                if (this.uses) {
                    left.addParent(this.resolver.typeVariable(RefType.v("java.lang.Throwable")));
                }
            }
        }
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local) {
            TypeVariable op = this.resolver.typeVariable((Local)stmt.getOp());
            op.addParent(this.resolver.typeVariable(RefType.v("java.lang.Object")));
        }
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local) {
            TypeVariable op = this.resolver.typeVariable((Local)stmt.getOp());
            op.addParent(this.resolver.typeVariable(RefType.v("java.lang.Object")));
        }
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        if (this.uses) {
            TypeVariable rop;
            TypeVariable lop;
            ConditionExpr cond;
            ConditionExpr expr = cond = (ConditionExpr)stmt.getCondition();
            Value lv = expr.getOp1();
            Value rv = expr.getOp2();
            if (lv instanceof Local) {
                lop = this.resolver.typeVariable((Local)lv);
            } else if (lv instanceof DoubleConstant) {
                lop = this.resolver.typeVariable(DoubleType.v());
            } else if (lv instanceof FloatConstant) {
                lop = this.resolver.typeVariable(FloatType.v());
            } else if (lv instanceof IntConstant) {
                lop = this.resolver.typeVariable(IntType.v());
            } else if (lv instanceof LongConstant) {
                lop = this.resolver.typeVariable(LongType.v());
            } else if (lv instanceof NullConstant) {
                lop = this.resolver.typeVariable(NullType.v());
            } else if (lv instanceof StringConstant) {
                lop = this.resolver.typeVariable(RefType.v("java.lang.String"));
            } else if (lv instanceof ClassConstant) {
                lop = this.resolver.typeVariable(RefType.v("java.lang.Class"));
            } else {
                throw new RuntimeException("Unhandled binary expression left operand type: " + lv.getClass());
            }
            if (rv instanceof Local) {
                rop = this.resolver.typeVariable((Local)rv);
            } else if (rv instanceof DoubleConstant) {
                rop = this.resolver.typeVariable(DoubleType.v());
            } else if (rv instanceof FloatConstant) {
                rop = this.resolver.typeVariable(FloatType.v());
            } else if (rv instanceof IntConstant) {
                rop = this.resolver.typeVariable(IntType.v());
            } else if (rv instanceof LongConstant) {
                rop = this.resolver.typeVariable(LongType.v());
            } else if (rv instanceof NullConstant) {
                rop = this.resolver.typeVariable(NullType.v());
            } else if (rv instanceof StringConstant) {
                rop = this.resolver.typeVariable(RefType.v("java.lang.String"));
            } else if (rv instanceof ClassConstant) {
                rop = this.resolver.typeVariable(RefType.v("java.lang.Class"));
            } else {
                throw new RuntimeException("Unhandled binary expression right operand type: " + rv.getClass());
            }
            TypeVariable common = this.resolver.typeVariable();
            rop.addParent(common);
            lop.addParent(common);
        }
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        Value key2;
        if (this.uses && (key2 = stmt.getKey()) instanceof Local) {
            this.resolver.typeVariable((Local)key2).addParent(this.resolver.typeVariable(IntType.v()));
        }
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local) {
            this.resolver.typeVariable((Local)stmt.getOp()).addParent(this.resolver.typeVariable(this.stmtBody.getMethod().getReturnType()));
        }
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        Value key2;
        if (this.uses && (key2 = stmt.getKey()) instanceof Local) {
            this.resolver.typeVariable((Local)key2).addParent(this.resolver.typeVariable(IntType.v()));
        }
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
        if (this.uses && stmt.getOp() instanceof Local) {
            TypeVariable op = this.resolver.typeVariable((Local)stmt.getOp());
            op.addParent(this.resolver.typeVariable(RefType.v("java.lang.Throwable")));
        }
    }

    public void defaultCase(Stmt stmt) {
        throw new RuntimeException("Unhandled statement type: " + stmt.getClass());
    }
}

