/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AnyNewExpr;
import soot.jimple.ArrayRef;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.infoflow.FakeJimpleLocal;
import soot.jimple.toolkits.pointer.CodeBlockRWSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionAwareSideEffectAnalysis;
import soot.jimple.toolkits.thread.synchronization.LocksetFlowInfo;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.BackwardFlowAnalysis;

public class LockableReferenceAnalysis
extends BackwardFlowAnalysis<Unit, LocksetFlowInfo> {
    UnitGraph graph;
    SootMethod method;
    CriticalSectionAwareSideEffectAnalysis tasea;
    RWSet contributingRWSet;
    CriticalSection tn;
    Stmt begin;
    boolean lostObjects;
    Map<Ref, EquivalentValue> refToBase;
    Map<Ref, EquivalentValue> refToIndex;
    static Set<SootMethod> analyzing = new HashSet<SootMethod>();
    static int groupNum = 1;

    public LockableReferenceAnalysis(UnitGraph g) {
        super(g);
        this.graph = g;
        this.method = g.getBody().getMethod();
        this.contributingRWSet = null;
        this.tn = null;
        this.begin = null;
        this.lostObjects = false;
        this.refToBase = new HashMap<Ref, EquivalentValue>();
        this.refToIndex = new HashMap<Ref, EquivalentValue>();
    }

    public void printMsg(String msg) {
        G.v().out.print("[wjtp.tn] ");
        for (int i = 0; i < analyzing.size() - 1; ++i) {
            G.v().out.print("  ");
        }
        G.v().out.println(msg);
    }

    public List<EquivalentValue> getLocksetOf(CriticalSectionAwareSideEffectAnalysis tasea, RWSet contributingRWSet, CriticalSection tn) {
        analyzing.add(this.method);
        this.tasea = tasea;
        tasea.setExemptTransaction(tn);
        this.contributingRWSet = contributingRWSet;
        this.tn = tn;
        this.begin = tn == null ? null : tn.beginning;
        this.lostObjects = false;
        this.doAnalysis();
        if (this.lostObjects) {
            this.printMsg("Failed lockset:");
            analyzing.remove(this.method);
            return null;
        }
        ArrayList<EquivalentValue> lockset = new ArrayList<EquivalentValue>();
        LocksetFlowInfo resultsInfo = null;
        Map<EquivalentValue, Integer> results = null;
        if (this.begin == null) {
            for (Unit u : this.graph) {
                resultsInfo = (LocksetFlowInfo)this.getFlowBefore(u);
            }
        } else {
            resultsInfo = (LocksetFlowInfo)this.getFlowBefore(this.begin);
        }
        if (resultsInfo == null) {
            analyzing.remove(this.method);
            throw new RuntimeException("Why is getFlowBefore null???");
        }
        results = resultsInfo.groups;
        HashMap reversed2 = new HashMap();
        for (Map.Entry<EquivalentValue, Integer> e : results.entrySet()) {
            List<EquivalentValue> keys2;
            EquivalentValue key2 = e.getKey();
            Integer value2 = e.getValue();
            if (!reversed2.containsKey(value2)) {
                keys2 = new ArrayList();
                reversed2.put(value2, keys2);
            } else {
                keys2 = (List)reversed2.get(value2);
            }
            keys2.add(key2);
        }
        for (List objects : reversed2.values()) {
            EquivalentValue bestLock = null;
            for (EquivalentValue object : objects) {
                if (bestLock != null && !(object.getValue() instanceof IdentityRef) && (!(object.getValue() instanceof Ref) || bestLock instanceof IdentityRef)) continue;
                bestLock = object;
            }
            Integer group = results.get(bestLock);
            for (Ref ref : resultsInfo.refToBaseGroup.keySet()) {
                if (group != resultsInfo.refToBaseGroup.get(ref)) continue;
                this.refToBase.put(ref, bestLock);
            }
            for (Ref ref : resultsInfo.refToIndexGroup.keySet()) {
                if (group != resultsInfo.refToIndexGroup.get(ref)) continue;
                this.refToIndex.put(ref, bestLock);
            }
            if (group < 0) continue;
            lockset.add(bestLock);
        }
        if (lockset.size() == 0) {
            this.printMsg("Empty lockset: S" + lockset.size() + "/G" + reversed2.keySet().size() + "/O" + results.keySet().size() + " Method:" + this.method + " Begin:" + this.begin + " Result:" + results + " RW:" + contributingRWSet);
            this.printMsg("|= results:" + results + " refToBaseGroup:" + resultsInfo.refToBaseGroup);
        } else {
            this.printMsg("Healthy lockset: S" + lockset.size() + "/G" + reversed2.keySet().size() + "/O" + results.keySet().size() + " " + lockset + " refToBase:" + this.refToBase + " refToIndex:" + this.refToIndex);
            this.printMsg("|= results:" + results + " refToBaseGroup:" + resultsInfo.refToBaseGroup);
        }
        analyzing.remove(this.method);
        return lockset;
    }

    public EquivalentValue baseFor(Ref ref) {
        return this.refToBase.get(ref);
    }

    public EquivalentValue indexFor(Ref ref) {
        return this.refToIndex.get(ref);
    }

    @Override
    protected void merge(LocksetFlowInfo in1, LocksetFlowInfo in2, LocksetFlowInfo out) {
        LocksetFlowInfo tmpInfo = new LocksetFlowInfo();
        this.copy(in1, out);
        this.copy(in2, tmpInfo);
        for (EquivalentValue key2 : tmpInfo.groups.keySet()) {
            Integer newvalue = tmpInfo.groups.get(key2);
            if (!out.groups.containsKey(key2)) {
                out.groups.put(key2, newvalue);
                continue;
            }
            if (out.groups.get(key2) == tmpInfo.groups.get(key2)) continue;
            Integer oldvalue = out.groups.get(key2);
            for (Map.Entry<EquivalentValue, Integer> entry2 : out.groups.entrySet()) {
                if (entry2.getValue() != oldvalue) continue;
                entry2.setValue(newvalue);
            }
            for (Map.Entry<EquivalentValue, Integer> entry3 : tmpInfo.groups.entrySet()) {
                if (entry3.getValue() != oldvalue) continue;
                entry3.setValue(newvalue);
            }
            for (Map.Entry<Value, Integer> entry4 : out.refToBaseGroup.entrySet()) {
                if (entry4.getValue() != oldvalue) continue;
                entry4.setValue(newvalue);
            }
            for (Map.Entry<Value, Integer> entry5 : out.refToIndexGroup.entrySet()) {
                if (entry5.getValue() != oldvalue) continue;
                entry5.setValue(newvalue);
            }
            for (Map.Entry<Value, Integer> entry6 : tmpInfo.refToBaseGroup.entrySet()) {
                if (entry6.getValue() != oldvalue) continue;
                entry6.setValue(newvalue);
            }
            for (Map.Entry<Value, Integer> entry7 : tmpInfo.refToIndexGroup.entrySet()) {
                if (entry7.getValue() != oldvalue) continue;
                entry7.setValue(newvalue);
            }
        }
        for (Ref ref : tmpInfo.refToBaseGroup.keySet()) {
            if (out.refToBaseGroup.containsKey(ref)) continue;
            out.refToBaseGroup.put(ref, tmpInfo.refToBaseGroup.get(ref));
        }
        for (Ref ref : tmpInfo.refToIndexGroup.keySet()) {
            if (out.refToIndexGroup.containsKey(ref)) continue;
            out.refToIndexGroup.put(ref, tmpInfo.refToIndexGroup.get(ref));
        }
    }

    public Integer addFromSubanalysis(LocksetFlowInfo outInfo, LockableReferenceAnalysis la, Stmt stmt, Value lock) {
        Map<EquivalentValue, Integer> out = outInfo.groups;
        InvokeExpr ie = stmt.getInvokeExpr();
        this.printMsg("Attempting to bring up '" + lock + "' from inner lockset at (" + stmt.hashCode() + ") " + stmt);
        if (lock instanceof ThisRef && ie instanceof InstanceInvokeExpr) {
            Value use = ((InstanceInvokeExpr)ie).getBase();
            if (!out.containsKey(new EquivalentValue(use))) {
                int newGroup = groupNum++;
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof ParameterRef) {
            Value use = ie.getArg(((ParameterRef)lock).getIndex());
            if (!out.containsKey(new EquivalentValue(use))) {
                int newGroup = groupNum++;
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof StaticFieldRef) {
            Value use = lock;
            if (!out.containsKey(new EquivalentValue(use))) {
                int newGroup = groupNum++;
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof InstanceFieldRef) {
            EquivalentValue baseEqVal;
            if (((InstanceFieldRef)lock).getBase() instanceof FakeJimpleLocal) {
                ((FakeJimpleLocal)((InstanceFieldRef)lock).getBase()).setInfo(this);
            }
            if ((baseEqVal = la.baseFor((Ref)lock)) == null) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ previously lost base) at " + stmt);
                return 0;
            }
            Value base = baseEqVal.getValue();
            Integer baseGroup = this.addFromSubanalysis(outInfo, la, stmt, base);
            if (baseGroup == 0) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ newly lost base) at " + stmt);
                return 0;
            }
            outInfo.refToBaseGroup.put((Ref)lock, baseGroup);
            Value use = lock;
            if (!out.containsKey(new EquivalentValue(use))) {
                int newGroup = groupNum++;
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof ArrayRef) {
            if (((ArrayRef)lock).getBase() instanceof FakeJimpleLocal) {
                ((FakeJimpleLocal)((ArrayRef)lock).getBase()).setInfo(this);
            }
            if (((ArrayRef)lock).getIndex() instanceof FakeJimpleLocal) {
                ((FakeJimpleLocal)((ArrayRef)lock).getIndex()).setInfo(this);
            }
            EquivalentValue baseEqVal = la.baseFor((Ref)lock);
            EquivalentValue indexEqVal = la.indexFor((Ref)lock);
            if (baseEqVal == null) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ previously lost base) at " + stmt);
                return 0;
            }
            if (indexEqVal == null) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ previously lost index) at " + stmt);
                return 0;
            }
            Value base = baseEqVal.getValue();
            Value index = indexEqVal.getValue();
            Integer baseGroup = this.addFromSubanalysis(outInfo, la, stmt, base);
            if (baseGroup == 0) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ newly lost base) at " + stmt);
                return 0;
            }
            Integer indexGroup = this.addFromSubanalysis(outInfo, la, stmt, index);
            if (indexGroup == 0) {
                this.printMsg("Lost Object from inner Lockset (InstanceFieldRef w/ newly lost index) at " + stmt);
                return 0;
            }
            outInfo.refToBaseGroup.put((Ref)lock, baseGroup);
            outInfo.refToIndexGroup.put((Ref)lock, indexGroup);
            Value use = lock;
            if (!out.containsKey(new EquivalentValue(use))) {
                int newGroup = groupNum++;
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        if (lock instanceof Constant) {
            Value use = lock;
            if (!out.containsKey(new EquivalentValue(use))) {
                int newGroup = groupNum++;
                out.put(new EquivalentValue(use), newGroup);
                return newGroup;
            }
            return out.get(new EquivalentValue(use));
        }
        this.printMsg("Lost Object from inner Lockset (unknown or unhandled object type) at " + stmt);
        return 0;
    }

    @Override
    protected void flowThrough(LocksetFlowInfo inInfo, Unit u, LocksetFlowInfo outInfo) {
        this.copy(inInfo, outInfo);
        Stmt stmt = (Stmt)u;
        Map<EquivalentValue, Integer> out = outInfo.groups;
        if ((this.tn == null || this.tn.units.contains(stmt)) && !this.lostObjects) {
            RWSet stmtWrite;
            CodeBlockRWSet stmtRW = null;
            HashSet allUses = new HashSet();
            RWSet stmtRead = this.tasea.readSet(this.method, stmt, this.tn, allUses);
            if (stmtRead != null) {
                stmtRW = (CodeBlockRWSet)stmtRead;
            }
            if ((stmtWrite = this.tasea.writeSet(this.method, stmt, this.tn, allUses)) != null) {
                if (stmtRW != null) {
                    stmtRW.union(stmtWrite);
                } else {
                    stmtRW = (CodeBlockRWSet)stmtWrite;
                }
            }
            if (stmtRW != null && stmtRW.hasNonEmptyIntersection(this.contributingRWSet)) {
                ArrayRef ar;
                ArrayList<Value> uses = new ArrayList<Value>();
                Iterator allUsesIt = allUses.iterator();
                while (allUsesIt.hasNext()) {
                    RWSet valRW;
                    FieldRef fr;
                    Value value2;
                    Value v = value2 = (Value)allUsesIt.next();
                    if (stmt.containsFieldRef() && (fr = stmt.getFieldRef()) instanceof InstanceFieldRef && ((InstanceFieldRef)fr).getBase() == v) {
                        v = fr;
                    }
                    if (stmt.containsArrayRef() && (ar = stmt.getArrayRef()).getBase() == v) {
                        v = ar;
                    }
                    if ((valRW = this.tasea.valueRWSet(v, this.method, stmt, this.tn)) == null || !valRW.hasNonEmptyIntersection(this.contributingRWSet)) continue;
                    uses.add(value2);
                }
                if (stmt.containsInvokeExpr()) {
                    InvokeExpr invokeExpr = stmt.getInvokeExpr();
                    SootMethod called = invokeExpr.getMethod();
                    if (called.isConcrete()) {
                        if (called.getDeclaringClass().toString().startsWith("java.util") || called.getDeclaringClass().toString().startsWith("java.lang")) {
                            if (uses.size() <= 0) {
                                this.printMsg("Lost Object at library call at " + stmt);
                                this.lostObjects = true;
                            }
                        } else if (!analyzing.contains(called)) {
                            LockableReferenceAnalysis la = new LockableReferenceAnalysis(new BriefUnitGraph(called.retrieveActiveBody()));
                            List<EquivalentValue> innerLockset = la.getLocksetOf(this.tasea, stmtRW, null);
                            if (innerLockset == null || innerLockset.size() <= 0) {
                                this.printMsg("innerLockset: " + (innerLockset == null ? "Lost Objects" : "Mysteriously Empty"));
                                this.lostObjects = true;
                            } else {
                                this.printMsg("innerLockset: " + innerLockset.toString());
                                for (EquivalentValue lockEqVal : innerLockset) {
                                    Value lock = lockEqVal.getValue();
                                    if (this.addFromSubanalysis(outInfo, la, stmt, lock) != 0) continue;
                                    this.lostObjects = true;
                                    this.printMsg("Lost Object in addFromSubanalysis()");
                                    break;
                                }
                            }
                        } else {
                            this.lostObjects = true;
                            this.printMsg("Lost Object due to recursion " + stmt);
                        }
                    } else if (uses.size() <= 0) {
                        this.lostObjects = true;
                        this.printMsg("Lost Object from non-concrete method call at " + stmt);
                    }
                } else if (uses.size() <= 0) {
                    this.lostObjects = true;
                    this.printMsg("Lost Object SOMEHOW at " + stmt);
                }
                Iterator iterator2 = uses.iterator();
                while (iterator2.hasNext() && !this.lostObjects) {
                    Local oldbase;
                    Value use = (Value)iterator2.next();
                    if (use instanceof InstanceFieldRef) {
                        InstanceFieldRef ifr = (InstanceFieldRef)use;
                        oldbase = (Local)ifr.getBase();
                        if (!(oldbase instanceof FakeJimpleLocal)) {
                            FakeJimpleLocal newbase = new FakeJimpleLocal("fakethis", oldbase.getType(), oldbase, this);
                            InstanceFieldRef node = Jimple.v().newInstanceFieldRef(newbase, ifr.getField().makeRef());
                            EquivalentValue nodeEqVal = new EquivalentValue(node);
                            use = node;
                        }
                    } else if (use instanceof ArrayRef) {
                        ar = (ArrayRef)use;
                        oldbase = (Local)ar.getBase();
                        Value oldindex = ar.getIndex();
                        if (!(oldbase instanceof FakeJimpleLocal)) {
                            FakeJimpleLocal newbase = new FakeJimpleLocal("fakethis", oldbase.getType(), oldbase, this);
                            Value newindex = oldindex instanceof Local ? new FakeJimpleLocal("fakeindex", oldindex.getType(), (Local)oldindex, this) : oldindex;
                            ArrayRef node = Jimple.v().newArrayRef(newbase, newindex);
                            EquivalentValue nodeEqVal = new EquivalentValue(node);
                            use = node;
                        }
                    }
                    if (out.containsKey(new EquivalentValue(use))) continue;
                    out.put(new EquivalentValue(use), groupNum++);
                }
            }
        }
        if (this.graph.getBody().getUnits().getSuccOf(stmt) == this.begin) {
            out.clear();
        }
        if ((this.tn == null || this.tn.units.contains(stmt)) && !out.isEmpty() && stmt instanceof DefinitionStmt && !this.lostObjects) {
            Object newindex;
            Local oldbase;
            FakeJimpleLocal newbase;
            DefinitionStmt ds = (DefinitionStmt)stmt;
            EquivalentValue lvalue = new EquivalentValue(ds.getLeftOp());
            if (ds.getLeftOp() instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)ds.getLeftOp();
                Local oldbase2 = (Local)ifr.getBase();
                if (!(oldbase2 instanceof FakeJimpleLocal)) {
                    EquivalentValue equivalentValue;
                    FakeJimpleLocal newbase2 = new FakeJimpleLocal("fakethis", oldbase2.getType(), oldbase2, this);
                    InstanceFieldRef node = Jimple.v().newInstanceFieldRef(newbase2, ifr.getField().makeRef());
                    lvalue = equivalentValue = new EquivalentValue(node);
                }
            } else if (ds.getLeftOp() instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)ds.getLeftOp();
                Local oldbase2 = (Local)ar.getBase();
                Value oldindex = ar.getIndex();
                if (!(oldbase2 instanceof FakeJimpleLocal)) {
                    EquivalentValue nodeEqVal;
                    newbase = new FakeJimpleLocal("fakethis", oldbase2.getType(), oldbase2, this);
                    Value value3 = oldindex instanceof Local ? new FakeJimpleLocal("fakeindex", oldindex.getType(), (Local)oldindex, this) : oldindex;
                    ArrayRef node = Jimple.v().newArrayRef(newbase, value3);
                    lvalue = nodeEqVal = new EquivalentValue(node);
                }
            }
            EquivalentValue rvalue = new EquivalentValue(ds.getRightOp());
            if (ds.getRightOp() instanceof CastExpr) {
                rvalue = new EquivalentValue(((CastExpr)ds.getRightOp()).getOp());
            } else if (ds.getRightOp() instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)ds.getRightOp();
                oldbase = (Local)ifr.getBase();
                if (!(oldbase instanceof FakeJimpleLocal)) {
                    EquivalentValue nodeEqVal;
                    newbase = new FakeJimpleLocal("fakethis", oldbase.getType(), oldbase, this);
                    InstanceFieldRef instanceFieldRef = Jimple.v().newInstanceFieldRef(newbase, ifr.getField().makeRef());
                    rvalue = nodeEqVal = new EquivalentValue(instanceFieldRef);
                }
            } else if (ds.getRightOp() instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)ds.getRightOp();
                oldbase = (Local)ar.getBase();
                Iterator<Map.Entry<Value, Integer>> oldindex = ar.getIndex();
                if (!(oldbase instanceof FakeJimpleLocal)) {
                    EquivalentValue nodeEqVal;
                    FakeJimpleLocal fakeJimpleLocal = new FakeJimpleLocal("fakethis", oldbase.getType(), oldbase, this);
                    newindex = oldindex instanceof Local ? new FakeJimpleLocal("fakeindex", oldindex.getType(), (Local)((Object)oldindex), this) : oldindex;
                    ArrayRef node = Jimple.v().newArrayRef(fakeJimpleLocal, (Value)newindex);
                    rvalue = nodeEqVal = new EquivalentValue(node);
                }
            }
            if (out.containsKey(lvalue)) {
                Integer rvaluevalue;
                Integer lvaluevalue = out.get(lvalue);
                if (stmt instanceof IdentityStmt) {
                    if (out.containsKey(rvalue)) {
                        rvaluevalue = out.get(rvalue);
                        for (Map.Entry<EquivalentValue, Integer> entry2 : out.entrySet()) {
                            if (entry2.getValue() != lvaluevalue) continue;
                            entry2.setValue(rvaluevalue);
                        }
                        for (Map.Entry<Value, Integer> entry3 : outInfo.refToBaseGroup.entrySet()) {
                            if (entry3.getValue() != lvaluevalue) continue;
                            entry3.setValue(rvaluevalue);
                        }
                        for (Map.Entry<Value, Integer> entry4 : outInfo.refToIndexGroup.entrySet()) {
                            if (entry4.getValue() != lvaluevalue) continue;
                            entry4.setValue(rvaluevalue);
                        }
                    } else {
                        out.put(rvalue, lvaluevalue);
                    }
                } else {
                    if (out.containsKey(rvalue)) {
                        rvaluevalue = out.get(rvalue);
                        for (Map.Entry<EquivalentValue, Integer> entry5 : out.entrySet()) {
                            if (entry5.getValue() != lvaluevalue) continue;
                            entry5.setValue(rvaluevalue);
                        }
                        for (Map.Entry<Value, Integer> entry6 : outInfo.refToBaseGroup.entrySet()) {
                            if (entry6.getValue() != lvaluevalue) continue;
                            entry6.setValue(rvaluevalue);
                        }
                        for (Map.Entry<Value, Integer> entry7 : outInfo.refToIndexGroup.entrySet()) {
                            if (entry7.getValue() != lvaluevalue) continue;
                            entry7.setValue(rvaluevalue);
                        }
                    } else if (rvalue.getValue() instanceof Local || rvalue.getValue() instanceof StaticFieldRef || rvalue.getValue() instanceof Constant) {
                        out.put(rvalue, lvaluevalue);
                    } else if (rvalue.getValue() instanceof InstanceFieldRef) {
                        InstanceFieldRef ifr = (InstanceFieldRef)rvalue.getValue();
                        newbase = (FakeJimpleLocal)ifr.getBase();
                        Local local = newbase.getRealLocal();
                        out.put(rvalue, lvaluevalue);
                        Integer baseGroup = out.containsKey(new EquivalentValue(local)) ? out.get(new EquivalentValue(local)) : new Integer(-groupNum++);
                        if (!outInfo.refToBaseGroup.containsKey(ifr)) {
                            outInfo.refToBaseGroup.put(ifr, baseGroup);
                        }
                        out.put(new EquivalentValue(local), baseGroup);
                    } else if (rvalue.getValue() instanceof ArrayRef) {
                        ArrayRef ar = (ArrayRef)rvalue.getValue();
                        newbase = (FakeJimpleLocal)ar.getBase();
                        Local local = newbase.getRealLocal();
                        newindex = ar.getIndex() instanceof FakeJimpleLocal ? (FakeJimpleLocal)ar.getIndex() : null;
                        Value oldindex = newindex != null ? ((FakeJimpleLocal)newindex).getRealLocal() : ar.getIndex();
                        out.put(rvalue, lvaluevalue);
                        Integer indexGroup = out.containsKey(new EquivalentValue(oldindex)) ? out.get(new EquivalentValue(oldindex)) : new Integer(-groupNum++);
                        if (!outInfo.refToIndexGroup.containsKey(ar)) {
                            outInfo.refToIndexGroup.put(ar, indexGroup);
                        }
                        out.put(new EquivalentValue(oldindex), indexGroup);
                        Integer baseGroup = out.containsKey(new EquivalentValue(local)) ? out.get(new EquivalentValue(local)) : new Integer(-groupNum++);
                        if (!outInfo.refToBaseGroup.containsKey(ar)) {
                            outInfo.refToBaseGroup.put(ar, baseGroup);
                        }
                        out.put(new EquivalentValue(local), baseGroup);
                    } else if (rvalue.getValue() instanceof AnyNewExpr) {
                        this.printMsg("Ignored Object (assigned new value) at " + stmt);
                    } else {
                        this.printMsg("Lost Object (assigned unacceptable value) at " + stmt);
                        this.lostObjects = true;
                    }
                    out.remove(lvalue);
                }
            }
        }
    }

    @Override
    protected void copy(LocksetFlowInfo sourceInfo, LocksetFlowInfo destInfo) {
        destInfo.groups.clear();
        destInfo.groups.putAll(sourceInfo.groups);
        destInfo.refToBaseGroup.clear();
        destInfo.refToBaseGroup.putAll(sourceInfo.refToBaseGroup);
        destInfo.refToIndexGroup.clear();
        destInfo.refToIndexGroup.putAll(sourceInfo.refToIndexGroup);
    }

    @Override
    protected LocksetFlowInfo newInitialFlow() {
        return new LocksetFlowInfo();
    }
}

