/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.HashMap;
import java.util.Map;
import soot.EquivalentValue;
import soot.Unit;
import soot.jimple.toolkits.scalar.pre.DelayabilityAnalysis;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;

public class LatestComputation {
    private Map<Unit, FlowSet<EquivalentValue>> unitToLatest;

    public LatestComputation(UnitGraph unitGraph, DelayabilityAnalysis delayed, Map<Unit, EquivalentValue> equivRhsMap) {
        this(unitGraph, delayed, equivRhsMap, new ArrayPackedSet<EquivalentValue>(new CollectionFlowUniverse<EquivalentValue>(equivRhsMap.values())));
    }

    public LatestComputation(UnitGraph unitGraph, DelayabilityAnalysis delayed, Map<Unit, EquivalentValue> equivRhsMap, BoundedFlowSet<EquivalentValue> set2) {
        this.unitToLatest = new HashMap<Unit, FlowSet<EquivalentValue>>(unitGraph.size() + 1, 0.7f);
        for (Unit currentUnit : unitGraph) {
            FlowSet delaySet = (FlowSet)delayed.getFlowBefore(currentUnit);
            FlowSet<EquivalentValue> succCompSet = set2.topSet();
            for (Unit successor : unitGraph.getSuccsOf(currentUnit)) {
                succCompSet.intersection((FlowSet)delayed.getFlowBefore(successor), succCompSet);
            }
            if (equivRhsMap.get(currentUnit) != null) {
                succCompSet.remove(equivRhsMap.get(currentUnit));
            }
            FlowSet latest = delaySet.emptySet();
            delaySet.difference(succCompSet, latest);
            this.unitToLatest.put(currentUnit, latest);
        }
    }

    public FlowSet<EquivalentValue> getFlowBefore(Object node) {
        return this.unitToLatest.get(node);
    }
}

