/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.EquivalentValue;
import soot.G;
import soot.SideEffectTester;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.AvailableExpressions;
import soot.jimple.toolkits.scalar.FastAvailableExpressionsAnalysis;
import soot.jimple.toolkits.scalar.ToppedSet;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;
import soot.util.HashChain;

public class FastAvailableExpressions
implements AvailableExpressions {
    Map<Unit, List<UnitValueBoxPair>> unitToPairsAfter;
    Map<Unit, List<UnitValueBoxPair>> unitToPairsBefore;
    Map<Unit, Chain<EquivalentValue>> unitToEquivsAfter;
    Map<Unit, Chain<EquivalentValue>> unitToEquivsBefore;

    public FastAvailableExpressions(Body b, SideEffectTester st) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "] Finding available expressions...");
        }
        FastAvailableExpressionsAnalysis analysis = new FastAvailableExpressionsAnalysis(new ExceptionalUnitGraph(b), b.getMethod(), st);
        this.unitToPairsAfter = new HashMap<Unit, List<UnitValueBoxPair>>(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToPairsBefore = new HashMap<Unit, List<UnitValueBoxPair>>(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToEquivsAfter = new HashMap<Unit, Chain<EquivalentValue>>(b.getUnits().size() * 2 + 1, 0.7f);
        this.unitToEquivsBefore = new HashMap<Unit, Chain<EquivalentValue>>(b.getUnits().size() * 2 + 1, 0.7f);
        for (Unit s2 : b.getUnits()) {
            EquivalentValue ev;
            UnitValueBoxPair p;
            Stmt containingStmt;
            FlowSet set2 = (FlowSet)analysis.getFlowBefore(s2);
            ArrayList<UnitValueBoxPair> pairsBefore = new ArrayList<UnitValueBoxPair>();
            ArrayList<UnitValueBoxPair> pairsAfter = new ArrayList<UnitValueBoxPair>();
            HashChain<EquivalentValue> equivsBefore = new HashChain<EquivalentValue>();
            HashChain<EquivalentValue> equivsAfter = new HashChain<EquivalentValue>();
            if (set2 instanceof ToppedSet && ((ToppedSet)set2).isTop()) {
                throw new RuntimeException("top! on " + s2);
            }
            for (Value v : set2) {
                containingStmt = (Stmt)analysis.rhsToContainingStmt.get(v);
                p = new UnitValueBoxPair(containingStmt, ((AssignStmt)containingStmt).getRightOpBox());
                pairsBefore.add(p);
                ev = new EquivalentValue(v);
                if (equivsBefore.contains(ev)) continue;
                equivsBefore.add(ev);
            }
            this.unitToPairsBefore.put(s2, pairsBefore);
            this.unitToEquivsBefore.put(s2, equivsBefore);
            for (Value v : (FlowSet)analysis.getFlowAfter(s2)) {
                containingStmt = (Stmt)analysis.rhsToContainingStmt.get(v);
                p = new UnitValueBoxPair(containingStmt, ((AssignStmt)containingStmt).getRightOpBox());
                pairsAfter.add(p);
                ev = new EquivalentValue(v);
                if (equivsAfter.contains(ev)) continue;
                equivsAfter.add(ev);
            }
            this.unitToPairsAfter.put(s2, pairsAfter);
            this.unitToEquivsAfter.put(s2, equivsAfter);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "]     Found available expressions...");
        }
    }

    @Override
    public List<UnitValueBoxPair> getAvailablePairsBefore(Unit u) {
        return this.unitToPairsBefore.get(u);
    }

    @Override
    public Chain<EquivalentValue> getAvailableEquivsBefore(Unit u) {
        return this.unitToEquivsBefore.get(u);
    }

    @Override
    public List<UnitValueBoxPair> getAvailablePairsAfter(Unit u) {
        return this.unitToPairsAfter.get(u);
    }

    @Override
    public Chain<EquivalentValue> getAvailableEquivsAfter(Unit u) {
        return this.unitToEquivsAfter.get(u);
    }
}

