/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.EquivalentValue;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.EqualLocalsAnalysis;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

@Deprecated
public class EqualUsesAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet> {
    Map<Stmt, Local> stmtToLocal;
    Set<Stmt> useStmts = null;
    Collection<Local> useLocals = null;
    List boundaryStmts = null;
    List<Stmt> redefStmts = null;
    Map<Stmt, List> firstUseToAliasSet = null;
    EqualLocalsAnalysis el;

    public EqualUsesAnalysis(UnitGraph g) {
        super(g);
        this.el = new EqualLocalsAnalysis(g);
    }

    public boolean areEqualUses(Stmt firstStmt, Local firstLocal, Stmt secondStmt, Local secondLocal) {
        HashMap<Stmt, Local> stmtToLocal = new HashMap<Stmt, Local>();
        stmtToLocal.put(firstStmt, firstLocal);
        stmtToLocal.put(secondStmt, secondLocal);
        return this.areEqualUses(stmtToLocal, new ArrayList());
    }

    public boolean areEqualUses(Stmt firstStmt, Local firstLocal, Stmt secondStmt, Local secondLocal, List boundaryStmts) {
        HashMap<Stmt, Local> stmtToLocal = new HashMap<Stmt, Local>();
        stmtToLocal.put(firstStmt, firstLocal);
        stmtToLocal.put(secondStmt, secondLocal);
        return this.areEqualUses(stmtToLocal, boundaryStmts);
    }

    public boolean areEqualUses(Map<Stmt, Local> stmtToLocal) {
        return this.areEqualUses(stmtToLocal, new ArrayList());
    }

    public boolean areEqualUses(Map<Stmt, Local> stmtToLocal, List boundaryStmts) {
        this.stmtToLocal = stmtToLocal;
        this.useStmts = stmtToLocal.keySet();
        this.useLocals = stmtToLocal.values();
        this.boundaryStmts = boundaryStmts;
        this.redefStmts = new ArrayList<Stmt>();
        this.firstUseToAliasSet = new HashMap<Stmt, List>();
        this.doAnalysis();
        for (Unit unit : this.useStmts) {
            FlowSet fs = (FlowSet)this.getFlowBefore(unit);
            Iterator<Stmt> redefIt = this.redefStmts.iterator();
            while (redefIt.hasNext()) {
                if (!fs.contains(redefIt.next())) continue;
                return false;
            }
            List aliases = null;
            for (Object o : fs) {
                if (!(o instanceof List)) continue;
                aliases = (List)o;
            }
            if (aliases == null || aliases.contains(new EquivalentValue(stmtToLocal.get(unit)))) continue;
            return false;
        }
        return true;
    }

    public Map<Stmt, List> getFirstUseToAliasSet() {
        return this.firstUseToAliasSet;
    }

    @Override
    protected void merge(FlowSet inSet1, FlowSet inSet2, FlowSet outSet) {
        inSet1.union(inSet2, outSet);
        List aliases1 = null;
        List aliases2 = null;
        for (Object o : outSet) {
            if (!(o instanceof List)) continue;
            if (aliases1 == null) {
                aliases1 = (List)o;
                continue;
            }
            aliases2 = (List)o;
        }
        if (aliases1 != null && aliases2 != null) {
            outSet.remove(aliases2);
            Iterator aliasIt = aliases1.iterator();
            while (aliasIt.hasNext()) {
                Object o = aliasIt.next();
                if (aliases2.contains(o)) continue;
                aliasIt.remove();
            }
        }
    }

    @Override
    protected void flowThrough(FlowSet in, Unit unit, FlowSet out) {
        block14: {
            Stmt stmt = (Stmt)unit;
            in.copy(out);
            ArrayList<Value> newDefs = new ArrayList<Value>();
            Iterator<ValueBox> newDefBoxesIt = stmt.getDefBoxes().iterator();
            while (newDefBoxesIt.hasNext()) {
                newDefs.add(newDefBoxesIt.next().getValue());
            }
            for (Local useLocal : this.useLocals) {
                if (!newDefs.contains(useLocal)) continue;
                for (Object o : out) {
                    Stmt s2;
                    if (!(o instanceof Stmt) || this.stmtToLocal.get(s2 = (Stmt)o) != useLocal) continue;
                    this.redefStmts.add(stmt);
                }
            }
            if (this.redefStmts.contains(stmt)) {
                out.add(stmt);
            }
            if (this.boundaryStmts.contains(stmt)) {
                out.clear();
            }
            if (this.useStmts.contains(stmt)) {
                if (out.size() == 0) {
                    Local l = this.stmtToLocal.get(stmt);
                    List aliasList = this.el.getCopiesOfAt(l, stmt);
                    if (aliasList.size() == 0) {
                        aliasList.add(l);
                    }
                    ArrayList newAliasList = new ArrayList();
                    newAliasList.addAll(aliasList);
                    this.firstUseToAliasSet.put(stmt, newAliasList);
                    out.add(aliasList);
                }
                out.add(stmt);
            }
            if (!(stmt instanceof DefinitionStmt)) break block14;
            List aliases = null;
            for (Object o : out) {
                if (!(o instanceof List)) continue;
                aliases = (List)o;
            }
            if (aliases != null) {
                Iterator newDefsIt;
                if (aliases.contains(new EquivalentValue(((DefinitionStmt)stmt).getRightOp()))) {
                    newDefsIt = newDefs.iterator();
                    while (newDefsIt.hasNext()) {
                        aliases.add(new EquivalentValue((Value)newDefsIt.next()));
                    }
                } else {
                    newDefsIt = newDefs.iterator();
                    while (newDefsIt.hasNext()) {
                        aliases.remove(new EquivalentValue((Value)newDefsIt.next()));
                    }
                }
            }
        }
    }

    @Override
    protected void copy(FlowSet source, FlowSet dest) {
        source.copy(dest);
    }

    @Override
    protected FlowSet entryInitialFlow() {
        return new ArraySparseSet();
    }

    @Override
    protected FlowSet newInitialFlow() {
        return new ArraySparseSet();
    }
}

