/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.Targets;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class ReachableMethods {
    private CallGraph cg;
    private Iterator<Edge> edgeSource;
    private final ChunkedQueue<MethodOrMethodContext> reachables = new ChunkedQueue();
    private final Set<MethodOrMethodContext> set = new HashSet<MethodOrMethodContext>();
    private QueueReader<MethodOrMethodContext> unprocessedMethods;
    private final QueueReader<MethodOrMethodContext> allReachables = this.reachables.reader();
    private Filter filter;

    public ReachableMethods(CallGraph graph, Iterator<MethodOrMethodContext> entryPoints) {
        this(graph, entryPoints, null);
    }

    public ReachableMethods(CallGraph graph, Iterator<MethodOrMethodContext> entryPoints, Filter filter2) {
        this.filter = filter2;
        this.cg = graph;
        this.addMethods(entryPoints);
        this.unprocessedMethods = this.reachables.reader();
        this.edgeSource = graph.listener();
        if (filter2 != null) {
            this.edgeSource = filter2.wrap(this.edgeSource);
        }
    }

    public ReachableMethods(CallGraph graph, Collection<MethodOrMethodContext> entryPoints) {
        this(graph, entryPoints.iterator());
    }

    private void addMethods(Iterator<MethodOrMethodContext> methods) {
        while (methods.hasNext()) {
            this.addMethod(methods.next());
        }
    }

    private void addMethod(MethodOrMethodContext m) {
        if (this.set.add(m)) {
            this.reachables.add(m);
        }
    }

    public void update() {
        while (this.edgeSource.hasNext()) {
            Edge e = this.edgeSource.next();
            if (!this.set.contains(e.getSrc())) continue;
            this.addMethod(e.getTgt());
        }
        while (this.unprocessedMethods.hasNext()) {
            MethodOrMethodContext m = this.unprocessedMethods.next();
            Iterator<Edge> targets = this.cg.edgesOutOf(m);
            if (this.filter != null) {
                targets = this.filter.wrap(targets);
            }
            this.addMethods(new Targets(targets));
        }
    }

    public QueueReader<MethodOrMethodContext> listener() {
        return this.allReachables.clone();
    }

    public QueueReader<MethodOrMethodContext> newListener() {
        return this.reachables.reader();
    }

    public boolean contains(MethodOrMethodContext m) {
        return this.set.contains(m);
    }

    public int size() {
        return this.set.size();
    }
}

