/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.parity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Value;
import soot.ValueBox;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.parity.ParityAnalysis;
import soot.options.Options;
import soot.tagkit.ColorTag;
import soot.tagkit.KeyTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;

public class ParityTagger
extends BodyTransformer {
    public ParityTagger(Singletons.Global g) {
    }

    public static ParityTagger v() {
        return G.v().soot_jimple_toolkits_annotation_parity_ParityTagger();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        ParityAnalysis a2;
        boolean isInteractive = Options.v().interactive_mode();
        Options.v().set_interactive_mode(false);
        if (isInteractive) {
            SimpleLiveLocals sll = new SimpleLiveLocals(new BriefUnitGraph(b));
            Options.v().set_interactive_mode(isInteractive);
            ParityAnalysis a3 = new ParityAnalysis(new BriefUnitGraph(b), sll);
        } else {
            a2 = new ParityAnalysis(new BriefUnitGraph(b));
        }
        for (Stmt stmt : b.getUnits()) {
            String type;
            HashMap parityVars = (HashMap)a2.getFlowAfter(stmt);
            for (Value variable : parityVars.keySet()) {
                if (variable instanceof IntConstant || variable instanceof LongConstant) continue;
                StringTag t = new StringTag("Parity variable: " + variable + " " + parityVars.get(variable), "Parity Analysis");
                stmt.addTag(t);
            }
            HashMap parityVarsUses = (HashMap)a2.getFlowBefore(stmt);
            HashMap parityVarsDefs = (HashMap)a2.getFlowAfter(stmt);
            for (ValueBox vb : stmt.getUseBoxes()) {
                if (!parityVarsUses.containsKey(vb.getValue())) continue;
                type = (String)parityVarsUses.get(vb.getValue());
                this.addColorTag(vb, type);
            }
            for (ValueBox vb : stmt.getDefBoxes()) {
                if (!parityVarsDefs.containsKey(vb.getValue())) continue;
                type = (String)parityVarsDefs.get(vb.getValue());
                this.addColorTag(vb, type);
            }
        }
        Iterator<Tag> iterator2 = b.getMethod().getDeclaringClass().getTags().iterator();
        boolean keysAdded = false;
        while (iterator2.hasNext()) {
            Tag next2 = iterator2.next();
            if (!(next2 instanceof KeyTag) || !((KeyTag)next2).analysisType().equals("Parity Analysis")) continue;
            keysAdded = true;
        }
        if (!keysAdded) {
            b.getMethod().getDeclaringClass().addTag(new KeyTag(255, 0, 0, "Parity: Top", "Parity Analysis"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(45, 255, 84, "Parity: Bottom", "Parity Analysis"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(255, 248, 35, "Parity: Even", "Parity Analysis"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(174, 210, 255, "Parity: Odd", "Parity Analysis"));
        }
    }

    private void addColorTag(ValueBox vb, String type) {
        if (type.equals("bottom")) {
            vb.addTag(new ColorTag(1, "Parity Analysis"));
        } else if (type.equals("top")) {
            vb.addTag(new ColorTag(0, "Parity Analysis"));
        } else if (type.equals("even")) {
            vb.addTag(new ColorTag(2, "Parity Analysis"));
        } else if (type.equals("odd")) {
            vb.addTag(new ColorTag(3, "Parity Analysis"));
        }
    }
}

