/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.Immediate;
import soot.Local;
import soot.RefLikeType;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.internal.JCastExpr;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.BackwardFlowAnalysis;

public class NullnessAssumptionAnalysis
extends BackwardFlowAnalysis {
    protected static final Object BOTTOM = new Object(){

        public String toString() {
            return "bottom";
        }
    };
    protected static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };
    protected static final Object NON_NULL = new Object(){

        public String toString() {
            return "non-null";
        }
    };
    protected static final Object TOP = new Object(){

        public String toString() {
            return "top";
        }
    };

    public NullnessAssumptionAnalysis(UnitGraph graph) {
        super(graph);
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        AnalysisInfo in = (AnalysisInfo)inValue;
        AnalysisInfo out = new AnalysisInfo((Map)in);
        Stmt s2 = (Stmt)unit;
        if (s2 instanceof MonitorStmt) {
            MonitorStmt monitorStmt = (MonitorStmt)s2;
            out.put(monitorStmt.getOp(), NON_NULL);
        }
        if (s2.containsArrayRef()) {
            ArrayRef arrayRef = s2.getArrayRef();
            this.handleArrayRef(arrayRef, out);
        }
        if (s2.containsFieldRef()) {
            FieldRef fieldRef = s2.getFieldRef();
            this.handleFieldRef(fieldRef, out);
        }
        if (s2.containsInvokeExpr()) {
            InvokeExpr invokeExpr = s2.getInvokeExpr();
            this.handleInvokeExpr(invokeExpr, out);
        }
        for (Map.Entry entry2 : out.entrySet()) {
            Value v = (Value)entry2.getKey();
            if (!this.isAlwaysNonNull(v)) continue;
            entry2.setValue(NON_NULL);
        }
        if (s2 instanceof DefinitionStmt) {
            AnalysisInfo temp = new AnalysisInfo((Map)out);
            DefinitionStmt definitionStmt = (DefinitionStmt)s2;
            if (definitionStmt.getLeftOp().getType() instanceof RefLikeType) {
                this.handleRefTypeAssignment(definitionStmt, temp, out);
            }
        }
        Iterator outIter = out.keySet().iterator();
        while (outIter.hasNext()) {
            Value value2 = (Value)((Object)outIter.next());
            if (value2 instanceof Local) continue;
            outIter.remove();
        }
        this.copy(out, outValue);
    }

    protected boolean isAlwaysNonNull(Value v) {
        return false;
    }

    private void handleArrayRef(ArrayRef arrayRef, AnalysisInfo out) {
        Value array = arrayRef.getBase();
        out.put(array, NON_NULL);
    }

    private void handleFieldRef(FieldRef fieldRef, AnalysisInfo out) {
        if (fieldRef instanceof InstanceFieldRef) {
            InstanceFieldRef instanceFieldRef = (InstanceFieldRef)fieldRef;
            Value base = instanceFieldRef.getBase();
            out.put(base, NON_NULL);
        }
    }

    private void handleInvokeExpr(InvokeExpr invokeExpr, AnalysisInfo out) {
        if (invokeExpr instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
            Value base = instanceInvokeExpr.getBase();
            out.put(base, NON_NULL);
        }
    }

    private void handleRefTypeAssignment(DefinitionStmt assignStmt, AnalysisInfo rhsInfo, AnalysisInfo out) {
        Value left = assignStmt.getLeftOp();
        Value right = assignStmt.getRightOp();
        if (right instanceof JCastExpr) {
            JCastExpr castExpr = (JCastExpr)right;
            right = castExpr.getOp();
        }
        rhsInfo.put(right, BOTTOM);
        out.put(left, rhsInfo.get(right));
    }

    @Override
    protected void copy(Object source, Object dest) {
        Map s2 = (Map)source;
        Map d = (Map)dest;
        d.clear();
        d.putAll(s2);
    }

    @Override
    protected Object entryInitialFlow() {
        return new AnalysisInfo();
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        AnalysisInfo left = (AnalysisInfo)in1;
        AnalysisInfo right = (AnalysisInfo)in2;
        AnalysisInfo res = (AnalysisInfo)out;
        HashSet values2 = new HashSet();
        values2.addAll(left.keySet());
        values2.addAll(right.keySet());
        res.clear();
        for (Value v : values2) {
            HashSet<Object> leftAndRight = new HashSet<Object>();
            leftAndRight.add(left.get(v));
            leftAndRight.add(right.get(v));
            Object result2 = leftAndRight.contains(BOTTOM) ? BOTTOM : (leftAndRight.contains(NON_NULL) ? (leftAndRight.contains(NULL) ? BOTTOM : NON_NULL) : (leftAndRight.contains(NULL) ? NULL : BOTTOM));
            res.put(v, result2);
        }
    }

    @Override
    protected Object newInitialFlow() {
        return new AnalysisInfo();
    }

    public boolean isAssumedNullBefore(Unit s2, Immediate i) {
        AnalysisInfo ai = (AnalysisInfo)this.getFlowBefore(s2);
        return ai.get(i) == NULL;
    }

    public boolean isAssumedNonNullBefore(Unit s2, Immediate i) {
        AnalysisInfo ai = (AnalysisInfo)this.getFlowBefore(s2);
        return ai.get(i) == NON_NULL;
    }

    protected static class AnalysisInfo
    extends HashMap {
        public AnalysisInfo() {
        }

        public AnalysisInfo(Map m) {
            super(m);
        }

        @Override
        public Object get(Object key2) {
            Object object = super.get(key2);
            if (object == null) {
                return BOTTOM;
            }
            return object;
        }
    }
}

